/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.http;

import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.ErrorCode;
import io.apicurio.registry.ccompat.rest.error.ReferenceExistsException;
import io.apicurio.registry.ccompat.rest.error.SchemaNotFoundException;
import io.apicurio.registry.ccompat.rest.error.SchemaNotSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SchemaSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SubjectNotSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SubjectSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.metrics.health.liveness.LivenessUtil;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.rest.v2.beans.Error;
import io.apicurio.registry.rest.v2.beans.RuleViolationCause;
import io.apicurio.registry.rest.v2.beans.RuleViolationError;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.services.http.HttpStatusCodeMap;
import io.apicurio.registry.storage.error.AlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.ContentNotFoundException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@ApplicationScoped
public class CCompatExceptionMapperService {
    private static final Map<Class<? extends Exception>, Integer> CONFLUENT_CODE_MAP;
    @Inject
    Logger log;
    @Inject
    ResponseErrorLivenessCheck liveness;
    @Inject
    LivenessUtil livenessUtil;
    @Inject
    HttpStatusCodeMap codeMap;

    public Response mapException(Throwable t) {
        Response.ResponseBuilder builder;
        int code = 0;
        Response response = null;
        if (t instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)t;
            response = wae.getResponse();
            code = response.getStatus();
        } else {
            code = this.codeMap.getCode(t.getClass());
        }
        if (code == 500) {
            if (!this.livenessUtil.isIgnoreError(t)) {
                this.liveness.suspectWithException(t);
            }
            this.log.error("[500 ERROR DETECTED] : " + t.getMessage(), t);
        }
        if (response != null) {
            builder = Response.fromResponse((Response)response);
        } else {
            Error error = this.toError(t);
            builder = Response.status((int)code).entity((Object)error);
        }
        return builder.type("application/json").build();
    }

    private Error toError(Throwable t) {
        Error error;
        if (t instanceof RuleViolationException) {
            RuleViolationException rve = (RuleViolationException)t;
            error = new RuleViolationError();
            ((RuleViolationError)error).setCauses(this.toRestCauses(rve.getCauses()));
        } else {
            error = new Error();
        }
        error.setErrorCode(CONFLUENT_CODE_MAP.getOrDefault(t.getClass(), 0));
        error.setMessage(t.getLocalizedMessage());
        return error;
    }

    private List<RuleViolationCause> toRestCauses(Set<RuleViolation> violations) {
        if (violations == null) {
            return null;
        }
        return violations.stream().map(violation -> {
            RuleViolationCause cause = new RuleViolationCause();
            cause.setContext(violation.getContext());
            cause.setDescription(violation.getDescription());
            return cause;
        }).collect(Collectors.toList());
    }

    static {
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        map.put(AlreadyExistsException.class, 409);
        map.put(ArtifactAlreadyExistsException.class, 409);
        map.put(ArtifactNotFoundException.class, ErrorCode.SUBJECT_NOT_FOUND.value());
        map.put(ContentNotFoundException.class, ErrorCode.SCHEMA_NOT_FOUND.value());
        map.put(RuleViolationException.class, ErrorCode.INVALID_COMPATIBILITY_LEVEL.value());
        map.put(VersionNotFoundException.class, ErrorCode.VERSION_NOT_FOUND.value());
        map.put(UnprocessableEntityException.class, ErrorCode.INVALID_SCHEMA.value());
        map.put(ConflictException.class, 409);
        map.put(SubjectNotSoftDeletedException.class, ErrorCode.SUBJECT_NOT_SOFT_DELETED.value());
        map.put(SchemaNotSoftDeletedException.class, ErrorCode.SCHEMA_VERSION_NOT_SOFT_DELETED.value());
        map.put(SchemaSoftDeletedException.class, ErrorCode.SCHEMA_VERSION_SOFT_DELETED.value());
        map.put(SubjectSoftDeletedException.class, ErrorCode.SUBJECT_SOFT_DELETED.value());
        map.put(ReferenceExistsException.class, ErrorCode.REFERENCE_EXISTS.value());
        map.put(SchemaNotFoundException.class, ErrorCode.SCHEMA_NOT_FOUND.value());
        CONFLUENT_CODE_MAP = Collections.unmodifiableMap(map);
    }
}

