/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.http;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.metrics.health.liveness.LivenessUtil;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.rest.v3.beans.ProblemDetails;
import io.apicurio.registry.rest.v3.beans.RuleViolationCause;
import io.apicurio.registry.rest.v3.beans.RuleViolationProblemDetails;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.services.http.HttpStatusCodeMap;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class CoreRegistryExceptionMapperService {
    @Inject
    Logger log;
    @Inject
    ResponseErrorLivenessCheck liveness;
    @Inject
    LivenessUtil livenessUtil;
    @Inject
    HttpStatusCodeMap codeMap;
    @ConfigProperty(name="apicurio.api.errors.include-stack-in-response", defaultValue="false")
    @Info(category="api", description="Include stack trace in errors responses", availableSince="2.1.4.Final")
    boolean includeStackTrace;

    public Response mapException(Throwable t) {
        int code;
        Response response = null;
        if (t instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)t;
            response = wae.getResponse();
            code = response.getStatus();
        } else {
            code = this.codeMap.getCode(t.getClass());
        }
        if (code == 500) {
            if (!this.livenessUtil.isIgnoreError(t)) {
                this.liveness.suspectWithException(t);
            }
            this.log.error("[500 ERROR DETECTED] : " + t.getMessage(), t);
        }
        Response.ResponseBuilder builder = response != null ? Response.fromResponse((Response)response) : Response.status((int)code);
        ProblemDetails error = this.toProblemDetails(t, code);
        return builder.entity((Object)error).type("application/json").build();
    }

    private ProblemDetails toProblemDetails(Throwable t, int code) {
        ProblemDetails details;
        if (t instanceof RuleViolationException) {
            RuleViolationException rve = (RuleViolationException)t;
            details = new RuleViolationProblemDetails();
            ((RuleViolationProblemDetails)details).setCauses(this.toRestCauses(rve.getCauses()));
        } else {
            details = new ProblemDetails();
        }
        details.setStatus(code);
        details.setTitle(t.getLocalizedMessage());
        details.setName(t.getClass().getSimpleName());
        if (this.includeStackTrace) {
            details.setDetail(CoreRegistryExceptionMapperService.getStackTrace(t));
        } else {
            details.setDetail(CoreRegistryExceptionMapperService.getRootMessage(t));
        }
        return details;
    }

    private List<RuleViolationCause> toRestCauses(Set<RuleViolation> violations) {
        if (violations == null) {
            return null;
        }
        return violations.stream().map(violation -> {
            RuleViolationCause cause = new RuleViolationCause();
            cause.setContext(violation.getContext());
            cause.setDescription(violation.getDescription());
            return cause;
        }).collect(Collectors.toList());
    }

    private static String getStackTrace(Throwable t) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            t.printStackTrace(new PrintWriter(writer));
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        writer.close();
        return string;
    }

    private static String getRootMessage(Throwable t) {
        return ExceptionUtils.getRootCauseMessage((Throwable)t);
    }
}

