/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services.http;

import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.ReferenceExistsException;
import io.apicurio.registry.ccompat.rest.error.SchemaNotFoundException;
import io.apicurio.registry.ccompat.rest.error.SchemaNotSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SchemaSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SubjectNotSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.SubjectSoftDeletedException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.content.dereference.DereferencingNotSupportedException;
import io.apicurio.registry.limits.LimitExceededException;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.ParametersConflictException;
import io.apicurio.registry.rules.DefaultRuleDeletionException;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.UnprocessableSchemaException;
import io.apicurio.registry.storage.error.AlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.BranchAlreadyExistsException;
import io.apicurio.registry.storage.error.BranchNotFoundException;
import io.apicurio.registry.storage.error.ConfigPropertyNotFoundException;
import io.apicurio.registry.storage.error.ContentNotFoundException;
import io.apicurio.registry.storage.error.DownloadNotFoundException;
import io.apicurio.registry.storage.error.GroupAlreadyExistsException;
import io.apicurio.registry.storage.error.GroupNotFoundException;
import io.apicurio.registry.storage.error.InvalidArtifactIdException;
import io.apicurio.registry.storage.error.InvalidArtifactStateException;
import io.apicurio.registry.storage.error.InvalidArtifactTypeException;
import io.apicurio.registry.storage.error.InvalidGroupIdException;
import io.apicurio.registry.storage.error.InvalidPropertyValueException;
import io.apicurio.registry.storage.error.InvalidVersionStateException;
import io.apicurio.registry.storage.error.LogConfigurationNotFoundException;
import io.apicurio.registry.storage.error.NotAllowedException;
import io.apicurio.registry.storage.error.NotFoundException;
import io.apicurio.registry.storage.error.ReadOnlyStorageException;
import io.apicurio.registry.storage.error.RoleMappingAlreadyExistsException;
import io.apicurio.registry.storage.error.RoleMappingNotFoundException;
import io.apicurio.registry.storage.error.RuleAlreadyExistsException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.storage.error.VersionAlreadyExistsException;
import io.apicurio.registry.storage.error.VersionAlreadyExistsOnBranchException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.smallrye.mutiny.TimeoutException;
import jakarta.inject.Singleton;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.BadRequestException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Singleton
public class HttpStatusCodeMap {
    private static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    protected static final Map<Class<? extends Exception>, Integer> CODE_MAP;

    private static Set<Class<? extends Exception>> getIgnored() {
        return CODE_MAP.keySet();
    }

    public int getCode(Class<?> exceptionClass) {
        return CODE_MAP.getOrDefault(exceptionClass, 500);
    }

    public boolean isIgnored(Class<? extends Throwable> aClass) {
        return HttpStatusCodeMap.getIgnored().contains(aClass);
    }

    static {
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        map.put(AlreadyExistsException.class, 409);
        map.put(ArtifactAlreadyExistsException.class, 409);
        map.put(ArtifactNotFoundException.class, 404);
        map.put(BadRequestException.class, 400);
        map.put(BranchAlreadyExistsException.class, 409);
        map.put(BranchNotFoundException.class, 404);
        map.put(ConfigPropertyNotFoundException.class, 404);
        map.put(ConflictException.class, 409);
        map.put(ContentNotFoundException.class, 404);
        map.put(DefaultRuleDeletionException.class, 409);
        map.put(DownloadNotFoundException.class, 404);
        map.put(ForbiddenException.class, 403);
        map.put(GroupNotFoundException.class, 404);
        map.put(GroupAlreadyExistsException.class, 409);
        map.put(InvalidArtifactIdException.class, 400);
        map.put(InvalidArtifactStateException.class, 400);
        map.put(InvalidVersionStateException.class, 400);
        map.put(InvalidArtifactTypeException.class, 400);
        map.put(InvalidGroupIdException.class, 400);
        map.put(InvalidPropertyValueException.class, 400);
        map.put(io.apicurio.registry.rest.ConflictException.class, 409);
        map.put(LimitExceededException.class, 409);
        map.put(LogConfigurationNotFoundException.class, 404);
        map.put(MissingRequiredParameterException.class, 400);
        map.put(NotAllowedException.class, 409);
        map.put(NotAuthorizedException.class, 403);
        map.put(NotFoundException.class, 404);
        map.put(ParametersConflictException.class, 409);
        map.put(ReadOnlyStorageException.class, 409);
        map.put(ReferenceExistsException.class, 422);
        map.put(DereferencingNotSupportedException.class, 400);
        map.put(RoleMappingAlreadyExistsException.class, 409);
        map.put(RoleMappingNotFoundException.class, 404);
        map.put(RuleAlreadyExistsException.class, 409);
        map.put(RuleNotFoundException.class, 404);
        map.put(RuleViolationException.class, 409);
        map.put(SchemaNotFoundException.class, 404);
        map.put(SchemaNotSoftDeletedException.class, 409);
        map.put(SchemaSoftDeletedException.class, 409);
        map.put(SubjectNotSoftDeletedException.class, 409);
        map.put(SubjectSoftDeletedException.class, 404);
        map.put(TimeoutException.class, 503);
        map.put(UnprocessableEntityException.class, 422);
        map.put(UnprocessableSchemaException.class, 422);
        map.put(ValidationException.class, 400);
        map.put(VersionAlreadyExistsException.class, 409);
        map.put(VersionAlreadyExistsOnBranchException.class, 409);
        map.put(VersionNotFoundException.class, 404);
        CODE_MAP = Collections.unmodifiableMap(map);
    }
}

