/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.GAV;
import io.apicurio.registry.model.VersionId;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.BranchMetaDataDto;
import io.apicurio.registry.storage.dto.BranchSearchResultsDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableBranchMetaDataDto;
import io.apicurio.registry.storage.dto.EditableGroupMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RoleMappingSearchResultsDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.error.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.ContentNotFoundException;
import io.apicurio.registry.storage.error.GroupAlreadyExistsException;
import io.apicurio.registry.storage.error.GroupNotFoundException;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.error.RuleAlreadyExistsException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.storage.error.VersionAlreadyExistsException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityInputStream;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public interface RegistryStorage
extends DynamicConfigStorage {
    public String storageName();

    public void initialize();

    public boolean isReady();

    public boolean isAlive();

    public boolean isReadOnly();

    public boolean isEmpty();

    public Pair<ArtifactMetaDataDto, ArtifactVersionMetaDataDto> createArtifact(String var1, String var2, String var3, EditableArtifactMetaDataDto var4, String var5, ContentWrapperDto var6, EditableVersionMetaDataDto var7, List<String> var8, boolean var9) throws ArtifactAlreadyExistsException, RegistryStorageException;

    public List<String> deleteArtifact(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public void deleteArtifacts(String var1) throws RegistryStorageException;

    public ContentWrapperDto getContentById(long var1) throws ContentNotFoundException, RegistryStorageException;

    public ContentWrapperDto getContentByHash(String var1) throws ContentNotFoundException, RegistryStorageException;

    public List<ArtifactVersionMetaDataDto> getArtifactVersionsByContentId(long var1);

    public List<Long> getEnabledArtifactContentIds(String var1, String var2);

    public ArtifactVersionMetaDataDto createArtifactVersion(String var1, String var2, String var3, String var4, ContentWrapperDto var5, EditableVersionMetaDataDto var6, List<String> var7, boolean var8) throws ArtifactNotFoundException, VersionAlreadyExistsException, RegistryStorageException;

    public Set<String> getArtifactIds(Integer var1);

    public ArtifactSearchResultsDto searchArtifacts(Set<SearchFilter> var1, OrderBy var2, OrderDirection var3, int var4, int var5);

    public ArtifactMetaDataDto getArtifactMetaData(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public ArtifactVersionMetaDataDto getArtifactVersionMetaDataByContent(String var1, String var2, boolean var3, TypedContent var4, List<ArtifactReferenceDto> var5) throws ArtifactNotFoundException, RegistryStorageException;

    public void updateArtifactMetaData(String var1, String var2, EditableArtifactMetaDataDto var3) throws ArtifactNotFoundException, RegistryStorageException;

    public List<RuleType> getGroupRules(String var1) throws GroupNotFoundException, RegistryStorageException;

    public void createGroupRule(String var1, RuleType var2, RuleConfigurationDto var3) throws GroupNotFoundException, RuleAlreadyExistsException, RegistryStorageException;

    public void deleteGroupRules(String var1) throws GroupNotFoundException, RegistryStorageException;

    public void updateGroupRule(String var1, RuleType var2, RuleConfigurationDto var3) throws GroupNotFoundException, RuleNotFoundException, RegistryStorageException;

    public void deleteGroupRule(String var1, RuleType var2) throws GroupNotFoundException, RuleNotFoundException, RegistryStorageException;

    public RuleConfigurationDto getGroupRule(String var1, RuleType var2) throws GroupNotFoundException, RuleNotFoundException, RegistryStorageException;

    public List<RuleType> getArtifactRules(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public void createArtifactRule(String var1, String var2, RuleType var3, RuleConfigurationDto var4) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException;

    public void deleteArtifactRules(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public RuleConfigurationDto getArtifactRule(String var1, String var2, RuleType var3) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public void updateArtifactRule(String var1, String var2, RuleType var3, RuleConfigurationDto var4) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public void deleteArtifactRule(String var1, String var2, RuleType var3) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public List<String> getArtifactVersions(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public List<String> getArtifactVersions(String var1, String var2, RetrievalBehavior var3) throws ArtifactNotFoundException, RegistryStorageException;

    public VersionSearchResultsDto searchVersions(Set<SearchFilter> var1, OrderBy var2, OrderDirection var3, int var4, int var5) throws ArtifactNotFoundException, RegistryStorageException;

    public StoredArtifactVersionDto getArtifactVersionContent(long var1) throws ArtifactNotFoundException, RegistryStorageException;

    public StoredArtifactVersionDto getArtifactVersionContent(String var1, String var2, String var3) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public void deleteArtifactVersion(String var1, String var2, String var3) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String var1, String var2, String var3) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(Long var1) throws VersionNotFoundException, RegistryStorageException;

    public void updateArtifactVersionMetaData(String var1, String var2, String var3, EditableVersionMetaDataDto var4) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public List<RuleType> getGlobalRules() throws RegistryStorageException;

    public void createGlobalRule(RuleType var1, RuleConfigurationDto var2) throws RuleAlreadyExistsException, RegistryStorageException;

    public void deleteGlobalRules() throws RegistryStorageException;

    public RuleConfigurationDto getGlobalRule(RuleType var1) throws RuleNotFoundException, RegistryStorageException;

    public void updateGlobalRule(RuleType var1, RuleConfigurationDto var2) throws RuleNotFoundException, RegistryStorageException;

    public void deleteGlobalRule(RuleType var1) throws RuleNotFoundException, RegistryStorageException;

    public void createGroup(GroupMetaDataDto var1) throws GroupAlreadyExistsException, RegistryStorageException;

    public void deleteGroup(String var1) throws GroupNotFoundException, RegistryStorageException;

    public void updateGroupMetaData(String var1, EditableGroupMetaDataDto var2);

    public List<String> getGroupIds(Integer var1) throws RegistryStorageException;

    public GroupMetaDataDto getGroupMetaData(String var1) throws GroupNotFoundException, RegistryStorageException;

    public void exportData(Function<Entity, Void> var1) throws RegistryStorageException;

    public void importData(EntityInputStream var1, boolean var2, boolean var3) throws RegistryStorageException;

    public void upgradeData(EntityInputStream var1, boolean var2, boolean var3);

    public long countArtifacts() throws RegistryStorageException;

    public long countArtifactVersions(String var1, String var2) throws RegistryStorageException;

    public long countActiveArtifactVersions(String var1, String var2) throws RegistryStorageException;

    public long countTotalArtifactVersions() throws RegistryStorageException;

    public void createRoleMapping(String var1, String var2, String var3) throws RegistryStorageException;

    public List<RoleMappingDto> getRoleMappings() throws RegistryStorageException;

    public RoleMappingSearchResultsDto searchRoleMappings(int var1, int var2) throws RegistryStorageException;

    public RoleMappingDto getRoleMapping(String var1) throws RegistryStorageException;

    public String getRoleForPrincipal(String var1) throws RegistryStorageException;

    public void updateRoleMapping(String var1, String var2) throws RegistryStorageException;

    public void deleteRoleMapping(String var1) throws RegistryStorageException;

    public void deleteAllUserData();

    public String createDownload(DownloadContextDto var1) throws RegistryStorageException;

    public DownloadContextDto consumeDownload(String var1) throws RegistryStorageException;

    public void deleteAllExpiredDownloads() throws RegistryStorageException;

    public DynamicConfigPropertyDto getRawConfigProperty(String var1);

    public List<DynamicConfigPropertyDto> getStaleConfigProperties(Instant var1);

    public ContentWrapperDto getContentByReference(ArtifactReferenceDto var1);

    public boolean isArtifactExists(String var1, String var2) throws RegistryStorageException;

    public boolean isGroupExists(String var1) throws RegistryStorageException;

    public List<Long> getContentIdsReferencingArtifactVersion(String var1, String var2, String var3);

    public List<Long> getGlobalIdsReferencingArtifactVersion(String var1, String var2, String var3);

    public List<ArtifactReferenceDto> getInboundArtifactReferences(String var1, String var2, String var3);

    public boolean isArtifactVersionExists(String var1, String var2, String var3) throws RegistryStorageException;

    public GroupSearchResultsDto searchGroups(Set<SearchFilter> var1, OrderBy var2, OrderDirection var3, Integer var4, Integer var5);

    public CommentDto createArtifactVersionComment(String var1, String var2, String var3, String var4);

    public void deleteArtifactVersionComment(String var1, String var2, String var3, String var4);

    public List<CommentDto> getArtifactVersionComments(String var1, String var2, String var3);

    public void updateArtifactVersionComment(String var1, String var2, String var3, String var4, String var5);

    public void resetGlobalId();

    public void resetContentId();

    public void resetCommentId();

    public long nextContentId();

    public long nextGlobalId();

    public long nextCommentId();

    public void importComment(CommentEntity var1);

    public void importGroup(GroupEntity var1);

    public void importGroupRule(GroupRuleEntity var1);

    public void importGlobalRule(GlobalRuleEntity var1);

    public void importContent(ContentEntity var1);

    public void importArtifact(ArtifactEntity var1);

    public void importArtifactVersion(ArtifactVersionEntity var1);

    public void importArtifactRule(ArtifactRuleEntity var1);

    public void importBranch(BranchEntity var1);

    public boolean isContentExists(String var1) throws RegistryStorageException;

    public boolean isArtifactRuleExists(String var1, String var2, RuleType var3) throws RegistryStorageException;

    public boolean isGlobalRuleExists(RuleType var1) throws RegistryStorageException;

    public boolean isRoleMappingExists(String var1);

    public void updateContentCanonicalHash(String var1, long var2, String var4);

    public Optional<Long> contentIdFromHash(String var1);

    public BranchSearchResultsDto getBranches(GA var1, int var2, int var3);

    public BranchMetaDataDto createBranch(GA var1, BranchId var2, String var3, List<String> var4);

    public BranchMetaDataDto getBranchMetaData(GA var1, BranchId var2);

    public void updateBranchMetaData(GA var1, BranchId var2, EditableBranchMetaDataDto var3);

    public void deleteBranch(GA var1, BranchId var2);

    public GAV getBranchTip(GA var1, BranchId var2, RetrievalBehavior var3);

    public VersionSearchResultsDto getBranchVersions(GA var1, BranchId var2, int var3, int var4);

    public void replaceBranchVersions(GA var1, BranchId var2, List<VersionId> var3);

    public void appendVersionToBranch(GA var1, BranchId var2, VersionId var3);

    public String triggerSnapshotCreation() throws RegistryStorageException;

    public String createSnapshot(String var1) throws RegistryStorageException;

    public String createEvent(OutboxEvent var1);

    public boolean supportsDatabaseEvents();

    public static enum RetrievalBehavior {
        DEFAULT,
        SKIP_DISABLED_LATEST;

    }
}

