/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.apicurio.registry.storage.impl.gitops.GitOpsRegistryStorage;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlRegistryStorage;
import io.apicurio.registry.storage.impl.sql.SqlRegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.Raw;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryStorageProducer {
    @Inject
    Logger log;
    @Inject
    Instance<RegistryStorageDecorator> decorators;
    @ConfigProperty(name="apicurio.storage.kind")
    @Info(category="storage", description="Application storage variant, for example, sql, kafkasql, or gitops", availableSince="3.0.0.Final")
    String registryStorageType;
    private RegistryStorage cachedCurrent;
    private RegistryStorage cachedRaw;
    @Inject
    KafkaSqlRegistryStorage kafkaSqlRegistryStorage;
    @Inject
    SqlRegistryStorage sqlRegistryStorage;
    @Inject
    GitOpsRegistryStorage gitOpsRegistryStorage;

    @Produces
    @ApplicationScoped
    @Current
    public RegistryStorage current() {
        if (this.cachedCurrent == null) {
            this.cachedCurrent = this.raw();
            Comparator<RegistryStorageDecorator> decoratorComparator = Comparator.comparing(RegistryStorageDecorator::order);
            List activeDecorators = this.decorators.stream().filter(RegistryStorageDecorator::isEnabled).sorted(decoratorComparator).collect(Collectors.toList());
            if (!activeDecorators.isEmpty()) {
                this.log.debug("Following RegistryStorage decorators have been enabled (in order): {}", activeDecorators.stream().map(d -> d.getClass().getName()).collect(Collectors.toList()));
                for (int i = activeDecorators.size() - 1; i >= 0; --i) {
                    RegistryStorageDecorator decorator = (RegistryStorageDecorator)activeDecorators.get(i);
                    decorator.setDelegate(this.cachedCurrent);
                    this.cachedCurrent = decorator;
                }
            } else {
                this.log.debug("No RegistryStorage decorator has been enabled");
            }
        }
        return this.cachedCurrent;
    }

    @Produces
    @ApplicationScoped
    @Raw
    public RegistryStorage raw() {
        if (this.cachedRaw == null) {
            if ("kafkasql".equals(this.registryStorageType)) {
                this.cachedRaw = this.kafkaSqlRegistryStorage;
            } else if ("gitops".equals(this.registryStorageType)) {
                this.cachedRaw = this.gitOpsRegistryStorage;
            } else if ("sql".equals(this.registryStorageType)) {
                this.cachedRaw = this.sqlRegistryStorage;
            } else {
                throw new IllegalStateException(String.format("No Registry storage variant defined for value %s", this.registryStorageType));
            }
            this.cachedRaw.initialize();
            this.log.info("Using the following RegistryStorage implementation: {}", (Object)this.cachedRaw.getClass().getName());
        }
        return this.cachedRaw;
    }

    @Produces
    @ApplicationScoped
    public DynamicConfigStorage configStorage() {
        return this.current();
    }
}

