/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.registry.storage.error.InvalidVersionStateException;
import io.apicurio.registry.types.VersionState;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;

@ApplicationScoped
public class VersionStateExt {
    private static final Map<VersionState, EnumSet<VersionState>> transitions = new HashMap<VersionState, EnumSet<VersionState>>();
    public static final EnumSet<VersionState> ACTIVE_STATES;
    @Inject
    Logger log;

    public boolean canTransition(VersionState before, VersionState after) {
        EnumSet<VersionState> states = transitions.get((Object)before);
        return states.contains((Object)after);
    }

    public void validateState(EnumSet<VersionState> states, VersionState state, String groupId, String artifactId, String version) {
        if (states != null && !states.contains((Object)state)) {
            throw new InvalidVersionStateException(groupId, artifactId, version, state);
        }
        this.logIfDeprecated(groupId, artifactId, version, state);
    }

    public void logIfDeprecated(String groupId, Object artifactId, Object version, VersionState state) {
        if (state == VersionState.DEPRECATED) {
            this.log.warn("Artifact {} [{}] in group ({}) is deprecated", new Object[]{artifactId, version, groupId});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyState(Consumer<VersionState> consumer, VersionState previousState, VersionState newState) {
        if (previousState == newState) return;
        if (previousState != null) {
            if (!this.canTransition(previousState, newState)) throw new InvalidVersionStateException(previousState, newState);
            consumer.accept(newState);
            return;
        } else {
            consumer.accept(newState);
        }
    }

    static {
        transitions.put(VersionState.ENABLED, EnumSet.of(VersionState.DISABLED, VersionState.DEPRECATED));
        transitions.put(VersionState.DISABLED, EnumSet.of(VersionState.ENABLED, VersionState.DEPRECATED));
        transitions.put(VersionState.DEPRECATED, EnumSet.of(VersionState.ENABLED, VersionState.DISABLED));
        ACTIVE_STATES = EnumSet.of(VersionState.ENABLED, VersionState.DEPRECATED, VersionState.DISABLED);
    }
}

