/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.decorator;

import io.apicurio.common.apps.config.Dynamic;
import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.VersionId;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.apicurio.registry.storage.decorator.RegistryStorageDecoratorReadOnlyBase;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.BranchMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableBranchMetaDataDto;
import io.apicurio.registry.storage.dto.EditableGroupMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.GroupAlreadyExistsException;
import io.apicurio.registry.storage.error.GroupNotFoundException;
import io.apicurio.registry.storage.error.ReadOnlyStorageException;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.error.RuleAlreadyExistsException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.EntityInputStream;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class ReadOnlyRegistryStorageDecorator
extends RegistryStorageDecoratorReadOnlyBase
implements RegistryStorageDecorator {
    public static final String READ_ONLY_MODE_ENABLED_PROPERTY_NAME = "apicurio.storage.read-only.enabled";
    @Dynamic(label="Storage read-only mode", description="When selected, Registry will return an error for operations that write to the storage (this property excepted).")
    @ConfigProperty(name="apicurio.storage.read-only.enabled", defaultValue="false")
    @Info(category="storage", description="Enable Registry storage read-only mode", availableSince="2.5.0.Final")
    Supplier<Boolean> readOnlyModeEnabled;

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int order() {
        return 10;
    }

    @Override
    public void setDelegate(RegistryStorage delegate) {
        super.setDelegate(delegate);
    }

    private void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new ReadOnlyStorageException("Unsupported write operation. Storage is in read-only mode.");
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly() || this.readOnlyModeEnabled.get() != false;
    }

    @Override
    public Pair<ArtifactMetaDataDto, ArtifactVersionMetaDataDto> createArtifact(String groupId, String artifactId, String artifactType, EditableArtifactMetaDataDto artifactMetaData, String version, ContentWrapperDto versionContent, EditableVersionMetaDataDto versionMetaData, List<String> versionBranches, boolean dryRun) throws RegistryStorageException {
        this.checkReadOnly();
        return this.delegate.createArtifact(groupId, artifactId, artifactType, artifactMetaData, version, versionContent, versionMetaData, versionBranches, dryRun);
    }

    @Override
    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        return this.delegate.deleteArtifact(groupId, artifactId);
    }

    @Override
    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteArtifacts(groupId);
    }

    @Override
    public ArtifactVersionMetaDataDto createArtifactVersion(String groupId, String artifactId, String version, String artifactType, ContentWrapperDto content, EditableVersionMetaDataDto metaData, List<String> branches, boolean dryRun) throws RegistryStorageException {
        this.checkReadOnly();
        return this.delegate.createArtifactVersion(groupId, artifactId, version, artifactType, content, metaData, branches, dryRun);
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.updateArtifactMetaData(groupId, artifactId, metaData);
    }

    @Override
    public void createArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.createArtifactRule(groupId, artifactId, rule, config);
    }

    @Override
    public void deleteArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteArtifactRules(groupId, artifactId);
    }

    @Override
    public void updateArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.updateArtifactRule(groupId, artifactId, rule, config);
    }

    @Override
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteArtifactRule(groupId, artifactId, rule);
    }

    @Override
    public void createGroupRule(String groupId, RuleType rule, RuleConfigurationDto config) throws GroupNotFoundException, RuleAlreadyExistsException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.createGroupRule(groupId, rule, config);
    }

    @Override
    public void deleteGroupRules(String groupId) throws GroupNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteGroupRules(groupId);
    }

    @Override
    public void updateGroupRule(String groupId, RuleType rule, RuleConfigurationDto config) throws GroupNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.updateGroupRule(groupId, rule, config);
    }

    @Override
    public void deleteGroupRule(String groupId, RuleType rule) throws GroupNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteGroupRule(groupId, rule);
    }

    @Override
    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteArtifactVersion(groupId, artifactId, version);
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableVersionMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.updateArtifactVersionMetaData(groupId, artifactId, version, metaData);
    }

    @Override
    public void createGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleAlreadyExistsException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.createGlobalRule(rule, config);
    }

    @Override
    public void deleteGlobalRules() throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteGlobalRules();
    }

    @Override
    public void updateGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.updateGlobalRule(rule, config);
    }

    @Override
    public void deleteGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteGlobalRule(rule);
    }

    @Override
    public void createGroup(GroupMetaDataDto group) throws GroupAlreadyExistsException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.createGroup(group);
    }

    @Override
    public void updateGroupMetaData(String groupId, EditableGroupMetaDataDto dto) {
        this.checkReadOnly();
        this.delegate.updateGroupMetaData(groupId, dto);
    }

    @Override
    public void deleteGroup(String groupId) throws GroupNotFoundException, RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteGroup(groupId);
    }

    @Override
    public void importData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.importData(entities, preserveGlobalId, preserveContentId);
    }

    @Override
    public void upgradeData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.upgradeData(entities, preserveGlobalId, preserveContentId);
    }

    @Override
    public void createRoleMapping(String principalId, String role, String principalName) throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.createRoleMapping(principalId, role, principalName);
    }

    @Override
    public void deleteRoleMapping(String principalId) throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteRoleMapping(principalId);
    }

    @Override
    public void updateRoleMapping(String principalId, String role) throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.updateRoleMapping(principalId, role);
    }

    @Override
    public void deleteAllUserData() throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteAllUserData();
    }

    public void setConfigProperty(DynamicConfigPropertyDto propertyDto) {
        if (this.delegate.isReadOnly() || !READ_ONLY_MODE_ENABLED_PROPERTY_NAME.equals(propertyDto.getName())) {
            this.checkReadOnly();
        }
        this.delegate.setConfigProperty(propertyDto);
    }

    public void deleteConfigProperty(String propertyName) {
        if (this.delegate.isReadOnly() || !READ_ONLY_MODE_ENABLED_PROPERTY_NAME.equals(propertyName)) {
            this.checkReadOnly();
        }
        this.delegate.deleteConfigProperty(propertyName);
    }

    @Override
    public CommentDto createArtifactVersionComment(String groupId, String artifactId, String version, String value) {
        this.checkReadOnly();
        return this.delegate.createArtifactVersionComment(groupId, artifactId, version, value);
    }

    @Override
    public void deleteArtifactVersionComment(String groupId, String artifactId, String version, String commentId) {
        this.checkReadOnly();
        this.delegate.deleteArtifactVersionComment(groupId, artifactId, version, commentId);
    }

    @Override
    public void updateArtifactVersionComment(String groupId, String artifactId, String version, String commentId, String value) {
        this.checkReadOnly();
        this.delegate.updateArtifactVersionComment(groupId, artifactId, version, commentId, value);
    }

    @Override
    public String createDownload(DownloadContextDto context) throws RegistryStorageException {
        this.checkReadOnly();
        return this.delegate.createDownload(context);
    }

    @Override
    public DownloadContextDto consumeDownload(String downloadId) throws RegistryStorageException {
        this.checkReadOnly();
        return this.delegate.consumeDownload(downloadId);
    }

    @Override
    public void deleteAllExpiredDownloads() throws RegistryStorageException {
        this.checkReadOnly();
        this.delegate.deleteAllExpiredDownloads();
    }

    @Override
    public void resetGlobalId() {
        this.checkReadOnly();
        this.delegate.resetGlobalId();
    }

    @Override
    public void resetContentId() {
        this.checkReadOnly();
        this.delegate.resetContentId();
    }

    @Override
    public void resetCommentId() {
        this.checkReadOnly();
        this.delegate.resetCommentId();
    }

    @Override
    public void importComment(CommentEntity entity) {
        this.checkReadOnly();
        this.delegate.importComment(entity);
    }

    @Override
    public void importGroup(GroupEntity entity) {
        this.checkReadOnly();
        this.delegate.importGroup(entity);
    }

    @Override
    public void importGlobalRule(GlobalRuleEntity entity) {
        this.checkReadOnly();
        this.delegate.importGlobalRule(entity);
    }

    @Override
    public void importContent(ContentEntity entity) {
        this.checkReadOnly();
        this.delegate.importContent(entity);
    }

    @Override
    public void importArtifactVersion(ArtifactVersionEntity entity) {
        this.checkReadOnly();
        this.delegate.importArtifactVersion(entity);
    }

    @Override
    public void importArtifact(ArtifactEntity entity) {
        this.checkReadOnly();
        this.delegate.importArtifact(entity);
    }

    @Override
    public void importArtifactRule(ArtifactRuleEntity entity) {
        this.checkReadOnly();
        this.delegate.importArtifactRule(entity);
    }

    @Override
    public void importGroupRule(GroupRuleEntity entity) {
        this.checkReadOnly();
        this.delegate.importGroupRule(entity);
    }

    @Override
    public void importBranch(BranchEntity entity) {
        this.checkReadOnly();
        this.delegate.importBranch(entity);
    }

    @Override
    public void updateContentCanonicalHash(String newCanonicalHash, long contentId, String contentHash) {
        this.checkReadOnly();
        this.delegate.updateContentCanonicalHash(newCanonicalHash, contentId, contentHash);
    }

    @Override
    public long nextContentId() {
        this.checkReadOnly();
        return this.delegate.nextContentId();
    }

    @Override
    public long nextGlobalId() {
        this.checkReadOnly();
        return this.delegate.nextGlobalId();
    }

    @Override
    public long nextCommentId() {
        this.checkReadOnly();
        return this.delegate.nextCommentId();
    }

    @Override
    public BranchMetaDataDto createBranch(GA ga, BranchId branchId, String description, List<String> versions) {
        this.checkReadOnly();
        return this.delegate.createBranch(ga, branchId, description, versions);
    }

    @Override
    public void updateBranchMetaData(GA ga, BranchId branchId, EditableBranchMetaDataDto dto) {
        this.checkReadOnly();
        this.delegate.updateBranchMetaData(ga, branchId, dto);
    }

    @Override
    public void appendVersionToBranch(GA ga, BranchId branchId, VersionId version) {
        this.checkReadOnly();
        this.delegate.appendVersionToBranch(ga, branchId, version);
    }

    @Override
    public void replaceBranchVersions(GA ga, BranchId branchId, List<VersionId> versions) {
        this.checkReadOnly();
        this.delegate.replaceBranchVersions(ga, branchId, versions);
    }

    @Override
    public void deleteBranch(GA ga, BranchId branchId) {
        this.checkReadOnly();
        this.delegate.deleteBranch(ga, branchId);
    }

    @Override
    public String triggerSnapshotCreation() throws RegistryStorageException {
        this.checkReadOnly();
        return this.delegate.triggerSnapshotCreation();
    }

    @Override
    public String createSnapshot(String snapshotLocation) throws RegistryStorageException {
        this.checkReadOnly();
        return this.delegate.createSnapshot(snapshotLocation);
    }

    @Override
    public String createEvent(OutboxEvent event) {
        this.checkReadOnly();
        return this.delegate.createEvent(event);
    }

    @Override
    public ContentWrapperDto getContentByReference(ArtifactReferenceDto reference) {
        this.checkReadOnly();
        return this.delegate.getContentByReference(reference);
    }
}

