/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.decorator;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.GAV;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.BranchMetaDataDto;
import io.apicurio.registry.storage.dto.BranchSearchResultsDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RoleMappingSearchResultsDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.ContentNotFoundException;
import io.apicurio.registry.storage.error.GroupNotFoundException;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.Entity;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public abstract class RegistryStorageDecoratorReadOnlyBase
implements RegistryStorage {
    protected RegistryStorage delegate;

    protected RegistryStorageDecoratorReadOnlyBase() {
    }

    public void setDelegate(RegistryStorage delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initialize() {
        this.delegate.initialize();
    }

    @Override
    public String storageName() {
        return this.delegate.storageName();
    }

    @Override
    public boolean isReady() {
        return this.delegate.isReady();
    }

    @Override
    public boolean isAlive() {
        return this.delegate.isAlive();
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public ContentWrapperDto getContentById(long contentId) throws ContentNotFoundException, RegistryStorageException {
        return this.delegate.getContentById(contentId);
    }

    @Override
    public ContentWrapperDto getContentByHash(String contentHash) throws ContentNotFoundException, RegistryStorageException {
        return this.delegate.getContentByHash(contentHash);
    }

    @Override
    public List<ArtifactVersionMetaDataDto> getArtifactVersionsByContentId(long contentId) {
        return this.delegate.getArtifactVersionsByContentId(contentId);
    }

    @Override
    public Set<String> getArtifactIds(Integer limit) {
        return this.delegate.getArtifactIds(limit);
    }

    @Override
    public ArtifactSearchResultsDto searchArtifacts(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) {
        return this.delegate.searchArtifacts(filters, orderBy, orderDirection, offset, limit);
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactMetaData(groupId, artifactId);
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaDataByContent(String groupId, String artifactId, boolean canonical, TypedContent content, List<ArtifactReferenceDto> artifactReferences) throws ArtifactNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, content, artifactReferences);
    }

    @Override
    public List<RuleType> getArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactRules(groupId, artifactId);
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactRule(groupId, artifactId, rule);
    }

    @Override
    public List<RuleType> getGroupRules(String groupId) throws GroupNotFoundException, RegistryStorageException {
        return this.delegate.getGroupRules(groupId);
    }

    @Override
    public RuleConfigurationDto getGroupRule(String groupId, RuleType rule) throws GroupNotFoundException, RuleNotFoundException, RegistryStorageException {
        return this.delegate.getGroupRule(groupId, rule);
    }

    @Override
    public List<String> getArtifactVersions(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactVersions(groupId, artifactId);
    }

    @Override
    public VersionSearchResultsDto searchVersions(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) throws RegistryStorageException {
        return this.delegate.searchVersions(filters, orderBy, orderDirection, offset, limit);
    }

    @Override
    public StoredArtifactVersionDto getArtifactVersionContent(long globalId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactVersionContent(globalId);
    }

    @Override
    public StoredArtifactVersionDto getArtifactVersionContent(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactVersionContent(groupId, artifactId, version);
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactVersionMetaData(groupId, artifactId, version);
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(Long globalId) throws VersionNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactVersionMetaData(globalId);
    }

    @Override
    public List<RuleType> getGlobalRules() throws RegistryStorageException {
        return this.delegate.getGlobalRules();
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        return this.delegate.getGlobalRule(rule);
    }

    @Override
    public List<String> getGroupIds(Integer limit) throws RegistryStorageException {
        return this.delegate.getGroupIds(limit);
    }

    @Override
    public GroupMetaDataDto getGroupMetaData(String groupId) throws GroupNotFoundException, RegistryStorageException {
        return this.delegate.getGroupMetaData(groupId);
    }

    @Override
    public void exportData(Function<Entity, Void> handler) throws RegistryStorageException {
        this.delegate.exportData(handler);
    }

    @Override
    public long countArtifacts() throws RegistryStorageException {
        return this.delegate.countArtifacts();
    }

    @Override
    public long countArtifactVersions(String groupId, String artifactId) throws RegistryStorageException {
        return this.delegate.countArtifactVersions(groupId, artifactId);
    }

    @Override
    public long countActiveArtifactVersions(String groupId, String artifactId) throws RegistryStorageException {
        return this.delegate.countActiveArtifactVersions(groupId, artifactId);
    }

    @Override
    public long countTotalArtifactVersions() throws RegistryStorageException {
        return this.delegate.countTotalArtifactVersions();
    }

    @Override
    public RoleMappingDto getRoleMapping(String principalId) throws RegistryStorageException {
        return this.delegate.getRoleMapping(principalId);
    }

    @Override
    public String getRoleForPrincipal(String principalId) throws RegistryStorageException {
        return this.delegate.getRoleForPrincipal(principalId);
    }

    @Override
    public List<RoleMappingDto> getRoleMappings() throws RegistryStorageException {
        return this.delegate.getRoleMappings();
    }

    @Override
    public RoleMappingSearchResultsDto searchRoleMappings(int offset, int limit) throws RegistryStorageException {
        return this.delegate.searchRoleMappings(offset, limit);
    }

    public List<DynamicConfigPropertyDto> getConfigProperties() throws RegistryStorageException {
        return this.delegate.getConfigProperties();
    }

    public DynamicConfigPropertyDto getConfigProperty(String propertyName) {
        return this.delegate.getConfigProperty(propertyName);
    }

    @Override
    public List<DynamicConfigPropertyDto> getStaleConfigProperties(Instant since) {
        return this.delegate.getStaleConfigProperties(since);
    }

    @Override
    public DynamicConfigPropertyDto getRawConfigProperty(String propertyName) {
        return this.delegate.getRawConfigProperty(propertyName);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean isArtifactExists(String groupId, String artifactId) throws RegistryStorageException {
        return this.delegate.isArtifactExists(groupId, artifactId);
    }

    @Override
    public boolean isGroupExists(String groupId) throws RegistryStorageException {
        return this.delegate.isGroupExists(groupId);
    }

    @Override
    public boolean isArtifactVersionExists(String groupId, String artifactId, String version) throws RegistryStorageException {
        return this.delegate.isArtifactVersionExists(groupId, artifactId, version);
    }

    @Override
    public List<Long> getContentIdsReferencingArtifactVersion(String groupId, String artifactId, String version) {
        return this.delegate.getContentIdsReferencingArtifactVersion(groupId, artifactId, version);
    }

    @Override
    public List<Long> getGlobalIdsReferencingArtifactVersion(String groupId, String artifactId, String version) {
        return this.delegate.getGlobalIdsReferencingArtifactVersion(groupId, artifactId, version);
    }

    @Override
    public List<ArtifactReferenceDto> getInboundArtifactReferences(String groupId, String artifactId, String version) {
        return this.delegate.getInboundArtifactReferences(groupId, artifactId, version);
    }

    @Override
    public GroupSearchResultsDto searchGroups(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, Integer offset, Integer limit) {
        return this.delegate.searchGroups(filters, orderBy, orderDirection, offset, limit);
    }

    @Override
    public List<CommentDto> getArtifactVersionComments(String groupId, String artifactId, String version) {
        return this.delegate.getArtifactVersionComments(groupId, artifactId, version);
    }

    @Override
    public boolean isContentExists(String contentHash) throws RegistryStorageException {
        return this.delegate.isContentExists(contentHash);
    }

    @Override
    public boolean isArtifactRuleExists(String groupId, String artifactId, RuleType rule) throws RegistryStorageException {
        return this.delegate.isArtifactRuleExists(groupId, artifactId, rule);
    }

    @Override
    public boolean isGlobalRuleExists(RuleType rule) throws RegistryStorageException {
        return this.delegate.isGlobalRuleExists(rule);
    }

    @Override
    public boolean isRoleMappingExists(String principalId) {
        return this.delegate.isRoleMappingExists(principalId);
    }

    @Override
    public Optional<Long> contentIdFromHash(String contentHash) {
        return this.delegate.contentIdFromHash(contentHash);
    }

    @Override
    public ContentWrapperDto getContentByReference(ArtifactReferenceDto reference) {
        return this.delegate.getContentByReference(reference);
    }

    @Override
    public List<Long> getEnabledArtifactContentIds(String groupId, String artifactId) {
        return this.delegate.getEnabledArtifactContentIds(groupId, artifactId);
    }

    @Override
    public List<String> getArtifactVersions(String groupId, String artifactId, RegistryStorage.RetrievalBehavior behavior) throws ArtifactNotFoundException, RegistryStorageException {
        return this.delegate.getArtifactVersions(groupId, artifactId, behavior);
    }

    @Override
    public GAV getBranchTip(GA ga, BranchId branchId, RegistryStorage.RetrievalBehavior behavior) {
        return this.delegate.getBranchTip(ga, branchId, behavior);
    }

    @Override
    public VersionSearchResultsDto getBranchVersions(GA ga, BranchId branchId, int offset, int limit) {
        return this.delegate.getBranchVersions(ga, branchId, offset, limit);
    }

    @Override
    public BranchSearchResultsDto getBranches(GA ga, int offset, int limit) {
        return this.delegate.getBranches(ga, offset, limit);
    }

    @Override
    public BranchMetaDataDto getBranchMetaData(GA ga, BranchId branchId) {
        return this.delegate.getBranchMetaData(ga, branchId);
    }

    @Override
    public boolean supportsDatabaseEvents() {
        return this.delegate.supportsDatabaseEvents();
    }
}

