/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.dto;

import io.apicurio.registry.storage.dto.SearchFilterType;
import io.apicurio.registry.types.VersionState;
import org.apache.commons.lang3.tuple.Pair;

public class SearchFilter {
    private SearchFilterType type;
    private Object value;
    private boolean not;

    public SearchFilter() {
    }

    private SearchFilter(SearchFilterType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public static SearchFilter ofLabel(String labelKey, String labelValue) {
        return new SearchFilter(SearchFilterType.labels, Pair.of((Object)labelKey, (Object)labelValue));
    }

    public static SearchFilter ofLabel(String labelKey) {
        return new SearchFilter(SearchFilterType.labels, Pair.of((Object)labelKey, null));
    }

    public static SearchFilter ofGlobalId(Long value) {
        return new SearchFilter(SearchFilterType.globalId, value);
    }

    public static SearchFilter ofContentId(Long value) {
        return new SearchFilter(SearchFilterType.contentId, value);
    }

    public static SearchFilter ofName(String value) {
        return new SearchFilter(SearchFilterType.name, value);
    }

    public static SearchFilter ofDescription(String value) {
        return new SearchFilter(SearchFilterType.description, value);
    }

    public static SearchFilter ofGroupId(String value) {
        return new SearchFilter(SearchFilterType.groupId, value);
    }

    public static SearchFilter ofArtifactId(String value) {
        return new SearchFilter(SearchFilterType.artifactId, value);
    }

    public static SearchFilter ofVersion(String value) {
        return new SearchFilter(SearchFilterType.version, value);
    }

    public static SearchFilter ofCanonicalHash(String value) {
        return new SearchFilter(SearchFilterType.canonicalHash, value);
    }

    public static SearchFilter ofContentHash(String value) {
        return new SearchFilter(SearchFilterType.contentHash, value);
    }

    public static SearchFilter ofState(VersionState state) {
        return new SearchFilter(SearchFilterType.state, state.name());
    }

    public Pair<String, String> getLabelFilterValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Pair) {
            return (Pair)this.value;
        }
        throw new IllegalStateException("value is not of type pair");
    }

    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof Long) {
            return this.value.toString();
        }
        throw new IllegalStateException("value is not of type string");
    }

    public Number getNumberValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        throw new IllegalStateException("value is not of type number");
    }

    public void setStringValue(String value) {
        this.value = value;
    }

    public SearchFilterType getType() {
        return this.type;
    }

    public void setType(SearchFilterType type) {
        this.type = type;
    }

    public String toString() {
        return "SearchFilter" + (this.isNot() ? " NOT" : "") + " [type=" + this.type + ", value=" + this.value + "]";
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public SearchFilter negated() {
        SearchFilter filter = new SearchFilter(this.type, this.value);
        filter.setNot(true);
        return filter;
    }
}

