/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.error;

import io.apicurio.registry.model.GroupId;
import io.apicurio.registry.storage.error.NotFoundException;
import lombok.Generated;

public class ArtifactNotFoundException
extends NotFoundException {
    private static final long serialVersionUID = -3614783501078800654L;
    private String groupId;
    private String artifactId;

    public ArtifactNotFoundException(String groupId, String artifactId) {
        super(ArtifactNotFoundException.message(groupId, artifactId));
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public ArtifactNotFoundException(String groupId, String artifactId, Throwable cause) {
        super(ArtifactNotFoundException.message(groupId, artifactId), cause);
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public ArtifactNotFoundException(String artifactId) {
        super(ArtifactNotFoundException.message(GroupId.DEFAULT.getRawGroupIdWithDefaultString(), artifactId));
        this.artifactId = artifactId;
    }

    private static String message(String groupId, String artifactId) {
        return "No artifact with ID '" + artifactId + "' in group '" + groupId + "' was found.";
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }
}

