/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.error;

import io.apicurio.registry.storage.error.NotFoundException;
import lombok.Generated;

public class BranchNotFoundException
extends NotFoundException {
    private final String groupId;
    private final String artifactId;
    private final String branchId;

    public BranchNotFoundException(String groupId, String artifactId, String branchId) {
        super(BranchNotFoundException.message(groupId, artifactId, branchId));
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.branchId = branchId;
    }

    public BranchNotFoundException(String groupId, String artifactId, String branchId, Exception cause) {
        super(BranchNotFoundException.message(groupId, artifactId, branchId), cause);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.branchId = branchId;
    }

    private static String message(String groupId, String artifactId, String branchId) {
        return "No branch '" + branchId + "' was found in " + groupId + "/" + artifactId + ".";
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getBranchId() {
        return this.branchId;
    }
}

