/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.error;

import io.apicurio.registry.storage.error.NotFoundException;
import lombok.Generated;

public class ContentNotFoundException
extends NotFoundException {
    private static final long serialVersionUID = -3640094007953927715L;
    private Long contentId;
    private String contentHash;

    public ContentNotFoundException(long contentId) {
        super(ContentNotFoundException.message(contentId, null));
        this.contentId = contentId;
    }

    public ContentNotFoundException(String contentHash) {
        super(ContentNotFoundException.message(null, contentHash));
        this.contentHash = contentHash;
    }

    private static String message(Long contentId, String contentHash) {
        if (contentId != null) {
            return "No content with ID '" + contentId + "' was found.";
        }
        return "No content with hash '" + contentHash + "' was found.";
    }

    @Generated
    public Long getContentId() {
        return this.contentId;
    }

    @Generated
    public String getContentHash() {
        return this.contentHash;
    }
}

