/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.error;

import io.apicurio.registry.model.GAV;
import io.apicurio.registry.storage.error.NotFoundException;
import lombok.Generated;

public class VersionNotFoundException
extends NotFoundException {
    private static final long serialVersionUID = 969959730600115392L;
    private String groupId;
    private String artifactId;
    private String version;
    private Long globalId;

    public VersionNotFoundException(long globalId) {
        super(VersionNotFoundException.message(null, null, null, globalId));
        this.globalId = globalId;
    }

    public VersionNotFoundException(String groupId, String artifactId, String version) {
        super(VersionNotFoundException.message(groupId, artifactId, version, null));
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public VersionNotFoundException(String groupId, String artifactId, String version, Throwable cause) {
        super(VersionNotFoundException.message(groupId, artifactId, version, null), cause);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public VersionNotFoundException(GAV gav, Throwable cause) {
        super(VersionNotFoundException.message(gav.getRawGroupIdWithDefaultString(), gav.getRawArtifactId(), gav.getRawVersionId(), null), cause);
        this.groupId = gav.getRawGroupIdWithDefaultString();
        this.artifactId = gav.getRawArtifactId();
        this.version = gav.getRawVersionId();
    }

    private static String message(String groupId, String artifactId, String version, Long globalId) {
        if (globalId != null) {
            return "No version with global ID '" + globalId + "' found.";
        }
        return "No version '" + version + "' found for artifact with ID '" + artifactId + "' in group '" + groupId + "'.";
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Long getGlobalId() {
        return this.globalId;
    }
}

