/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.gitops;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.util.ContentTypeUtil;
import io.apicurio.registry.storage.impl.gitops.GitOpsConfigProperties;
import io.apicurio.registry.storage.impl.gitops.ProcessingState;
import io.apicurio.registry.storage.impl.gitops.model.GitFile;
import io.apicurio.registry.storage.impl.gitops.model.Type;
import io.apicurio.registry.storage.impl.gitops.model.v0.Artifact;
import io.apicurio.registry.storage.impl.gitops.model.v0.Content;
import io.apicurio.registry.storage.impl.gitops.model.v0.Group;
import io.apicurio.registry.storage.impl.gitops.model.v0.Registry;
import io.apicurio.registry.storage.impl.gitops.model.v0.Rule;
import io.apicurio.registry.storage.impl.gitops.model.v0.Setting;
import io.apicurio.registry.storage.impl.gitops.model.v0.Version;
import io.apicurio.registry.storage.impl.sql.RegistryStorageContentUtils;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.VersionState;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;

@ApplicationScoped
public class GitManager {
    @Inject
    Logger log;
    @Inject
    GitOpsConfigProperties config;
    @Inject
    RegistryStorageContentUtils utils;
    private Git git;
    private String originRemoteName;
    private RevCommit previousCommit;

    public void start() throws IOException, URISyntaxException, GitAPIException {
        this.initRepo();
    }

    private void initRepo() throws IOException, GitAPIException, URISyntaxException {
        Path workDirPath = Paths.get(this.config.getWorkDir(), new String[0]);
        Path gitPath = workDirPath.resolve("repo").resolve(".git");
        this.git = Files.exists(gitPath.resolve("config"), new LinkOption[0]) ? Git.open((File)gitPath.toFile()) : Git.init().setGitDir(gitPath.toFile()).setInitialBranch(UUID.randomUUID().toString()).call();
        ObjectId previousOID = this.git.getRepository().resolve("refs/heads/empty");
        if (previousOID == null) {
            this.git.commit().setMessage("empty").setAllowEmpty(true).call();
            this.git.checkout().setName("empty").setCreateBranch(true).setForced(true).setOrphan(true).call();
            previousOID = this.git.getRepository().resolve("refs/heads/empty");
        }
        this.previousCommit = this.git.getRepository().parseCommit((AnyObjectId)previousOID);
        this.originRemoteName = this.ensureRemote(this.config.getOriginRepoURI());
    }

    private String ensureRemote(String repoURI) throws GitAPIException, URISyntaxException {
        URIish repoURIish = new URIish(repoURI);
        Optional<RemoteConfig> remote = this.git.remoteList().call().stream().filter(r -> r.getURIs().stream().allMatch(u -> u.equals((Object)repoURIish))).findAny();
        if (remote.isPresent()) {
            return remote.get().getName();
        }
        String name = UUID.randomUUID().toString();
        this.git.remoteAdd().setName(name).setUri(repoURIish).call();
        return name;
    }

    public RevCommit poll() throws GitAPIException, IOException {
        String updatedRef = "refs/remotes/" + this.originRemoteName + "/" + this.config.getOriginRepoBranch();
        String fetchRef = "refs/heads/" + this.config.getOriginRepoBranch() + ":" + updatedRef;
        this.git.fetch().setRemote(this.originRemoteName).setRefSpecs(new String[]{fetchRef}).setDepth(1).setForceUpdate(true).call();
        ObjectId updatedOID = this.git.getRepository().resolve(updatedRef);
        if (updatedOID == null) {
            throw new RuntimeException(String.format("Could not resolve %s", updatedRef));
        }
        return this.git.getRepository().parseCommit((AnyObjectId)updatedOID);
    }

    public void updateCurrentCommit(RevCommit currentCommit) {
        this.previousCommit = currentCommit;
    }

    public void run(ProcessingState state, RevCommit updatedCommit) throws GitAPIException, IOException {
        if (updatedCommit == null || updatedCommit.equals((AnyObjectId)this.previousCommit)) {
            throw new IllegalStateException("Make sure to call method pollUpdates() before calling me.");
        }
        this.log.debug("Processing change: {} -> {}", (Object)updatedCommit.name(), (Object)this.previousCommit.name());
        state.setUpdatedCommit(updatedCommit);
        try (TreeWalk treeWalk = new TreeWalk(this.git.getRepository());){
            treeWalk.addTree((AnyObjectId)updatedCommit.getTree());
            treeWalk.setRecursive(true);
            while (treeWalk.next()) {
                ObjectId objectId = treeWalk.getObjectId(0);
                ObjectStream data = this.git.getRepository().getObjectDatabase().open((AnyObjectId)objectId).openStream();
                try {
                    GitFile file = GitFile.create(state, treeWalk.getPathString(), (InputStream)data);
                    state.index(file);
                }
                finally {
                    if (data == null) continue;
                    data.close();
                }
            }
        }
        this.log.debug("Processing {} files", (Object)state.getPathIndex().size());
        this.process(state);
        List unprocessed = state.getPathIndex().values().stream().filter(f -> !f.isProcessed()).map(GitFile::getPath).collect(Collectors.toList());
        this.log.debug("The following {} file(s) were not processed: {}", (Object)unprocessed.size(), unprocessed);
    }

    private void process(ProcessingState state) {
        for (GitFile file : state.fromTypeIndex(Type.REGISTRY)) {
            Registry registry = (Registry)file.getEntityUnchecked();
            if (!this.config.getRegistryId().equals(registry.getId())) continue;
            state.setCurrentRegistry(registry);
            file.setProcessed(true);
        }
        if (state.getCurrentRegistry() != null) {
            this.processSettings(state);
            this.processGlobalRules(state);
            for (GitFile file : state.fromTypeIndex(Type.ARTIFACT)) {
                Artifact artifact = (Artifact)file.getEntityUnchecked();
                if (state.isCurrentRegistryId(artifact.getRegistryId())) {
                    this.processArtifact(state, file, artifact);
                    continue;
                }
                this.log.debug("Ignoring {}", (Object)artifact);
            }
        } else {
            this.log.warn("Git repository does not contain data for this registry (ID = {})", (Object)this.config.getRegistryId());
        }
    }

    private void processSettings(ProcessingState state) {
        List<Setting> settings = state.getCurrentRegistry().getSettings();
        if (settings != null) {
            for (Setting setting : settings) {
                try {
                    DynamicConfigPropertyDto dto = new DynamicConfigPropertyDto();
                    dto.setName(setting.getName());
                    dto.setValue(setting.getValue());
                    this.log.debug("Importing {}", (Object)dto);
                    state.getStorage().setConfigProperty(dto);
                }
                catch (Exception ex) {
                    state.recordError("Could not import configuration property %s: %s", setting.getName(), ex.getMessage());
                }
            }
        }
    }

    private void processGlobalRules(ProcessingState state) {
        List<Rule> globalRules = state.getCurrentRegistry().getGlobalRules();
        if (globalRules != null) {
            for (Rule globalRule : globalRules) {
                try {
                    GlobalRuleEntity e = new GlobalRuleEntity();
                    e.ruleType = RuleType.fromValue(globalRule.getType());
                    e.configuration = globalRule.getConfig();
                    this.log.debug("Importing {}", (Object)e);
                    state.getStorage().importGlobalRule(e);
                }
                catch (Exception ex) {
                    state.recordError("Could not import global rule %s: %s", globalRule.getType(), ex.getMessage());
                }
            }
        }
    }

    private void processArtifact(ProcessingState state, GitFile artifactFile, Artifact artifact) {
        boolean artifactImported = false;
        Group group = this.processGroupRef(state, artifact.getGroupId());
        if (group != null) {
            List<Version> versions = artifact.getVersions();
            for (int i = 0; i < versions.size(); ++i) {
                Version version = versions.get(i);
                try {
                    ArtifactVersionEntity e = new ArtifactVersionEntity();
                    e.groupId = artifact.getGroupId();
                    e.artifactId = artifact.getId();
                    e.version = version.getId();
                    e.globalId = version.getGlobalId();
                    e.state = VersionState.ENABLED;
                    e.createdOn = state.getUpdatedCommit().getCommitTime();
                    e.modifiedOn = state.getUpdatedCommit().getCommitTime();
                    Content content = this.processContent(state, artifactFile, version.getContentFile());
                    if (content != null) {
                        String artifactType = content.getArtifactType();
                        e.contentId = content.getId();
                        if (!artifactImported) {
                            ArtifactEntity artifactEntity = new ArtifactEntity();
                            artifactEntity.groupId = artifact.getGroupId();
                            artifactEntity.artifactId = artifact.getId();
                            artifactEntity.artifactType = artifactType;
                            artifactEntity.createdOn = state.getUpdatedCommit().getCommitTime();
                            artifactEntity.modifiedOn = state.getUpdatedCommit().getCommitTime();
                            state.getStorage().importArtifact(artifactEntity);
                            artifactImported = true;
                        }
                        this.log.debug("Importing {}", (Object)e);
                        state.getStorage().importArtifactVersion(e);
                        continue;
                    }
                    state.recordError("Could not import content for artifact version %s.", artifact.getGroupId() + ":" + artifact.getId() + ":" + version.getId());
                    continue;
                }
                catch (Exception ex) {
                    state.recordError("Could not import artifact version '%s': %s", artifact.getGroupId() + ":" + artifact.getId() + ":" + version.getId(), ex.getMessage());
                }
            }
            this.processArtifactRules(state, artifact);
            artifactFile.setProcessed(true);
        } else {
            state.recordError("Could not find group %s", artifact.getGroupId());
        }
    }

    private void processArtifactRules(ProcessingState state, Artifact artifact) {
        List<Rule> rules = artifact.getRules();
        if (rules != null) {
            for (Rule rule : rules) {
                try {
                    ArtifactRuleEntity e = new ArtifactRuleEntity();
                    e.groupId = artifact.getGroupId();
                    e.artifactId = artifact.getId();
                    e.type = RuleType.fromValue(rule.getType());
                    e.configuration = rule.getConfig();
                    this.log.debug("Importing {}", (Object)e);
                    state.getStorage().importArtifactRule(e);
                }
                catch (Exception ex) {
                    state.recordError("Could not import rule %s for artifact '%s': %s", rule.getType(), artifact.getGroupId() + ":" + artifact.getId(), ex.getMessage());
                }
            }
        }
    }

    private Group processGroupRef(ProcessingState state, String groupName) {
        List groupFiles = state.fromTypeIndex(Type.GROUP).stream().filter(f -> {
            Group group = (Group)f.getEntityUnchecked();
            return state.isCurrentRegistryId(group.getRegistryId()) && groupName.equals(group.getId());
        }).collect(Collectors.toList());
        if (groupFiles.isEmpty()) {
            state.recordError("Could not find group with ID %s in registry %s", groupName, state.getCurrentRegistry().getId());
            return null;
        }
        if (groupFiles.size() > 1) {
            state.recordError("Multiple groups with ID %s found in registry %s: %s", groupName, state.getCurrentRegistry().getId(), groupFiles);
            return null;
        }
        GitFile groupFile = (GitFile)groupFiles.get(0);
        Group group = (Group)groupFile.getEntityUnchecked();
        if (groupFile.isProcessed()) {
            return group;
        }
        try {
            GroupEntity e = new GroupEntity();
            e.groupId = group.getId();
            this.log.debug("Importing {}", (Object)e);
            state.getStorage().importGroup(e);
            groupFile.setProcessed(true);
            return group;
        }
        catch (Exception ex) {
            state.recordError("Could not import group %s: %s", group.getId(), ex.getMessage());
            return null;
        }
    }

    private Content processContent(ProcessingState state, GitFile base, String contentRef) {
        GitFile contentFile = this.findFileByPathRef(state, base, contentRef);
        if (contentFile != null) {
            if (contentFile.isType(Type.CONTENT)) {
                Content content = (Content)contentFile.getEntityUnchecked();
                if (state.isCurrentRegistryId(content.getRegistryId())) {
                    if (!contentFile.isProcessed()) {
                        GitFile dataFile = this.findFileByPathRef(state, contentFile, content.getDataFile());
                        if (dataFile != null) {
                            ContentHandle data = dataFile.getData();
                            if (ContentTypeUtil.isParsableYaml((ContentHandle)data)) {
                                data = ContentTypeUtil.yamlToJson((ContentHandle)data);
                            }
                            try {
                                String contentType = "application/json";
                                if (dataFile.getPath().toLowerCase().endsWith(".yaml") || dataFile.getPath().toLowerCase().endsWith(".yml")) {
                                    contentType = "application/x-yaml";
                                } else if (dataFile.getPath().toLowerCase().endsWith(".xml") || dataFile.getPath().toLowerCase().endsWith(".wsdl") || dataFile.getPath().toLowerCase().endsWith(".xsd")) {
                                    contentType = "application/xml";
                                } else if (dataFile.getPath().toLowerCase().endsWith(".proto")) {
                                    contentType = "application/x-protobuf";
                                } else if (dataFile.getPath().toLowerCase().endsWith(".graphql")) {
                                    contentType = "application/graphql";
                                }
                                TypedContent typedContent = TypedContent.create((ContentHandle)data, (String)contentType);
                                ContentEntity e = new ContentEntity();
                                e.contentId = content.getId();
                                e.contentHash = content.getContentHash();
                                e.contentBytes = data.bytes();
                                content.setArtifactType(this.utils.determineArtifactType(typedContent, content.getArtifactType()));
                                e.canonicalHash = this.utils.getCanonicalContentHash(typedContent, content.getArtifactType(), null, null);
                                e.artifactType = content.getArtifactType();
                                e.contentType = contentType;
                                if (contentFile.getPath().toLowerCase().endsWith(".yaml") || contentFile.getPath().toLowerCase().endsWith(".yml")) {
                                    e.contentType = "application/x-yaml";
                                } else if (contentFile.getPath().toLowerCase().endsWith(".xml") || contentFile.getPath().toLowerCase().endsWith(".wsdl") || contentFile.getPath().toLowerCase().endsWith(".xsd")) {
                                    e.contentType = "application/xml";
                                } else if (contentFile.getPath().toLowerCase().endsWith(".proto")) {
                                    e.contentType = "application/x-protobuf";
                                }
                                this.log.debug("Importing {}", (Object)e);
                                state.getStorage().importContent(e);
                                contentFile.setProcessed(true);
                                dataFile.setProcessed(true);
                                return content;
                            }
                            catch (Exception ex) {
                                state.recordError("Could not import content %s: %s", contentFile.getPath(), ex.getMessage());
                                return null;
                            }
                        }
                        state.recordError("Could not find content data file at path %s referenced by %s", FilenameUtils.concat((String)FilenameUtils.concat((String)contentFile.getPath(), (String)".."), (String)content.getDataFile()), contentFile.getPath());
                        return null;
                    }
                    return content;
                }
                state.recordError("Content file %s does not belong to this registry", contentFile.getPath());
                return null;
            }
            state.recordError("File %s is not a valid content definition", contentFile.getPath());
            return null;
        }
        state.recordError("Could not find content file at path %s", FilenameUtils.concat((String)FilenameUtils.concat((String)base.getPath(), (String)".."), (String)contentRef));
        return null;
    }

    private GitFile findFileByPathRef(ProcessingState state, GitFile base, String path) {
        path = FilenameUtils.concat((String)FilenameUtils.concat((String)base.getPath(), (String)".."), (String)path);
        return state.getPathIndex().get(path);
    }

    @PreDestroy
    public void close() {
        if (this.git != null) {
            this.git.close();
        }
    }

    @Generated
    public RevCommit getPreviousCommit() {
        return this.previousCommit;
    }
}

