/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.gitops;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.metrics.StorageMetricsApply;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.GAV;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.BranchMetaDataDto;
import io.apicurio.registry.storage.dto.BranchSearchResultsDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RoleMappingSearchResultsDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.storage.impl.gitops.AbstractReadOnlyRegistryStorage;
import io.apicurio.registry.storage.impl.gitops.GitManager;
import io.apicurio.registry.storage.impl.gitops.ProcessingState;
import io.apicurio.registry.storage.impl.gitops.sql.BlueSqlStorage;
import io.apicurio.registry.storage.impl.gitops.sql.GreenSqlStorage;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.Entity;
import io.quarkus.scheduler.Scheduled;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
@StorageMetricsApply
@Logged
public class GitOpsRegistryStorage
extends AbstractReadOnlyRegistryStorage {
    @Inject
    Logger log;
    @Inject
    BlueSqlStorage blue;
    @Inject
    GreenSqlStorage green;
    @Inject
    GitManager gitManager;
    @ConfigProperty(name="apicurio.storage.kind")
    @Info(category="storage", description="Application storage variant, for example, sql, kafkasql, or gitops", availableSince="3.0.0.Final")
    String registryStorageType;
    ReentrantReadWriteLock switchLock = new ReentrantReadWriteLock(true);
    RegistryStorage active = null;
    RegistryStorage inactive = null;
    private volatile State state = State.READY_TO_WRITE;

    @Override
    public void initialize() {
        this.log.info("Using GitOps storage");
        this.green.initialize();
        this.blue.initialize();
        try {
            this.active = this.green;
            this.inactive = this.blue;
            this.gitManager.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Scheduled(concurrentExecution=Scheduled.ConcurrentExecution.SKIP, every="{apicurio.gitops.refresh.every}")
    void refresh() {
        if (this.registryStorageType.equals("gitops")) {
            this.log.debug("Running GitOps refresh. Active database is {} and state is {}.", (Object)(this.active == this.green ? "green" : "blue"), (Object)this.state);
            switch (this.state) {
                case READY_TO_SWITCH: {
                    try {
                        if (!this.switchLock.writeLock().tryLock(5L, TimeUnit.SECONDS)) break;
                        RegistryStorage previous = this.active;
                        try {
                            this.active = this.inactive;
                            this.inactive = previous;
                            break;
                        }
                        finally {
                            this.state = State.READY_TO_WRITE;
                            this.switchLock.writeLock().unlock();
                            this.log.info("GitOps update published");
                        }
                    }
                    catch (InterruptedException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                case READY_TO_WRITE: {
                    try {
                        RevCommit updatedCommit = this.gitManager.poll();
                        if (updatedCommit.equals((AnyObjectId)this.gitManager.getPreviousCommit())) break;
                        this.inactive.deleteAllUserData();
                        ProcessingState processingState = new ProcessingState(this.inactive);
                        this.gitManager.run(processingState, updatedCommit);
                        if (processingState.isSuccessful()) {
                            this.log.info("GitOps update loaded successfully");
                            this.gitManager.updateCurrentCommit(updatedCommit);
                            this.state = State.READY_TO_SWITCH;
                            break;
                        }
                        this.log.error("GitOps update failed to load");
                        processingState.getErrors().forEach(e -> this.log.error("Error: {}", e));
                        break;
                    }
                    catch (Exception e3) {
                        throw new RuntimeException(e3);
                    }
                }
            }
            this.log.debug("GitOps refresh finished. Active database is {} and state is {}.", (Object)(this.active == this.green ? "green" : "blue"), (Object)this.state);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T proxy(Function<RegistryStorage, T> operation) {
        try {
            if (!this.switchLock.readLock().tryLock(5L, TimeUnit.SECONDS)) throw new RegistryStorageException("Could not acquire read lock to get the active storage within 5 seconds");
            try {
                RegistryStorage registryStorage = operation.apply(this.active);
                return (T)registryStorage;
            }
            finally {
                this.switchLock.readLock().unlock();
            }
        }
        catch (InterruptedException ex) {
            throw new RegistryStorageException("Could not acquire read lock to get the active storage", ex);
        }
    }

    public void proxyAction(Consumer<RegistryStorage> action) {
        block6: {
            try {
                if (this.switchLock.readLock().tryLock(5L, TimeUnit.SECONDS)) {
                    try {
                        action.accept(this.active);
                        break block6;
                    }
                    finally {
                        this.switchLock.readLock().unlock();
                    }
                }
                throw new RegistryStorageException("Could not acquire read lock to get the active storage within 5 seconds");
            }
            catch (InterruptedException ex) {
                throw new RegistryStorageException("Could not acquire read lock to get the active storage", ex);
            }
        }
    }

    @Override
    public String storageName() {
        return "gitops";
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @PreDestroy
    void onDestroy() {
    }

    @Override
    public ContentWrapperDto getContentById(long contentId) {
        return this.proxy(storage -> storage.getContentById(contentId));
    }

    @Override
    public ContentWrapperDto getContentByHash(String contentHash) {
        return this.proxy(storage -> storage.getContentByHash(contentHash));
    }

    @Override
    public List<ArtifactVersionMetaDataDto> getArtifactVersionsByContentId(long contentId) {
        return this.proxy(storage -> storage.getArtifactVersionsByContentId(contentId));
    }

    @Override
    public List<Long> getEnabledArtifactContentIds(String groupId, String artifactId) {
        return this.proxy(storage -> storage.getEnabledArtifactContentIds(groupId, artifactId));
    }

    @Override
    public Set<String> getArtifactIds(Integer limit) {
        return this.proxy(storage -> storage.getArtifactIds(limit));
    }

    @Override
    public ArtifactSearchResultsDto searchArtifacts(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) {
        return this.proxy(storage -> storage.searchArtifacts(filters, orderBy, orderDirection, offset, limit));
    }

    @Override
    public VersionSearchResultsDto searchVersions(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) throws RegistryStorageException {
        return this.proxy(storage -> storage.searchVersions(filters, orderBy, orderDirection, offset, limit));
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(String groupId, String artifactId) {
        return this.proxy(storage -> storage.getArtifactMetaData(groupId, artifactId));
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaDataByContent(String groupId, String artifactId, boolean canonical, TypedContent content, List<ArtifactReferenceDto> artifactReferences) {
        return this.proxy(storage -> storage.getArtifactVersionMetaDataByContent(groupId, artifactId, canonical, content, artifactReferences));
    }

    @Override
    public List<RuleType> getArtifactRules(String groupId, String artifactId) {
        return this.proxy(storage -> storage.getArtifactRules(groupId, artifactId));
    }

    @Override
    public List<RuleType> getGroupRules(String groupId) throws RegistryStorageException {
        return this.proxy(storage -> storage.getGroupRules(groupId));
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String groupId, String artifactId, RuleType rule) {
        return this.proxy(storage -> storage.getArtifactRule(groupId, artifactId, rule));
    }

    @Override
    public RuleConfigurationDto getGroupRule(String groupId, RuleType rule) throws RegistryStorageException {
        return this.proxy(storage -> storage.getGroupRule(groupId, rule));
    }

    @Override
    public List<String> getArtifactVersions(String groupId, String artifactId) {
        return this.proxy(storage -> storage.getArtifactVersions(groupId, artifactId));
    }

    @Override
    public List<String> getArtifactVersions(String groupId, String artifactId, RegistryStorage.RetrievalBehavior behavior) {
        return this.proxy(storage -> storage.getArtifactVersions(groupId, artifactId, behavior));
    }

    @Override
    public StoredArtifactVersionDto getArtifactVersionContent(long globalId) {
        return this.proxy(storage -> storage.getArtifactVersionContent(globalId));
    }

    @Override
    public StoredArtifactVersionDto getArtifactVersionContent(String groupId, String artifactId, String version) {
        return this.proxy(storage -> storage.getArtifactVersionContent(groupId, artifactId, version));
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        return this.proxy(storage -> storage.getArtifactVersionMetaData(groupId, artifactId, version));
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(Long globalId) throws VersionNotFoundException, RegistryStorageException {
        return this.proxy(storage -> storage.getArtifactVersionMetaData(globalId));
    }

    @Override
    public List<RuleType> getGlobalRules() {
        return this.proxy(RegistryStorage::getGlobalRules);
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType rule) {
        return this.proxy(storage -> storage.getGlobalRule(rule));
    }

    @Override
    public List<String> getGroupIds(Integer limit) {
        return this.proxy(storage -> storage.getGroupIds(limit));
    }

    @Override
    public GroupMetaDataDto getGroupMetaData(String groupId) {
        return this.proxy(storage -> storage.getGroupMetaData(groupId));
    }

    @Override
    public void exportData(Function<Entity, Void> handler) {
        this.proxyAction(storage -> storage.exportData(handler));
    }

    @Override
    public long countArtifacts() {
        return this.proxy(RegistryStorage::countArtifacts);
    }

    @Override
    public long countActiveArtifactVersions(String groupId, String artifactId) {
        return this.proxy(storage -> storage.countActiveArtifactVersions(groupId, artifactId));
    }

    @Override
    public long countArtifactVersions(String groupId, String artifactId) {
        return this.proxy(storage -> storage.countArtifactVersions(groupId, artifactId));
    }

    @Override
    public long countTotalArtifactVersions() {
        return this.proxy(RegistryStorage::countTotalArtifactVersions);
    }

    @Override
    public List<RoleMappingDto> getRoleMappings() {
        return this.proxy(RegistryStorage::getRoleMappings);
    }

    @Override
    public RoleMappingSearchResultsDto searchRoleMappings(int offset, int limit) throws RegistryStorageException {
        return this.proxy(storage -> storage.searchRoleMappings(offset, limit));
    }

    @Override
    public RoleMappingDto getRoleMapping(String principalId) {
        return this.proxy(storage -> storage.getRoleMapping(principalId));
    }

    @Override
    public String getRoleForPrincipal(String principalId) {
        return this.proxy(storage -> storage.getRoleForPrincipal(principalId));
    }

    @Override
    public DynamicConfigPropertyDto getRawConfigProperty(String propertyName) {
        return this.proxy(storage -> storage.getRawConfigProperty(propertyName));
    }

    @Override
    public List<DynamicConfigPropertyDto> getStaleConfigProperties(Instant since) {
        return this.proxy(storage -> storage.getStaleConfigProperties(since));
    }

    @Override
    public ContentWrapperDto getContentByReference(ArtifactReferenceDto reference) {
        return this.proxy(storage -> storage.getContentByReference(reference));
    }

    @Override
    public boolean isContentExists(String contentHash) {
        return this.proxy(storage -> storage.isContentExists(contentHash));
    }

    @Override
    public boolean isArtifactRuleExists(String groupId, String artifactId, RuleType rule) {
        return false;
    }

    @Override
    public boolean isGlobalRuleExists(RuleType rule) {
        return this.proxy(storage -> storage.isGlobalRuleExists(rule));
    }

    @Override
    public boolean isRoleMappingExists(String principalId) {
        return this.proxy(storage -> storage.isRoleMappingExists(principalId));
    }

    @Override
    public Optional<Long> contentIdFromHash(String contentHash) {
        return this.proxy(storage -> storage.contentIdFromHash(contentHash));
    }

    @Override
    public boolean isArtifactExists(String groupId, String artifactId) {
        return this.proxy(storage -> storage.isArtifactExists(groupId, artifactId));
    }

    @Override
    public boolean isEmpty() {
        return this.proxy(storage -> storage.isEmpty());
    }

    @Override
    public boolean isGroupExists(String groupId) {
        return this.proxy(storage -> storage.isGroupExists(groupId));
    }

    @Override
    public List<Long> getContentIdsReferencingArtifactVersion(String groupId, String artifactId, String version) {
        return this.proxy(storage -> storage.getContentIdsReferencingArtifactVersion(groupId, artifactId, version));
    }

    @Override
    public List<Long> getGlobalIdsReferencingArtifactVersion(String groupId, String artifactId, String version) {
        return this.proxy(storage -> storage.getGlobalIdsReferencingArtifactVersion(groupId, artifactId, version));
    }

    @Override
    public List<ArtifactReferenceDto> getInboundArtifactReferences(String groupId, String artifactId, String version) {
        return this.proxy(storage -> storage.getInboundArtifactReferences(groupId, artifactId, version));
    }

    @Override
    public boolean isArtifactVersionExists(String groupId, String artifactId, String version) {
        return this.proxy(storage -> storage.isArtifactVersionExists(groupId, artifactId, version));
    }

    @Override
    public GroupSearchResultsDto searchGroups(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, Integer offset, Integer limit) {
        return this.proxy(storage -> storage.searchGroups(filters, orderBy, orderDirection, offset, limit));
    }

    @Override
    public List<CommentDto> getArtifactVersionComments(String groupId, String artifactId, String version) {
        return this.proxy(storage -> storage.getArtifactVersionComments(groupId, artifactId, version));
    }

    public DynamicConfigPropertyDto getConfigProperty(String propertyName) {
        return this.proxy(storage -> storage.getConfigProperty(propertyName));
    }

    public List<DynamicConfigPropertyDto> getConfigProperties() {
        return this.proxy(DynamicConfigStorage::getConfigProperties);
    }

    @Override
    public BranchMetaDataDto getBranchMetaData(GA ga, BranchId branchId) {
        return this.proxy(storage -> storage.getBranchMetaData(ga, branchId));
    }

    @Override
    public BranchSearchResultsDto getBranches(GA ga, int offset, int limit) {
        return this.proxy(storage -> storage.getBranches(ga, offset, limit));
    }

    @Override
    public VersionSearchResultsDto getBranchVersions(GA ga, BranchId branchId, int offset, int limit) {
        return this.proxy(storage -> storage.getBranchVersions(ga, branchId, offset, limit));
    }

    @Override
    public GAV getBranchTip(GA ga, BranchId branchId, RegistryStorage.RetrievalBehavior behavior) {
        return this.proxy(storage -> storage.getBranchTip(ga, branchId, behavior));
    }

    @Override
    public String triggerSnapshotCreation() throws RegistryStorageException {
        return this.proxy(RegistryStorage::triggerSnapshotCreation);
    }

    @Override
    public String createSnapshot(String snapshotLocation) throws RegistryStorageException {
        return this.proxy(storage -> storage.createSnapshot(snapshotLocation));
    }

    @Override
    public String createEvent(OutboxEvent event) {
        return this.proxy(storage -> storage.createEvent(event));
    }

    @Override
    public boolean supportsDatabaseEvents() {
        return this.proxy(RegistryStorage::supportsDatabaseEvents);
    }

    private static enum State {
        READY_TO_SWITCH,
        READY_TO_WRITE;

    }
}

