/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.gitops;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalPropertiesReader;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.storage.impl.sql.RegistryDatabaseKind;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import jakarta.ws.rs.Produces;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class GreenDatasourceProducer {
    @ConfigProperty(name="apicurio.datasource.green.db-kind", defaultValue="h2")
    @Info(category="storage", description="Gitops green datasource db kind", availableSince="3.0.0.Final")
    String databaseType;
    @ConfigProperty(name="apicurio.datasource.green.jdbc.url", defaultValue="jdbc:h2:mem:registry_db")
    @Info(category="storage", description="Gitops green datasource jdbc url", availableSince="3.0.0.Final")
    String jdbcUrl;
    @ConfigProperty(name="apicurio.datasource.green.username", defaultValue="sa")
    @Info(category="storage", description="Gitops green datasource username", availableSince="3.0.0.Final")
    String username;
    @ConfigProperty(name="apicurio.datasource.green.password", defaultValue="sa")
    @Info(category="storage", description="Gitops green datasource password", availableSince="3.0.0.Final")
    String password;
    @ConfigProperty(name="apicurio.datasource.green.jdbc.initial-size", defaultValue="20")
    @Info(category="storage", description="Gitops green datasource pool initial size", availableSince="3.0.0.Final")
    String initialSize;
    @ConfigProperty(name="apicurio.datasource.green.jdbc.min-size", defaultValue="20")
    @Info(category="storage", description="Gitops green datasource pool minimum size", availableSince="3.0.0.Final")
    String minSize;
    @ConfigProperty(name="apicurio.datasource.green.jdbc.max-size", defaultValue="100")
    @Info(category="storage", description="Gitops green datasource pool max size", availableSince="3.0.0.Final")
    String maxSize;

    @Produces
    @ApplicationScoped
    @Named(value="green")
    public AgroalDataSource produceDatasource() throws SQLException {
        RegistryDatabaseKind databaseKind = RegistryDatabaseKind.valueOf(this.databaseType);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("maxSize", this.maxSize);
        props.put("minSize", this.minSize);
        props.put("initialSize", this.initialSize);
        props.put("jdbcUrl", this.jdbcUrl);
        props.put("principal", this.username);
        props.put("credential", this.password);
        props.put("providerClassName", databaseKind.getDriverClassName());
        return AgroalDataSource.from((AgroalDataSourceConfiguration)new AgroalPropertiesReader().readProperties(props).get(), (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
    }
}

