/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.gitops;

import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.impl.gitops.model.GitFile;
import io.apicurio.registry.storage.impl.gitops.model.Type;
import io.apicurio.registry.storage.impl.gitops.model.v0.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.eclipse.jgit.revwalk.RevCommit;

public class ProcessingState {
    private RegistryStorage storage;
    private Registry currentRegistry;
    private RevCommit updatedCommit;
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, GitFile> pathIndex = new HashMap<String, GitFile>();
    private final Map<Type, Set<GitFile>> typeIndex = new HashMap<Type, Set<GitFile>>();

    public ProcessingState(RegistryStorage storage) {
        this.storage = storage;
    }

    public void recordError(String message, Object ... params) {
        this.errors.add(String.format(message, params));
    }

    public boolean isSuccessful() {
        return this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean isCurrentRegistryId(String id) {
        return this.currentRegistry.getId().equals(id);
    }

    public Set<GitFile> fromTypeIndex(Type type) {
        return Collections.unmodifiableSet(this.typeIndex.computeIfAbsent(type, k -> new HashSet()));
    }

    public void index(GitFile file) {
        this.pathIndex.put(file.getPath(), file);
        file.getAny().ifPresent(a -> this.typeIndex.computeIfAbsent(a.getType(), k -> new HashSet()).add(file));
    }

    @Generated
    public RegistryStorage getStorage() {
        return this.storage;
    }

    @Generated
    public Registry getCurrentRegistry() {
        return this.currentRegistry;
    }

    @Generated
    public void setCurrentRegistry(Registry currentRegistry) {
        this.currentRegistry = currentRegistry;
    }

    @Generated
    public RevCommit getUpdatedCommit() {
        return this.updatedCommit;
    }

    @Generated
    public void setUpdatedCommit(RevCommit updatedCommit) {
        this.updatedCommit = updatedCommit;
    }

    @Generated
    public Map<String, GitFile> getPathIndex() {
        return this.pathIndex;
    }
}

