/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.gitops.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.impl.gitops.ProcessingState;
import io.apicurio.registry.storage.impl.gitops.YAMLObjectMapper;
import io.apicurio.registry.storage.impl.gitops.model.Type;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Any {
    private static final Logger log = LoggerFactory.getLogger(Any.class);
    private JsonNode raw;
    private Type type;
    private Object entity;

    public static Optional<Any> from(ProcessingState state, String path, ContentHandle content) {
        try {
            String rawType;
            Optional<Type> type;
            JsonNode raw = YAMLObjectMapper.MAPPER.readTree(content.bytes());
            JsonNode typeNode = raw.get("$type");
            if (typeNode != null && typeNode.textValue() != null && (type = Type.from(rawType = typeNode.textValue())).isPresent()) {
                try {
                    Object entity = YAMLObjectMapper.MAPPER.treeToValue((TreeNode)raw, type.get().getKlass());
                    Any any = Any.builder().raw(raw).type(type.get()).entity(entity).build();
                    return Optional.of(any);
                }
                catch (JsonProcessingException ex) {
                    state.recordError("Could not parse file %s as %s: %s", new Object[]{path, type.get(), ex.getOriginalMessage()});
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            return Optional.empty();
        }
    }

    @Generated
    public static AnyBuilder builder() {
        return new AnyBuilder();
    }

    @Generated
    private Any(JsonNode raw, Type type, Object entity) {
        this.raw = raw;
        this.type = type;
        this.entity = entity;
    }

    @Generated
    public JsonNode getRaw() {
        return this.raw;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Object getEntity() {
        return this.entity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Any)) {
            return false;
        }
        Any other = (Any)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonNode this$raw = this.getRaw();
        JsonNode other$raw = other.getRaw();
        if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Object this$entity = this.getEntity();
        Object other$entity = other.getEntity();
        return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Any;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonNode $raw = this.getRaw();
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Object $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Any(raw=" + this.getRaw() + ", type=" + this.getType() + ", entity=" + this.getEntity() + ")";
    }

    @Generated
    public static class AnyBuilder {
        @Generated
        private JsonNode raw;
        @Generated
        private Type type;
        @Generated
        private Object entity;

        @Generated
        AnyBuilder() {
        }

        @Generated
        public AnyBuilder raw(JsonNode raw) {
            this.raw = raw;
            return this;
        }

        @Generated
        public AnyBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public AnyBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        @Generated
        public Any build() {
            return new Any(this.raw, this.type, this.entity);
        }

        @Generated
        public String toString() {
            return "Any.AnyBuilder(raw=" + this.raw + ", type=" + this.type + ", entity=" + this.entity + ")";
        }
    }
}

