/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.gitops.model;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.impl.gitops.ProcessingState;
import io.apicurio.registry.storage.impl.gitops.model.Any;
import io.apicurio.registry.storage.impl.gitops.model.Type;
import java.io.InputStream;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitFile {
    private static final Logger log = LoggerFactory.getLogger(GitFile.class);
    private String path;
    private ContentHandle data;
    private Optional<Any> any;
    private boolean processed;

    public static GitFile create(ProcessingState state, String path, InputStream stream) {
        ContentHandle data = ContentHandle.create((InputStream)stream);
        return GitFile.builder().path(FilenameUtils.normalize((String)path)).data(data).any(Any.from(state, path, data)).build();
    }

    public boolean isType(Type type) {
        return this.any.map(a -> type == a.getType()).orElse(false);
    }

    public <T> T getEntityUnchecked() {
        return (T)this.any.get().getEntity();
    }

    @Generated
    public static GitFileBuilder builder() {
        return new GitFileBuilder();
    }

    @Generated
    private GitFile(String path, ContentHandle data, Optional<Any> any, boolean processed) {
        this.path = path;
        this.data = data;
        this.any = any;
        this.processed = processed;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public ContentHandle getData() {
        return this.data;
    }

    @Generated
    public Optional<Any> getAny() {
        return this.any;
    }

    @Generated
    public boolean isProcessed() {
        return this.processed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitFile)) {
            return false;
        }
        GitFile other = (GitFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitFile(path=" + this.getPath() + ", data=" + this.getData() + ", any=" + this.getAny() + ", processed=" + this.isProcessed() + ")";
    }

    @Generated
    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    @Generated
    public static class GitFileBuilder {
        @Generated
        private String path;
        @Generated
        private ContentHandle data;
        @Generated
        private Optional<Any> any;
        @Generated
        private boolean processed;

        @Generated
        GitFileBuilder() {
        }

        @Generated
        public GitFileBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public GitFileBuilder data(ContentHandle data) {
            this.data = data;
            return this;
        }

        @Generated
        public GitFileBuilder any(Optional<Any> any) {
            this.any = any;
            return this;
        }

        @Generated
        public GitFileBuilder processed(boolean processed) {
            this.processed = processed;
            return this;
        }

        @Generated
        public GitFile build() {
            return new GitFile(this.path, this.data, this.any, this.processed);
        }

        @Generated
        public String toString() {
            return "GitFile.GitFileBuilder(path=" + this.path + ", data=" + this.data + ", any=" + this.any + ", processed=" + this.processed + ")";
        }
    }
}

