/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.types.RegistryException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@ApplicationScoped
public class KafkaSqlCoordinator {
    @Inject
    KafkaSqlConfiguration configuration;
    private static final Object NULL = new Object();
    private Map<UUID, CountDownLatch> latches = new ConcurrentHashMap<UUID, CountDownLatch>();
    private Map<UUID, Object> returnValues = new ConcurrentHashMap<UUID, Object>();

    public UUID createUUID() {
        UUID uuid = UUID.randomUUID();
        this.latches.put(uuid, new CountDownLatch(1));
        return uuid;
    }

    public Object waitForResponse(UUID uuid) {
        try {
            this.latches.get(uuid).await(this.configuration.responseTimeout().intValue(), TimeUnit.MILLISECONDS);
            Object rval = this.returnValues.remove(uuid);
            if (rval == NULL) {
                Object var3_4 = null;
                return var3_4;
            }
            if (rval instanceof RegistryException) {
                throw (RegistryException)rval;
            }
            Object object = rval;
            return object;
        }
        catch (InterruptedException e) {
            throw new RegistryException("[KafkaSqlCoordinator] Thread interrupted waiting for a Kafka Sql response.", e);
        }
        finally {
            this.latches.remove(uuid);
        }
    }

    public void notifyResponse(UUID uuid, Object returnValue) {
        if (uuid == null) {
            return;
        }
        if (!this.latches.containsKey(uuid)) {
            return;
        }
        if (returnValue == null) {
            returnValue = NULL;
        }
        this.returnValues.put(uuid, returnValue);
        this.latches.get(uuid).countDown();
    }
}

