/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlOutboxEvent;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.kafka.ProducerActions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;

@ApplicationScoped
public class KafkaSqlEventsProcessor {
    @Inject
    KafkaSqlConfiguration configuration;
    @Inject
    @Named(value="KafkaSqlEventsProducer")
    ProducerActions<String, String> eventsProducer;

    public void processEvent(@Observes KafkaSqlOutboxEvent event) {
        OutboxEvent outboxEvent = event.getOutboxEvent();
        ProducerRecord record = new ProducerRecord(this.configuration.eventsTopic(), Integer.valueOf(0), (Object)outboxEvent.getAggregateId(), (Object)outboxEvent.getPayload().toString(), Collections.emptyList());
        ConcurrentUtil.get((CompletableFuture)((CompletableFuture)this.eventsProducer.apply((Object)record)));
    }
}

