/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessage;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessageKey;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlKeyDeserializer;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlKeySerializer;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlPartitioner;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlValueDeserializer;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlValueSerializer;
import io.apicurio.registry.utils.RegistryProperties;
import io.apicurio.registry.utils.kafka.AsyncProducer;
import io.apicurio.registry.utils.kafka.ProducerActions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class KafkaSqlFactory {
    @Inject
    @ConfigProperty(name="apicurio.kafkasql.bootstrap.servers")
    @Info(category="storage", description="Kafka sql storage bootstrap servers")
    String bootstrapServers;
    @Inject
    @ConfigProperty(name="apicurio.kafkasql.topic", defaultValue="kafkasql-journal")
    @Info(category="storage", description="Kafka sql storage topic name")
    String topic;
    @Inject
    @ConfigProperty(name="apicurio.kafkasql.snapshots.topic", defaultValue="kafkasql-snapshots")
    @Info(category="storage", description="Kafka sql storage topic name", registryAvailableSince="3.0.0")
    String snapshotsTopic;
    @Inject
    @ConfigProperty(name="apicurio.kafkasql.snapshot.every.seconds", defaultValue="86400s")
    @Info(category="storage", description="Kafka sql journal topic snapshot every", registryAvailableSince="3.0.0")
    String snapshotEvery;
    @Inject
    @ConfigProperty(name="apicurio.storage.snapshot.location", defaultValue="./")
    @Info(category="storage", description="Kafka sql snapshots store location", registryAvailableSince="3.0.0")
    String snapshotStoreLocation;
    @Inject
    @ConfigProperty(name="apicurio.events.kafka.topic", defaultValue="registry-events")
    @Info(category="storage", description="Kafka sql storage event topic", registryAvailableSince="3.0.1")
    String eventsTopic;
    @Inject
    @RegistryProperties(value={"apicurio.kafkasql.topic"})
    @Info(category="storage", description="Kafka sql storage topic properties")
    Properties topicProperties;
    @Inject
    @ConfigProperty(name="apicurio.kafkasql.topic.auto-create", defaultValue="true")
    @Info(category="storage", description="Kafka sql storage topic auto create")
    Boolean topicAutoCreate;
    @Inject
    @ConfigProperty(name="apicurio.kafkasql.consumer.poll.timeout", defaultValue="5000")
    @Info(category="storage", description="Kafka sql storage consumer poll timeout")
    Integer pollTimeout;
    @Inject
    @ConfigProperty(name="apicurio.kafkasql.coordinator.response-timeout", defaultValue="30000")
    @Info(category="storage", description="Kafka sql storage coordinator response timeout")
    Integer responseTimeout;
    @Inject
    @RegistryProperties(value={"apicurio.kafka.common", "apicurio.kafkasql.producer"}, empties={"ssl.endpoint.identification.algorithm="})
    Properties producerProperties;
    @Inject
    @RegistryProperties(value={"apicurio.kafka.common", "apicurio.kafkasql.consumer"}, empties={"ssl.endpoint.identification.algorithm="})
    Properties consumerProperties;
    @Inject
    @RegistryProperties(value={"apicurio.kafka.common", "apicurio.kafkasql.admin"}, empties={"ssl.endpoint.identification.algorithm="})
    Properties adminProperties;
    @ConfigProperty(name="apicurio.kafkasql.security.sasl.enabled", defaultValue="false")
    @Info(category="storage", description="Kafka sql storage sasl enabled")
    boolean saslEnabled;
    @ConfigProperty(name="apicurio.kafkasql.security.protocol", defaultValue="")
    @Info(category="storage", description="Kafka sql storage security protocol")
    Optional<String> protocol;
    @ConfigProperty(name="apicurio.kafkasql.security.sasl.mechanism", defaultValue="")
    @Info(category="storage", description="Kafka sql storage sasl mechanism")
    String saslMechanism;
    @ConfigProperty(name="apicurio.kafkasql.security.sasl.client-id", defaultValue="")
    @Info(category="storage", description="Kafka sql storage sasl client identifier")
    String clientId;
    @ConfigProperty(name="apicurio.kafkasql.security.sasl.client-secret", defaultValue="")
    @Info(category="storage", description="Kafka sql storage sasl client secret")
    String clientSecret;
    @ConfigProperty(name="apicurio.kafkasql.security.sasl.token.endpoint", defaultValue="")
    @Info(category="storage", description="Kafka sql storage sasl token endpoint")
    String tokenEndpoint;
    @ConfigProperty(name="apicurio.kafkasql.security.sasl.login.callback.handler.class", defaultValue="")
    @Info(category="storage", description="Kafka sql storage sasl login callback handler")
    String loginCallbackHandler;
    @ConfigProperty(name="apicurio.kafkasql.security.ssl.truststore.location")
    @Info(category="storage", description="Kafka sql storage ssl truststore location")
    Optional<String> trustStoreLocation;
    @ConfigProperty(name="apicurio.kafkasql.security.ssl.truststore.type")
    @Info(category="storage", description="Kafka sql storage ssl truststore type")
    Optional<String> trustStoreType;
    @ConfigProperty(name="apicurio.kafkasql.ssl.truststore.password")
    @Info(category="storage", description="Kafka sql storage ssl truststore password")
    Optional<String> trustStorePassword;
    @ConfigProperty(name="apicurio.kafkasql.ssl.keystore.location")
    @Info(category="storage", description="Kafka sql storage ssl keystore location")
    Optional<String> keyStoreLocation;
    @ConfigProperty(name="apicurio.kafkasql.ssl.keystore.type")
    @Info(category="storage", description="Kafka sql storage ssl keystore type")
    Optional<String> keyStoreType;
    @ConfigProperty(name="apicurio.kafkasql.ssl.keystore.password")
    @Info(category="storage", description="Kafka sql storage ssl keystore password")
    Optional<String> keyStorePassword;
    @ConfigProperty(name="apicurio.kafkasql.ssl.key.password")
    @Info(category="storage", description="Kafka sql storage ssl key password")
    Optional<String> keyPassword;

    @ApplicationScoped
    @Produces
    public KafkaSqlConfiguration createConfiguration() {
        return new KafkaSqlConfiguration(){

            @Override
            public String bootstrapServers() {
                return KafkaSqlFactory.this.bootstrapServers;
            }

            @Override
            public String topic() {
                return KafkaSqlFactory.this.topic;
            }

            @Override
            public String snapshotsTopic() {
                return KafkaSqlFactory.this.snapshotsTopic;
            }

            @Override
            public String eventsTopic() {
                return KafkaSqlFactory.this.eventsTopic;
            }

            @Override
            public String snapshotEvery() {
                return KafkaSqlFactory.this.snapshotEvery;
            }

            @Override
            public String snapshotLocation() {
                return KafkaSqlFactory.this.snapshotStoreLocation;
            }

            @Override
            public Properties topicProperties() {
                return KafkaSqlFactory.this.topicProperties;
            }

            @Override
            public boolean isTopicAutoCreate() {
                return KafkaSqlFactory.this.topicAutoCreate;
            }

            @Override
            public Integer pollTimeout() {
                return KafkaSqlFactory.this.pollTimeout;
            }

            @Override
            public Integer responseTimeout() {
                return KafkaSqlFactory.this.responseTimeout;
            }

            @Override
            public Properties producerProperties() {
                return KafkaSqlFactory.this.producerProperties;
            }

            @Override
            public Properties consumerProperties() {
                return KafkaSqlFactory.this.consumerProperties;
            }

            @Override
            public Properties adminProperties() {
                KafkaSqlFactory.this.tryToConfigureSecurity(KafkaSqlFactory.this.adminProperties);
                return KafkaSqlFactory.this.adminProperties;
            }
        };
    }

    @ApplicationScoped
    @Produces
    @Named(value="KafkaSqlJournalProducer")
    public ProducerActions<KafkaSqlMessageKey, KafkaSqlMessage> createKafkaJournalProducer() {
        Properties props = (Properties)this.producerProperties.clone();
        props.putIfAbsent("bootstrap.servers", this.bootstrapServers);
        props.putIfAbsent("client.id", "Producer-" + UUID.randomUUID().toString());
        props.putIfAbsent("acks", "all");
        props.putIfAbsent("linger.ms", (Object)10);
        props.putIfAbsent("partitioner.class", KafkaSqlPartitioner.class);
        this.tryToConfigureSecurity(props);
        KafkaSqlKeySerializer keySerializer = new KafkaSqlKeySerializer();
        KafkaSqlValueSerializer valueSerializer = new KafkaSqlValueSerializer();
        return new AsyncProducer(props, (Serializer)keySerializer, (Serializer)valueSerializer);
    }

    @ApplicationScoped
    @Produces
    @Named(value="KafkaSqlJournalConsumer")
    public KafkaConsumer<KafkaSqlMessageKey, KafkaSqlMessage> createKafkaJournalConsumer() {
        Properties props = (Properties)this.consumerProperties.clone();
        props.putIfAbsent("bootstrap.servers", this.bootstrapServers);
        props.putIfAbsent("group.id", UUID.randomUUID().toString());
        props.putIfAbsent("enable.auto.commit", "true");
        props.putIfAbsent("auto.commit.interval.ms", "1000");
        props.putIfAbsent("auto.offset.reset", "earliest");
        this.tryToConfigureSecurity(props);
        KafkaSqlKeyDeserializer keyDeserializer = new KafkaSqlKeyDeserializer();
        KafkaSqlValueDeserializer valueDeserializer = new KafkaSqlValueDeserializer();
        return new KafkaConsumer<KafkaSqlMessageKey, KafkaSqlMessage>(props, (Deserializer<KafkaSqlMessageKey>)keyDeserializer, (Deserializer<KafkaSqlMessage>)valueDeserializer);
    }

    @ApplicationScoped
    @Produces
    @Named(value="KafkaSqlSnapshotsProducer")
    public ProducerActions<String, String> createKafkaSnapshotsProducer() {
        Properties props = (Properties)this.producerProperties.clone();
        props.putIfAbsent("bootstrap.servers", this.bootstrapServers);
        props.putIfAbsent("client.id", "Producer-" + UUID.randomUUID().toString());
        props.putIfAbsent("acks", "all");
        props.putIfAbsent("linger.ms", (Object)10);
        props.putIfAbsent("partitioner.class", KafkaSqlPartitioner.class);
        this.tryToConfigureSecurity(props);
        StringSerializer keySerializer = new StringSerializer();
        StringSerializer valueSerializer = new StringSerializer();
        return new AsyncProducer(props, (Serializer)keySerializer, (Serializer)valueSerializer);
    }

    @ApplicationScoped
    @Produces
    @Named(value="KafkaSqlSnapshotsConsumer")
    public KafkaConsumer<String, String> createKafkaSnapshotsConsumer() {
        Properties props = (Properties)this.consumerProperties.clone();
        props.putIfAbsent("bootstrap.servers", this.bootstrapServers);
        props.putIfAbsent("group.id", UUID.randomUUID().toString());
        props.putIfAbsent("enable.auto.commit", "true");
        props.putIfAbsent("auto.commit.interval.ms", "1000");
        props.putIfAbsent("auto.offset.reset", "earliest");
        this.tryToConfigureSecurity(props);
        StringDeserializer keySerializer = new StringDeserializer();
        StringDeserializer valueSerializer = new StringDeserializer();
        return new KafkaConsumer<String, String>(props, (Deserializer<String>)keySerializer, (Deserializer<String>)valueSerializer);
    }

    @ApplicationScoped
    @Produces
    @Named(value="KafkaSqlEventsProducer")
    public ProducerActions<String, String> createKafkaSqlEventsProducer() {
        Properties props = (Properties)this.producerProperties.clone();
        props.putIfAbsent("bootstrap.servers", this.bootstrapServers);
        props.putIfAbsent("client.id", "Producer-" + UUID.randomUUID().toString());
        props.putIfAbsent("acks", "all");
        props.putIfAbsent("linger.ms", (Object)10);
        props.putIfAbsent("partitioner.class", KafkaSqlPartitioner.class);
        this.tryToConfigureSecurity(props);
        StringSerializer keySerializer = new StringSerializer();
        StringSerializer valueSerializer = new StringSerializer();
        return new AsyncProducer(props, (Serializer)keySerializer, (Serializer)valueSerializer);
    }

    private void tryToConfigureSecurity(Properties props) {
        this.protocol.ifPresent(s -> props.putIfAbsent("security.protocol", s));
        if (this.saslEnabled) {
            props.putIfAbsent("sasl.jaas.config", String.format("org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required   oauth.client.id=\"%s\"   oauth.client.secret=\"%s\"   oauth.token.endpoint.uri=\"%s\" ;", this.clientId, this.clientSecret, this.tokenEndpoint));
            props.putIfAbsent("sasl.mechanism", this.saslMechanism);
            props.putIfAbsent("sasl.login.callback.handler.class", this.loginCallbackHandler);
        }
        if (this.trustStoreLocation.isPresent() && this.trustStorePassword.isPresent() && this.trustStoreType.isPresent()) {
            props.putIfAbsent("ssl.truststore.type", this.trustStoreType.get());
            props.putIfAbsent("ssl.truststore.location", this.trustStoreLocation.get());
            props.putIfAbsent("ssl.truststore.password", this.trustStorePassword.get());
        }
        if (this.keyStoreLocation.isPresent() && this.keyStorePassword.isPresent() && this.keyStoreType.isPresent()) {
            props.putIfAbsent("ssl.keystore.type", this.keyStoreType.get());
            props.putIfAbsent("ssl.keystore.location", this.keyStoreLocation.get());
            props.putIfAbsent("ssl.keystore.password", this.keyStorePassword.get());
            this.keyPassword.ifPresent(s -> props.putIfAbsent("ssl.key.password", s));
        }
    }
}

