/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.events.ArtifactCreated;
import io.apicurio.registry.events.ArtifactDeleted;
import io.apicurio.registry.events.ArtifactMetadataUpdated;
import io.apicurio.registry.events.ArtifactRuleConfigured;
import io.apicurio.registry.events.ArtifactVersionCreated;
import io.apicurio.registry.events.ArtifactVersionDeleted;
import io.apicurio.registry.events.ArtifactVersionMetadataUpdated;
import io.apicurio.registry.events.GlobalRuleConfigured;
import io.apicurio.registry.events.GroupCreated;
import io.apicurio.registry.events.GroupDeleted;
import io.apicurio.registry.events.GroupMetadataUpdated;
import io.apicurio.registry.events.GroupRuleConfigured;
import io.apicurio.registry.metrics.StorageMetricsApply;
import io.apicurio.registry.metrics.health.liveness.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.health.readiness.PersistenceTimeoutReadinessApply;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.VersionId;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.StorageEvent;
import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.decorator.RegistryStorageDecoratorReadOnlyBase;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.BranchMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableBranchMetaDataDto;
import io.apicurio.registry.storage.dto.EditableGroupMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.GroupAlreadyExistsException;
import io.apicurio.registry.storage.error.GroupNotFoundException;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.error.RuleAlreadyExistsException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlCoordinator;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessage;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessageKey;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlOutboxEvent;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlSubmitter;
import io.apicurio.registry.storage.impl.kafkasql.messages.AppendVersionToBranch3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ConsumeDownload1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateArtifact9Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateArtifactRule4Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateArtifactVersion8Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateArtifactVersionComment4Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateBranch4Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateDownload1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateGlobalRule2Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateGroup1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateGroupRule3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateRoleMapping3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.CreateSnapshot1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteAllExpiredDownloads0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteAllUserData0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteArtifact2Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteArtifactRule3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteArtifactRules2Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteArtifactVersion3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteArtifactVersionComment4Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteArtifacts1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteBranch2Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteConfigProperty1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteGlobalRule1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteGlobalRules0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteGroup1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteGroupRule2Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteGroupRules1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.DeleteRoleMapping1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportArtifact1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportArtifactRule1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportArtifactVersion1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportBranch1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportComment1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportContent1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportGlobalRule1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportGroup1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ImportGroupRule1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.NextCommentId0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.NextContentId0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.NextGlobalId0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ReplaceBranchVersions3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ResetCommentId0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ResetContentId0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.ResetGlobalId0Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.SetConfigProperty1Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateArtifactMetaData3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateArtifactRule4Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateArtifactVersionComment5Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateArtifactVersionMetaData4Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateBranchMetaData3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateContentCanonicalHash3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateGlobalRule2Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateGroupMetaData2Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateGroupRule3Message;
import io.apicurio.registry.storage.impl.kafkasql.messages.UpdateRoleMapping2Message;
import io.apicurio.registry.storage.impl.kafkasql.sql.KafkaSqlSink;
import io.apicurio.registry.storage.impl.sql.RegistryStorageContentUtils;
import io.apicurio.registry.storage.impl.sql.SqlRegistryStorage;
import io.apicurio.registry.storage.importing.v2.SqlDataUpgrader;
import io.apicurio.registry.storage.importing.v3.SqlDataImporter;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.impexp.EntityInputStream;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import io.apicurio.registry.utils.kafka.KafkaUtil;
import io.apicurio.registry.utils.kafka.ProducerActions;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.TopicExistsException;
import org.slf4j.Logger;

@ApplicationScoped
@PersistenceExceptionLivenessApply
@PersistenceTimeoutReadinessApply
@StorageMetricsApply
@Logged
public class KafkaSqlRegistryStorage
extends RegistryStorageDecoratorReadOnlyBase
implements RegistryStorage {
    @Inject
    Logger log;
    @Inject
    KafkaSqlConfiguration configuration;
    @Inject
    KafkaSqlCoordinator coordinator;
    @Inject
    KafkaSqlSink kafkaSqlSink;
    @Inject
    SqlRegistryStorage sqlStore;
    @Inject
    RegistryStorageContentUtils utils;
    @Inject
    @Named(value="KafkaSqlJournalConsumer")
    KafkaConsumer<KafkaSqlMessageKey, KafkaSqlMessage> journalConsumer;
    @Inject
    @Named(value="KafkaSqlSnapshotsConsumer")
    KafkaConsumer<String, String> snapshotsConsumer;
    @Inject
    @Named(value="KafkaSqlSnapshotsProducer")
    ProducerActions<String, String> snapshotsProducer;
    @Inject
    KafkaSqlSubmitter submitter;
    @Inject
    Event<StorageEvent> storageEvent;
    @Inject
    Event<KafkaSqlOutboxEvent> outboxEvent;
    private volatile boolean bootstrapped = false;
    private volatile boolean stopped = true;
    private volatile boolean snapshotProcessed = false;
    private volatile String lastTriggeredSnapshot = null;

    @Override
    public String storageName() {
        return "kafkasql";
    }

    @Override
    public void initialize() {
        this.log.info("Using Kafka-SQL artifactStore.");
        if (this.configuration.isTopicAutoCreate()) {
            this.autoCreateTopics();
        }
        long bootstrapStart = System.currentTimeMillis();
        String snapshotId = this.consumeSnapshotsTopic(this.snapshotsConsumer);
        this.sqlStore.initialize();
        this.setDelegate(this.sqlStore);
        this.log.info("SQL store initialized, starting consumer thread.");
        this.startConsumerThread(this.journalConsumer, snapshotId, bootstrapStart);
    }

    @Override
    public boolean isReady() {
        return this.bootstrapped;
    }

    @Override
    public boolean isAlive() {
        return this.bootstrapped && !this.stopped;
    }

    @PreDestroy
    void onDestroy() {
        this.stopped = true;
        this.journalConsumer.close();
        this.snapshotsConsumer.close();
    }

    private void autoCreateTopics() {
        Set<String> topicNames = Set.of(this.configuration.topic(), this.configuration.snapshotsTopic(), this.configuration.eventsTopic());
        HashMap topicProperties = new HashMap();
        this.configuration.topicProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> topicProperties.put(key.toString(), value.toString())));
        Properties adminProperties = this.configuration.adminProperties();
        adminProperties.putIfAbsent("bootstrap.servers", this.configuration.bootstrapServers());
        try {
            KafkaUtil.createTopics((Properties)adminProperties, topicNames, topicProperties);
        }
        catch (TopicExistsException e) {
            this.log.info("Topic {} already exists, skipping.", (Object)this.configuration.topic());
        }
    }

    private String consumeSnapshotsTopic(KafkaConsumer<String, String> snapshotsConsumer) {
        Set<String> topics = Collections.singleton(this.configuration.snapshotsTopic());
        snapshotsConsumer.subscribe(topics);
        ConsumerRecords<String, String> records = snapshotsConsumer.poll(Duration.ofMillis(this.configuration.pollTimeout().intValue()));
        ArrayList<ConsumerRecord> snapshots = new ArrayList<ConsumerRecord>();
        String snapshotRecordKey = null;
        if (records != null && !records.isEmpty()) {
            records.forEach(snapshots::add);
            snapshots.sort(Comparator.comparingLong(ConsumerRecord::timestamp));
            Path mostRecentSnapshotPath = null;
            for (ConsumerRecord snapshotFound : snapshots) {
                try {
                    String path = (String)snapshotFound.value();
                    if (null == path || path.isBlank() || !Files.exists(Path.of((String)snapshotFound.value(), new String[0]), new LinkOption[0])) continue;
                    this.log.debug("Snapshot with path {} found.", snapshotFound.value());
                    snapshotRecordKey = (String)snapshotFound.key();
                    mostRecentSnapshotPath = Path.of((String)snapshotFound.value(), new String[0]);
                }
                catch (IllegalArgumentException ex) {
                    this.log.warn("Snapshot with path {} ignored, the snapshot is likely invalid or cannot be found", snapshotFound.value());
                }
            }
            if (null != mostRecentSnapshotPath) {
                this.log.info("Restoring snapshot {} to the internal database...", mostRecentSnapshotPath);
                this.sqlStore.restoreFromSnapshot(mostRecentSnapshotPath.toString());
            }
        }
        return snapshotRecordKey;
    }

    private void startConsumerThread(KafkaConsumer<KafkaSqlMessageKey, KafkaSqlMessage> consumer, String snapshotId, long bootstrapStart) {
        this.log.info("Starting KSQL consumer thread on topic: {}", (Object)this.configuration.topic());
        this.log.info("Bootstrap servers: {}", (Object)this.configuration.bootstrapServers());
        String bootstrapId = UUID.randomUUID().toString();
        this.submitter.submitBootstrap(bootstrapId);
        Runnable runner = () -> {
            try (KafkaConsumer kafkaConsumer = consumer;){
                this.log.info("Subscribing to {}", (Object)this.configuration.topic());
                Set<String> topics = Collections.singleton(this.configuration.topic());
                consumer.subscribe(topics);
                while (!this.stopped) {
                    ConsumerRecords records = consumer.poll(Duration.ofMillis(this.configuration.pollTimeout().intValue()));
                    if (records == null || records.isEmpty()) continue;
                    this.log.debug("Consuming {} journal records.", (Object)records.count());
                    if (null != snapshotId && !this.snapshotProcessed) {
                        ConsumerRecord record2;
                        Iterator it = records.iterator();
                        while (it.hasNext() && !this.snapshotProcessed) {
                            record2 = (ConsumerRecord)it.next();
                            if (this.processSnapshot(snapshotId, (ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage>)record2)) {
                                this.log.debug("Snapshot marker found {} the new messages will be applied on top of the snapshot data.", record2.key());
                                this.snapshotProcessed = true;
                                break;
                            }
                            this.log.debug("Discarding message with key {} as it was sent before a newer snapshot was created.", record2.key());
                        }
                        if (!this.snapshotProcessed) continue;
                        while (it.hasNext()) {
                            record2 = (ConsumerRecord)it.next();
                            this.processRecord((ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage>)record2, bootstrapId, bootstrapStart);
                        }
                        continue;
                    }
                    records.forEach(record -> this.processRecord((ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage>)record, bootstrapId, bootstrapStart));
                }
            }
        };
        this.stopped = false;
        Thread thread = new Thread(runner);
        thread.setDaemon(true);
        thread.setName("KSQL Kafka Consumer Thread");
        thread.start();
    }

    private boolean processSnapshot(String snapshotId, ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage> record) {
        return record.value() instanceof CreateSnapshot1Message && snapshotId.equals(((CreateSnapshot1Message)record.value()).getSnapshotId());
    }

    private void processRecord(ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage> record, String bootstrapId, long bootstrapStart) {
        if (record.key() == null) {
            this.log.warn("Discarded an unreadable/unrecognized Kafka message.");
            return;
        }
        if ("Bootstrap".equals(((KafkaSqlMessageKey)record.key()).getMessageType())) {
            KafkaSqlMessageKey bkey = (KafkaSqlMessageKey)record.key();
            if (bkey.getUuid().equals(bootstrapId)) {
                this.bootstrapped = true;
                this.storageEvent.fireAsync((Object)StorageEvent.builder().type(StorageEventType.READY).build());
                this.log.info("KafkaSQL storage bootstrapped in {} ms.", (Object)(System.currentTimeMillis() - bootstrapStart));
            }
            return;
        }
        if (record.value() instanceof CreateSnapshot1Message && !((CreateSnapshot1Message)record.value()).getSnapshotId().equals(this.lastTriggeredSnapshot)) {
            this.log.debug("Snapshot trigger message with id {} being skipped since this replica did not trigger the creation.", (Object)((CreateSnapshot1Message)record.value()).getSnapshotId());
            return;
        }
        if (record.value() == null) {
            this.log.info("Discarded a (presumed) tombstone message with key: {}", record.key());
            return;
        }
        this.kafkaSqlSink.processMessage(record);
    }

    public void setConfigProperty(DynamicConfigPropertyDto propertyDto) {
        SetConfigProperty1Message message = new SetConfigProperty1Message(propertyDto);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    public void deleteConfigProperty(String propertyName) {
        DeleteConfigProperty1Message message = new DeleteConfigProperty1Message(propertyName);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public Pair<ArtifactMetaDataDto, ArtifactVersionMetaDataDto> createArtifact(String groupId, String artifactId, String artifactType, EditableArtifactMetaDataDto artifactMetaData, String version, ContentWrapperDto versionContent, EditableVersionMetaDataDto versionMetaData, List<String> versionBranches, boolean dryRun) throws RegistryStorageException {
        String content = versionContent != null ? versionContent.getContent().content() : null;
        String contentType = versionContent != null ? versionContent.getContentType() : null;
        List<ArtifactReferenceDto> references = versionContent != null ? versionContent.getReferences() : null;
        CreateArtifact9Message message = new CreateArtifact9Message(groupId, artifactId, artifactType, artifactMetaData, version, contentType, content, references, versionMetaData, versionBranches, dryRun);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        Pair createdArtifact = (Pair)this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactCreated.of((ArtifactMetaDataDto)createdArtifact.getLeft())));
        if (createdArtifact.getRight() != null) {
            this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactVersionCreated.of((ArtifactVersionMetaDataDto)createdArtifact.getRight())));
        }
        return createdArtifact;
    }

    @Override
    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        DeleteArtifact2Message message = new DeleteArtifact2Message(groupId, artifactId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        List versions = (List)this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactDeleted.of(groupId, artifactId)));
        return versions;
    }

    @Override
    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        DeleteArtifacts1Message message = new DeleteArtifacts1Message(groupId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public ArtifactVersionMetaDataDto createArtifactVersion(String groupId, String artifactId, String version, String artifactType, ContentWrapperDto contentDto, EditableVersionMetaDataDto metaData, List<String> branches, boolean dryRun) throws RegistryStorageException {
        String content = contentDto != null ? contentDto.getContent().content() : null;
        String contentType = contentDto != null ? contentDto.getContentType() : null;
        List<ArtifactReferenceDto> references = contentDto != null ? contentDto.getReferences() : null;
        CreateArtifactVersion8Message message = new CreateArtifactVersion8Message(groupId, artifactId, version, artifactType, contentType, content, references, metaData, branches, dryRun);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        ArtifactVersionMetaDataDto versionMetaDataDto = (ArtifactVersionMetaDataDto)this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactVersionCreated.of(versionMetaDataDto)));
        return versionMetaDataDto;
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        UpdateArtifactMetaData3Message message = new UpdateArtifactMetaData3Message(groupId, artifactId, metaData);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactMetadataUpdated.of(groupId, artifactId, metaData)));
    }

    @Override
    public void createArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws RegistryStorageException {
        CreateArtifactRule4Message message = new CreateArtifactRule4Message(groupId, artifactId, rule, config);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, config)));
    }

    @Override
    public void deleteArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        DeleteArtifactRules2Message message = new DeleteArtifactRules2Message(groupId, artifactId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void updateArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        UpdateArtifactRule4Message message = new UpdateArtifactRule4Message(groupId, artifactId, rule, config);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, config)));
    }

    @Override
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        DeleteArtifactRule3Message message = new DeleteArtifactRule3Message(groupId, artifactId, rule);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        switch (rule) {
            case VALIDITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, RuleConfigurationDto.builder().configuration(ValidityLevel.NONE.name()).build())));
                break;
            }
            case COMPATIBILITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, RuleConfigurationDto.builder().configuration(CompatibilityLevel.NONE.name()).build())));
                break;
            }
            case INTEGRITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, RuleConfigurationDto.builder().configuration(IntegrityLevel.NONE.name()).build())));
            }
        }
    }

    @Override
    public void createGroupRule(String groupId, RuleType rule, RuleConfigurationDto config) throws RegistryStorageException {
        CreateGroupRule3Message message = new CreateGroupRule3Message(groupId, rule, config);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, config)));
    }

    @Override
    public void updateGroupRule(String groupId, RuleType rule, RuleConfigurationDto config) throws RegistryStorageException {
        UpdateGroupRule3Message message = new UpdateGroupRule3Message(groupId, rule, config);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, config)));
    }

    @Override
    public void deleteGroupRule(String groupId, RuleType rule) throws RegistryStorageException {
        DeleteGroupRule2Message message = new DeleteGroupRule2Message(groupId, rule);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        switch (rule) {
            case VALIDITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, RuleConfigurationDto.builder().configuration(ValidityLevel.NONE.name()).build())));
                break;
            }
            case COMPATIBILITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, RuleConfigurationDto.builder().configuration(CompatibilityLevel.NONE.name()).build())));
                break;
            }
            case INTEGRITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, RuleConfigurationDto.builder().configuration(IntegrityLevel.NONE.name()).build())));
            }
        }
    }

    @Override
    public void deleteGroupRules(String groupId) throws RegistryStorageException {
        DeleteGroupRules1Message message = new DeleteGroupRules1Message(groupId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        DeleteArtifactVersion3Message message = new DeleteArtifactVersion3Message(groupId, artifactId, version);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactVersionDeleted.of(groupId, artifactId, version)));
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableVersionMetaDataDto metaData) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        UpdateArtifactVersionMetaData4Message message = new UpdateArtifactVersionMetaData4Message(groupId, artifactId, version, metaData);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(ArtifactVersionMetadataUpdated.of(groupId, artifactId, version, metaData)));
    }

    @Override
    public void createGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleAlreadyExistsException, RegistryStorageException {
        CreateGlobalRule2Message message = new CreateGlobalRule2Message(rule, config);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GlobalRuleConfigured.of(rule, config)));
    }

    @Override
    public void deleteGlobalRules() throws RegistryStorageException {
        DeleteGlobalRules0Message message = new DeleteGlobalRules0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void updateGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleNotFoundException, RegistryStorageException {
        UpdateGlobalRule2Message message = new UpdateGlobalRule2Message(rule, config);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GlobalRuleConfigured.of(rule, config)));
    }

    @Override
    public void deleteGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        DeleteGlobalRule1Message message = new DeleteGlobalRule1Message(rule);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        switch (rule) {
            case VALIDITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GlobalRuleConfigured.of(rule, RuleConfigurationDto.builder().configuration(ValidityLevel.NONE.name()).build())));
                break;
            }
            case COMPATIBILITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GlobalRuleConfigured.of(rule, RuleConfigurationDto.builder().configuration(CompatibilityLevel.NONE.name()).build())));
                break;
            }
            case INTEGRITY: {
                this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GlobalRuleConfigured.of(rule, RuleConfigurationDto.builder().configuration(IntegrityLevel.NONE.name()).build())));
            }
        }
    }

    @Override
    public void createGroup(GroupMetaDataDto group) throws GroupAlreadyExistsException, RegistryStorageException {
        CreateGroup1Message message = new CreateGroup1Message(group);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupCreated.of(group)));
    }

    @Override
    public void deleteGroup(String groupId) throws GroupNotFoundException, RegistryStorageException {
        DeleteGroup1Message message = new DeleteGroup1Message(groupId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupDeleted.of(groupId)));
    }

    @Override
    public void updateGroupMetaData(String groupId, EditableGroupMetaDataDto dto) {
        UpdateGroupMetaData2Message message = new UpdateGroupMetaData2Message(groupId, dto);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
        this.outboxEvent.fire((Object)KafkaSqlOutboxEvent.of(GroupMetadataUpdated.of(groupId, dto)));
    }

    @Override
    public void importData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) throws RegistryStorageException {
        SqlDataImporter dataImporter = new SqlDataImporter(this.log, this.utils, this, preserveGlobalId, preserveContentId);
        dataImporter.importData(entities, () -> {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public void upgradeData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) throws RegistryStorageException {
        SqlDataUpgrader dataImporter = new SqlDataUpgrader(this.log, this.utils, this, preserveGlobalId, preserveContentId);
        dataImporter.importData(entities, () -> {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public void createRoleMapping(String principalId, String role, String principalName) throws RegistryStorageException {
        CreateRoleMapping3Message message = new CreateRoleMapping3Message(principalId, role, principalName);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void updateRoleMapping(String principalId, String role) throws RegistryStorageException {
        UpdateRoleMapping2Message message = new UpdateRoleMapping2Message(principalId, role);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void deleteRoleMapping(String principalId) throws RegistryStorageException {
        DeleteRoleMapping1Message message = new DeleteRoleMapping1Message(principalId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void deleteAllUserData() {
        DeleteAllUserData0Message message = new DeleteAllUserData0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public String createDownload(DownloadContextDto context) throws RegistryStorageException {
        CreateDownload1Message message = new CreateDownload1Message(context);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        return (String)this.coordinator.waitForResponse(uuid);
    }

    @Override
    public DownloadContextDto consumeDownload(String downloadId) throws RegistryStorageException {
        ConsumeDownload1Message message = new ConsumeDownload1Message(downloadId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        return (DownloadContextDto)this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void deleteAllExpiredDownloads() throws RegistryStorageException {
        DeleteAllExpiredDownloads0Message message = new DeleteAllExpiredDownloads0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public ContentWrapperDto getContentByReference(ArtifactReferenceDto reference) {
        return this.sqlStore.getContentByReference(reference);
    }

    @Override
    public CommentDto createArtifactVersionComment(String groupId, String artifactId, String version, String value) {
        CreateArtifactVersionComment4Message message = new CreateArtifactVersionComment4Message(groupId, artifactId, version, value);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        return (CommentDto)this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void deleteArtifactVersionComment(String groupId, String artifactId, String version, String commentId) {
        DeleteArtifactVersionComment4Message message = new DeleteArtifactVersionComment4Message(groupId, artifactId, version, commentId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void updateArtifactVersionComment(String groupId, String artifactId, String version, String commentId, String value) {
        UpdateArtifactVersionComment5Message message = new UpdateArtifactVersionComment5Message(groupId, artifactId, version, commentId, value);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void resetGlobalId() {
        ResetGlobalId0Message message = new ResetGlobalId0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void resetContentId() {
        ResetContentId0Message message = new ResetContentId0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void resetCommentId() {
        ResetCommentId0Message message = new ResetCommentId0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public long nextContentId() {
        NextContentId0Message message = new NextContentId0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        return (Long)this.coordinator.waitForResponse(uuid);
    }

    @Override
    public long nextGlobalId() {
        NextGlobalId0Message message = new NextGlobalId0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        return (Long)this.coordinator.waitForResponse(uuid);
    }

    @Override
    public long nextCommentId() {
        NextCommentId0Message message = new NextCommentId0Message();
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        return (Long)this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importComment(CommentEntity entity) {
        ImportComment1Message message = new ImportComment1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importGroup(GroupEntity entity) {
        ImportGroup1Message message = new ImportGroup1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importGlobalRule(GlobalRuleEntity entity) {
        ImportGlobalRule1Message message = new ImportGlobalRule1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importContent(ContentEntity entity) {
        String content = ContentHandle.create((byte[])entity.contentBytes).content();
        ImportContent1Message message = new ImportContent1Message(entity, content);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importArtifactVersion(ArtifactVersionEntity entity) {
        ImportArtifactVersion1Message message = new ImportArtifactVersion1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importArtifact(ArtifactEntity entity) {
        ImportArtifact1Message message = new ImportArtifact1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importArtifactRule(ArtifactRuleEntity entity) {
        ImportArtifactRule1Message message = new ImportArtifactRule1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importGroupRule(GroupRuleEntity entity) {
        ImportGroupRule1Message message = new ImportGroupRule1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void importBranch(BranchEntity entity) {
        ImportBranch1Message message = new ImportBranch1Message(entity);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void updateContentCanonicalHash(String newCanonicalHash, long contentId, String contentHash) {
        UpdateContentCanonicalHash3Message message = new UpdateContentCanonicalHash3Message(newCanonicalHash, contentId, contentHash);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void appendVersionToBranch(GA ga, BranchId branchId, VersionId version) {
        AppendVersionToBranch3Message message = new AppendVersionToBranch3Message(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), branchId.getRawBranchId(), version.getRawVersionId());
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void updateBranchMetaData(GA ga, BranchId branchId, EditableBranchMetaDataDto dto) {
        UpdateBranchMetaData3Message message = new UpdateBranchMetaData3Message(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), branchId.getRawBranchId(), dto);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void replaceBranchVersions(GA ga, BranchId branchId, List<VersionId> versions) {
        ReplaceBranchVersions3Message message = new ReplaceBranchVersions3Message(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), branchId.getRawBranchId(), versions.stream().map(VersionId::getRawVersionId).toList());
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public BranchMetaDataDto createBranch(GA ga, BranchId branchId, String description, List<String> versions) {
        CreateBranch4Message message = new CreateBranch4Message(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), branchId.getRawBranchId(), description, versions);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        return (BranchMetaDataDto)this.coordinator.waitForResponse(uuid);
    }

    @Override
    public void deleteBranch(GA ga, BranchId branchId) {
        DeleteBranch2Message message = new DeleteBranch2Message(ga.getRawGroupIdWithNull(), ga.getRawArtifactId(), branchId.getRawBranchId());
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        this.coordinator.waitForResponse(uuid);
    }

    @Override
    public String triggerSnapshotCreation() throws RegistryStorageException {
        String snapshotId = UUID.randomUUID().toString();
        Path path = Path.of(this.configuration.snapshotLocation(), snapshotId + ".sql");
        CreateSnapshot1Message message = new CreateSnapshot1Message(path.toString(), snapshotId);
        this.lastTriggeredSnapshot = snapshotId;
        this.log.debug("Snapshot with id {} triggered.", (Object)snapshotId);
        UUID uuid = (UUID)ConcurrentUtil.get(this.submitter.submitMessage(message));
        String snapshotLocation = (String)this.coordinator.waitForResponse(uuid);
        ProducerRecord record = new ProducerRecord(this.configuration.snapshotsTopic(), Integer.valueOf(0), (Object)snapshotId, (Object)snapshotLocation, Collections.emptyList());
        RecordMetadata recordMetadata = (RecordMetadata)ConcurrentUtil.get((CompletableFuture)((CompletableFuture)this.snapshotsProducer.apply((Object)record)));
        return snapshotLocation;
    }

    @Override
    public String createSnapshot(String snapshotLocation) throws RegistryStorageException {
        throw new IllegalStateException("Directly creating a snapshot is not supported in Kafkasql");
    }

    @Override
    public String createEvent(OutboxEvent event) {
        return event.getId();
    }
}

