/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlConfiguration;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlCoordinator;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessage;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessageKey;
import io.apicurio.registry.utils.kafka.ProducerActions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Shutdown;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.internals.RecordHeader;

@ApplicationScoped
@Logged
public class KafkaSqlSubmitter {
    @Inject
    KafkaSqlConfiguration configuration;
    @Inject
    KafkaSqlCoordinator coordinator;
    @Inject
    @Named(value="KafkaSqlJournalProducer")
    ProducerActions<KafkaSqlMessageKey, KafkaSqlMessage> producer;

    public void handleShutdown(@Observes Shutdown shutdownEvent) throws Exception {
        this.producer.close();
    }

    public CompletableFuture<UUID> send(KafkaSqlMessageKey key, KafkaSqlMessage value) {
        UUID requestId = this.coordinator.createUUID();
        RecordHeader requestIdHeader = new RecordHeader("req", requestId.toString().getBytes(StandardCharsets.UTF_8));
        RecordHeader messageTypeHeader = new RecordHeader("mt", key.getMessageType().getBytes(StandardCharsets.UTF_8));
        ProducerRecord record = new ProducerRecord(this.configuration.topic(), Integer.valueOf(0), (Object)key, (Object)value, List.of(requestIdHeader, messageTypeHeader));
        return ((CompletableFuture)this.producer.apply((Object)record)).thenApply(rm -> requestId);
    }

    public void submitBootstrap(String bootstrapId) {
        KafkaSqlMessageKey key = KafkaSqlMessageKey.builder().messageType("Bootstrap").uuid(bootstrapId).build();
        this.send(key, null);
    }

    public CompletableFuture<UUID> submitMessage(KafkaSqlMessage message) {
        KafkaSqlMessageKey key = message.getKey();
        return this.send(key, message);
    }
}

