/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.serde;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessageKey;
import java.io.IOException;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSqlKeyDeserializer
implements Deserializer<KafkaSqlMessageKey> {
    private static final Logger log = LoggerFactory.getLogger(KafkaSqlKeyDeserializer.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public KafkaSqlMessageKey deserialize(String topic, byte[] data) {
        try {
            KafkaSqlMessageKey key = (KafkaSqlMessageKey)mapper.readValue(data, KafkaSqlMessageKey.class);
            return key;
        }
        catch (IOException e) {
            log.error("Error deserializing a Kafka+SQL message (key).", (Throwable)e);
            return null;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
    }
}

