/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.serde;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessageKey;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaSqlKeySerializer
implements Serializer<KafkaSqlMessageKey> {
    private static final ObjectMapper mapper = new ObjectMapper();

    public byte[] serialize(String topic, KafkaSqlMessageKey messageKey) {
        try {
            UnsynchronizedByteArrayOutputStream out = UnsynchronizedByteArrayOutputStream.builder().get();
            mapper.writeValue((OutputStream)out, (Object)messageKey);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

