/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.serde;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessage;
import io.apicurio.registry.storage.impl.kafkasql.serde.KafkaSqlMessageIndex;
import java.util.Optional;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSqlValueDeserializer
implements Deserializer<KafkaSqlMessage> {
    private static final Logger log = LoggerFactory.getLogger(KafkaSqlValueDeserializer.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public KafkaSqlMessage deserialize(String topic, byte[] data) {
        return null;
    }

    public KafkaSqlMessage deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            String messageType = KafkaSqlValueDeserializer.extractMessageType(headers);
            if (messageType == null) {
                log.error("Message missing required message type header: mt");
                return null;
            }
            Class<? extends KafkaSqlMessage> msgClass = KafkaSqlMessageIndex.lookup(messageType);
            if (msgClass == null) {
                throw new Exception("Unknown KafkaSql message class for '" + messageType + "'");
            }
            KafkaSqlMessage message = (KafkaSqlMessage)mapper.readValue(data, msgClass);
            return message;
        }
        catch (Exception e) {
            log.error("Error deserializing a Kafka+SQL message (value).", (Throwable)e);
            return null;
        }
    }

    private static String extractMessageType(Headers headers) {
        return Optional.ofNullable(headers.headers("mt")).map(Iterable::iterator).map(it -> it.hasNext() ? (Header)it.next() : null).map(Header::value).map(String::new).orElse(null);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
    }
}

