/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.sql;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlCoordinator;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessage;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlMessageKey;
import io.apicurio.registry.storage.impl.sql.SqlRegistryStorage;
import io.apicurio.registry.types.RegistryException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;

@ApplicationScoped
@Logged
public class KafkaSqlSink {
    @Inject
    Logger log;
    @Inject
    KafkaSqlCoordinator coordinator;
    @Inject
    SqlRegistryStorage sqlStore;

    @ActivateRequestContext
    public void processMessage(ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage> record) {
        UUID requestId = this.extractUuid(record);
        this.log.debug("Processing Kafka message with UUID: {}", (Object)requestId);
        try {
            Object result = this.doProcessMessage(record);
            this.log.trace("Processed message key: {} value: {} result: {}", new Object[]{((KafkaSqlMessageKey)record.key()).getMessageType(), record.value() != null ? ((KafkaSqlMessage)record.value()).toString() : "", result != null ? result.toString() : ""});
            this.log.debug("Kafka message successfully processed. Notifying listeners of response.");
            this.coordinator.notifyResponse(requestId, result);
        }
        catch (RegistryException e) {
            this.log.debug("Registry exception detected: {}", (Object)e.getMessage());
            this.coordinator.notifyResponse(requestId, e);
        }
        catch (Throwable e) {
            this.log.debug("Unexpected exception detected: {}", (Object)e.getMessage());
            this.coordinator.notifyResponse(requestId, new RegistryException(e));
        }
    }

    private UUID extractUuid(ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage> record) {
        return Optional.ofNullable(record.headers().headers("req")).map(Iterable::iterator).map(it -> it.hasNext() ? (Header)it.next() : null).map(Header::value).map(String::new).map(UUID::fromString).orElse(null);
    }

    private Object doProcessMessage(ConsumerRecord<KafkaSqlMessageKey, KafkaSqlMessage> record) {
        KafkaSqlMessage value = (KafkaSqlMessage)record.value();
        return value.dispatchTo(this.sqlStore);
    }
}

