/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.agroal.api.AgroalDataSource;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.impl.sql.HandleFactory;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.storage.impl.sql.jdb.HandleAction;
import io.apicurio.registry.storage.impl.sql.jdb.HandleCallback;
import io.apicurio.registry.storage.impl.sql.jdb.HandleImpl;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractHandleFactory
implements HandleFactory {
    private static final ThreadLocal<Map<String, LocalState>> local = ThreadLocal.withInitial(HashMap::new);
    private AgroalDataSource dataSource;
    private String dataSourceId;
    private Logger log;

    protected void initialize(AgroalDataSource dataSource, String dataSourceId, Logger log) {
        this.dataSource = dataSource;
        this.dataSourceId = dataSourceId;
        this.log = log;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R, X extends Exception> R withHandle(HandleCallback<R, X> callback) throws X {
        R r;
        LocalState state;
        block22: {
            block20: {
                state = this.state();
                try {
                    if (state.handle == null) {
                        state.handle = new HandleImpl(this.dataSource.getConnection());
                        state.level = 0;
                    } else {
                        ++state.level;
                    }
                    r = callback.withHandle(state.handle);
                    if (state.level <= 0) break block20;
                }
                catch (SQLException e) {
                    try {
                        state.handle.setRollback(true);
                        throw new RegistryStorageException(e);
                        catch (Exception e2) {
                            if (state.handle == null) throw e2;
                            state.handle.setRollback(true);
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        block21: {
                            if (state.level > 0) {
                                this.log.trace("Exiting nested call (level {}): {} #{}", new Object[]{this.state().level, this.state().handle.getConnection(), this.state().handle.getConnection().hashCode()});
                                --state.level;
                                throw throwable;
                            }
                            try {
                                if (state.handle == null) break block21;
                                if (state.handle.isRollback()) {
                                    this.log.trace("Rollback: {} #{}", (Object)state.handle.getConnection(), (Object)state.handle.getConnection().hashCode());
                                    state.handle.getConnection().rollback();
                                } else {
                                    this.log.trace("Commit: {} #{}", (Object)state.handle.getConnection(), (Object)state.handle.getConnection().hashCode());
                                    this.state().handle.getConnection().commit();
                                }
                            }
                            catch (Exception e3) {
                                this.log.error("Could not release database connection/transaction", (Throwable)e3);
                            }
                        }
                        try {
                            if (state.handle == null) throw throwable;
                            state.handle.close();
                            state.handle = null;
                            state.level = 0;
                            throw throwable;
                        }
                        catch (Exception ex) {
                            this.log.error("Could not close a database connection.", (Throwable)ex);
                        }
                        throw throwable;
                    }
                }
                this.log.trace("Exiting nested call (level {}): {} #{}", new Object[]{this.state().level, this.state().handle.getConnection(), this.state().handle.getConnection().hashCode()});
                --state.level;
                return r;
            }
            try {
                if (state.handle == null) break block22;
                if (state.handle.isRollback()) {
                    this.log.trace("Rollback: {} #{}", (Object)state.handle.getConnection(), (Object)state.handle.getConnection().hashCode());
                    state.handle.getConnection().rollback();
                } else {
                    this.log.trace("Commit: {} #{}", (Object)state.handle.getConnection(), (Object)state.handle.getConnection().hashCode());
                    this.state().handle.getConnection().commit();
                }
            }
            catch (Exception e) {
                this.log.error("Could not release database connection/transaction", (Throwable)e);
            }
        }
        try {
            if (state.handle == null) return r;
            state.handle.close();
            state.handle = null;
            state.level = 0;
            return r;
        }
        catch (Exception ex) {
            this.log.error("Could not close a database connection.", (Throwable)ex);
        }
        return r;
    }

    @Override
    public <R, X extends Exception> R withHandleNoException(HandleCallback<R, X> callback) {
        try {
            return this.withHandle(callback);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public <X extends Exception> void withHandleNoException(HandleAction<X> action) {
        this.withHandleNoException((Handle handle) -> {
            action.withHandle(handle);
            return null;
        });
    }

    private LocalState state() {
        return local.get().computeIfAbsent(this.dataSourceId, k -> new LocalState());
    }

    private static class LocalState {
        HandleImpl handle;
        int level = 0;

        private LocalState() {
        }
    }
}

