/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.events.ArtifactCreated;
import io.apicurio.registry.events.ArtifactDeleted;
import io.apicurio.registry.events.ArtifactMetadataUpdated;
import io.apicurio.registry.events.ArtifactRuleConfigured;
import io.apicurio.registry.events.ArtifactVersionCreated;
import io.apicurio.registry.events.ArtifactVersionDeleted;
import io.apicurio.registry.events.ArtifactVersionMetadataUpdated;
import io.apicurio.registry.events.GlobalRuleConfigured;
import io.apicurio.registry.events.GroupCreated;
import io.apicurio.registry.events.GroupDeleted;
import io.apicurio.registry.events.GroupMetadataUpdated;
import io.apicurio.registry.events.GroupRuleConfigured;
import io.apicurio.registry.exception.UnreachableCodeException;
import io.apicurio.registry.model.BranchId;
import io.apicurio.registry.model.GA;
import io.apicurio.registry.model.GAV;
import io.apicurio.registry.model.VersionId;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.semver.SemVerConfigProperties;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.StorageBehaviorProperties;
import io.apicurio.registry.storage.StorageEvent;
import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.BranchMetaDataDto;
import io.apicurio.registry.storage.dto.BranchSearchResultsDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.EditableBranchMetaDataDto;
import io.apicurio.registry.storage.dto.EditableGroupMetaDataDto;
import io.apicurio.registry.storage.dto.EditableVersionMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.OutboxEvent;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RoleMappingSearchResultsDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchedArtifactDto;
import io.apicurio.registry.storage.dto.SearchedBranchDto;
import io.apicurio.registry.storage.dto.SearchedGroupDto;
import io.apicurio.registry.storage.dto.SearchedVersionDto;
import io.apicurio.registry.storage.dto.StoredArtifactVersionDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.error.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.error.ArtifactNotFoundException;
import io.apicurio.registry.storage.error.BranchAlreadyExistsException;
import io.apicurio.registry.storage.error.BranchNotFoundException;
import io.apicurio.registry.storage.error.CommentNotFoundException;
import io.apicurio.registry.storage.error.ContentAlreadyExistsException;
import io.apicurio.registry.storage.error.ContentNotFoundException;
import io.apicurio.registry.storage.error.DownloadNotFoundException;
import io.apicurio.registry.storage.error.GroupAlreadyExistsException;
import io.apicurio.registry.storage.error.GroupNotFoundException;
import io.apicurio.registry.storage.error.NotAllowedException;
import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.error.RoleMappingAlreadyExistsException;
import io.apicurio.registry.storage.error.RoleMappingNotFoundException;
import io.apicurio.registry.storage.error.RuleAlreadyExistsException;
import io.apicurio.registry.storage.error.RuleNotFoundException;
import io.apicurio.registry.storage.error.VersionAlreadyExistsException;
import io.apicurio.registry.storage.error.VersionAlreadyExistsOnBranchException;
import io.apicurio.registry.storage.error.VersionNotFoundException;
import io.apicurio.registry.storage.impl.sql.HandleFactory;
import io.apicurio.registry.storage.impl.sql.IDbUpgrader;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.storage.impl.sql.RegistryStorageContentUtils;
import io.apicurio.registry.storage.impl.sql.SqlOutboxEvent;
import io.apicurio.registry.storage.impl.sql.SqlStatementVariableBinder;
import io.apicurio.registry.storage.impl.sql.SqlStatements;
import io.apicurio.registry.storage.impl.sql.SqlStorageEvent;
import io.apicurio.registry.storage.impl.sql.SqlStorageEventType;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.storage.impl.sql.jdb.Query;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.storage.impl.sql.jdb.Update;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactMetaDataDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactReferenceDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactRuleEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactVersionEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactVersionMetaDataDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.BranchEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.BranchMetaDataDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.CommentDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.CommentEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ContentEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ContentMapper;
import io.apicurio.registry.storage.impl.sql.mappers.DynamicConfigPropertyDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GAVMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GlobalRuleEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GroupEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GroupMetaDataDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GroupRuleEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.RoleMappingDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.RuleConfigurationDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.SearchedArtifactMapper;
import io.apicurio.registry.storage.impl.sql.mappers.SearchedBranchMapper;
import io.apicurio.registry.storage.impl.sql.mappers.SearchedGroupMapper;
import io.apicurio.registry.storage.impl.sql.mappers.SearchedVersionMapper;
import io.apicurio.registry.storage.impl.sql.mappers.StoredArtifactMapper;
import io.apicurio.registry.storage.impl.sql.mappers.StringMapper;
import io.apicurio.registry.storage.importing.v2.SqlDataUpgrader;
import io.apicurio.registry.storage.importing.v3.SqlDataImporter;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.DtoUtil;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.StringUtil;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityInputStream;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import jakarta.validation.ValidationException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.semver4j.Semver;
import org.slf4j.Logger;

public abstract class AbstractSqlRegistryStorage
implements RegistryStorage {
    private static int DB_VERSION = Integer.valueOf(IoUtil.toString(AbstractSqlRegistryStorage.class.getResourceAsStream("db-version")));
    private static final Object inmemorySequencesMutex = new Object();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String GLOBAL_ID_SEQUENCE = "globalId";
    private static final String CONTENT_ID_SEQUENCE = "contentId";
    private static final String COMMENT_ID_SEQUENCE = "commentId";
    private static final Map<String, AtomicLong> sequenceCounters;
    @Inject
    Logger log;
    @Inject
    io.apicurio.common.apps.core.System system;
    @Inject
    SqlStatements sqlStatements;
    @Inject
    SecurityIdentity securityIdentity;
    HandleFactory handles;
    @Inject
    StorageBehaviorProperties storageBehaviorProps;
    @Inject
    RegistryStorageContentUtils utils;
    @Inject
    SemVerConfigProperties semVerConfigProps;
    @ConfigProperty(name="apicurio.sql.init", defaultValue="true")
    @Info(category="storage", description="SQL init", availableSince="2.0.0.Final")
    boolean initDB;
    @Inject
    @ConfigProperty(name="apicurio.events.kafka.topic", defaultValue="registry-events")
    @Info(category="storage", description="Storage event topic")
    String eventsTopic;
    @Inject
    Event<SqlStorageEvent> sqlStorageEvent;
    @Inject
    Event<StorageEvent> storageEvent;
    @Inject
    Event<SqlOutboxEvent> outboxEvent;
    private volatile boolean isReady = false;
    private volatile Instant isAliveLastCheck = Instant.MIN;
    private volatile boolean isAliveCached = false;

    @Inject
    protected SqlStatements sqlStatements() {
        return this.sqlStatements;
    }

    protected void initialize(HandleFactory handleFactory, boolean emitStorageReadyEvent) {
        this.handles = handleFactory;
        this.log.info("SqlRegistryStorage constructed successfully.");
        this.handles.withHandleNoException(handle -> {
            if (this.initDB) {
                if (!this.isDatabaseInitializedRaw(handle)) {
                    this.log.info("Database not initialized.");
                    this.initializeDatabaseRaw(handle);
                } else {
                    this.log.info("Database was already initialized, skipping.");
                }
                if (!this.isDatabaseCurrentRaw(handle)) {
                    this.log.info("Old database version detected, upgrading.");
                    this.upgradeDatabaseRaw(handle);
                }
            } else {
                if (!this.isDatabaseInitializedRaw(handle)) {
                    this.log.error("Database not initialized.  Please use the DDL scripts to initialize the database before starting the application.");
                    throw new RuntimeException("Database not initialized.");
                }
                if (!this.isDatabaseCurrentRaw(handle)) {
                    this.log.error("Detected an old version of the database.  Please use the DDL upgrade scripts to bring your database up to date.");
                    throw new RuntimeException("Database not upgraded.");
                }
            }
            return null;
        });
        if (this.isH2()) {
            this.handles.withHandleNoException(handle -> {
                sequenceCounters.get(GLOBAL_ID_SEQUENCE).set(this.getMaxGlobalIdRaw(handle));
                sequenceCounters.get(CONTENT_ID_SEQUENCE).set(this.getMaxContentIdRaw(handle));
                sequenceCounters.get(COMMENT_ID_SEQUENCE).set(this.getMaxVersionCommentIdRaw(handle));
                return null;
            });
        }
        this.isReady = true;
        SqlStorageEvent initializeEvent = new SqlStorageEvent();
        initializeEvent.setType(SqlStorageEventType.READY);
        this.sqlStorageEvent.fire((Object)initializeEvent);
        if (emitStorageReadyEvent) {
            this.storageEvent.fireAsync((Object)StorageEvent.builder().type(StorageEventType.READY).build());
        }
    }

    private boolean isDatabaseInitializedRaw(Handle handle) {
        this.log.info("Checking to see if the DB is initialized.");
        int count = handle.createQuery(this.sqlStatements.isDatabaseInitialized()).mapTo(Integer.class).one();
        return count > 0;
    }

    private boolean isDatabaseCurrentRaw(Handle handle) {
        this.log.info("Checking to see if the DB is up-to-date.");
        this.log.info("Build's DB version is {}", (Object)DB_VERSION);
        int version = this.getDatabaseVersionRaw(handle);
        if (version < 100) {
            String message = "[Apicurio Registry 3.x] Detected legacy 2.x database.  Automatic upgrade from 2.x to 3.x is not supported.  Please see documentation for migration instructions.";
            this.log.error("--------------------------");
            this.log.error(message);
            this.log.error("--------------------------");
            throw new RuntimeException(message);
        }
        return version == DB_VERSION;
    }

    private void initializeDatabaseRaw(Handle handle) {
        this.log.info("Initializing the Apicurio Registry database.");
        this.log.info("\tDatabase type: " + this.sqlStatements.dbType());
        List<String> statements = this.sqlStatements.databaseInitialization();
        this.log.debug("---");
        statements.forEach(statement -> {
            this.log.debug(statement);
            handle.createUpdate((String)statement).execute();
        });
        this.log.debug("---");
    }

    private void upgradeDatabaseRaw(Handle handle) {
        this.log.info("Upgrading the Apicurio Hub API database.");
        int fromVersion = this.getDatabaseVersionRaw(handle);
        int toVersion = DB_VERSION;
        this.log.info("\tDatabase type: {}", (Object)this.sqlStatements.dbType());
        this.log.info("\tFrom Version:  {}", (Object)fromVersion);
        this.log.info("\tTo Version:    {}", (Object)toVersion);
        List<String> statements = this.sqlStatements.databaseUpgrade(fromVersion, toVersion);
        this.log.debug("---");
        statements.forEach(statement -> {
            this.log.debug(statement);
            if (statement.startsWith("UPGRADER:")) {
                String cname = statement.substring(9).trim();
                this.applyUpgraderRaw(handle, cname);
            } else {
                handle.createUpdate((String)statement).execute();
            }
        });
        this.log.debug("---");
    }

    private void applyUpgraderRaw(Handle handle, String cname) {
        try {
            Class<?> upgraderClass = Class.forName(cname);
            IDbUpgrader upgrader = (IDbUpgrader)upgraderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            upgrader.upgrade(handle);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getDatabaseVersionRaw(Handle handle) {
        try {
            int version = ((Query)handle.createQuery(this.sqlStatements.getDatabaseVersion()).bind(0, "db_version")).mapTo(Integer.class).one();
            return version;
        }
        catch (Exception e) {
            this.log.error("Error getting DB version.", (Throwable)e);
            return 0;
        }
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public boolean isAlive() {
        if (!this.isReady) {
            return false;
        }
        if (Instant.now().isAfter(this.isAliveLastCheck.plus(Duration.ofSeconds(2L)))) {
            this.isAliveLastCheck = Instant.now();
            try {
                this.getGlobalRules();
                this.isAliveCached = true;
            }
            catch (Exception ex) {
                this.isAliveCached = false;
            }
        }
        return this.isAliveCached;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String storageName() {
        return "sql";
    }

    @Override
    public ContentWrapperDto getContentById(long contentId) throws ContentNotFoundException, RegistryStorageException {
        return this.handles.withHandleNoException(handle -> this.getContentByIdRaw(handle, contentId));
    }

    public ContentWrapperDto getContentByIdRaw(Handle handle, long contentId) throws ContentNotFoundException, RegistryStorageException {
        Optional<ContentWrapperDto> res = ((Query)handle.createQuery(this.sqlStatements().selectContentById()).bind(0, contentId)).map(ContentMapper.instance).findFirst();
        return res.orElseThrow(() -> new ContentNotFoundException(contentId));
    }

    @Override
    public ContentWrapperDto getContentByHash(String contentHash) throws ContentNotFoundException, RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            Optional<ContentWrapperDto> res = ((Query)handle.createQuery(this.sqlStatements().selectContentByContentHash()).bind(0, contentHash)).map(ContentMapper.instance).findFirst();
            return res.orElseThrow(() -> new ContentNotFoundException(contentHash));
        });
    }

    @Override
    public List<ArtifactVersionMetaDataDto> getArtifactVersionsByContentId(long contentId) {
        return this.handles.withHandleNoException(handle -> {
            List<ArtifactVersionMetaDataDto> dtos = ((Query)handle.createQuery(this.sqlStatements().selectArtifactVersionMetaDataByContentId()).bind(0, contentId)).map(ArtifactVersionMetaDataDtoMapper.instance).list();
            if (dtos.isEmpty()) {
                throw new ContentNotFoundException(contentId);
            }
            return dtos;
        });
    }

    @Override
    public List<Long> getEnabledArtifactContentIds(String groupId, String artifactId) {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectArtifactContentIds();
            return ((Query)((Query)handle.createQuery(sql).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).mapTo(Long.class).list();
        });
    }

    @Override
    public Pair<ArtifactMetaDataDto, ArtifactVersionMetaDataDto> createArtifact(String groupId, String artifactId, String artifactType, EditableArtifactMetaDataDto artifactMetaData, String version, ContentWrapperDto versionContent, EditableVersionMetaDataDto versionMetaData, List<String> versionBranches, boolean dryRun) throws RegistryStorageException {
        EditableArtifactMetaDataDto amd;
        this.log.debug("Inserting an artifact row for: {} {}", (Object)groupId, (Object)artifactId);
        String owner = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        EditableArtifactMetaDataDto editableArtifactMetaDataDto = amd = artifactMetaData == null ? EditableArtifactMetaDataDto.builder().build() : artifactMetaData;
        if (groupId != null && !this.isGroupExists(groupId)) {
            this.ensureGroup(GroupMetaDataDto.builder().groupId(groupId).createdOn(createdOn.getTime()).modifiedOn(createdOn.getTime()).owner(owner).modifiedBy(owner).build());
        }
        long cid = -1L;
        if (versionContent != null) {
            cid = this.ensureContentAndGetId(artifactType, versionContent);
        }
        long contentId = cid;
        try {
            return (Pair)this.handles.withHandle(handle -> {
                ImmutablePair pair;
                if (dryRun) {
                    handle.setRollback(true);
                }
                Map<String, String> labels = amd.getLabels();
                String labelsStr = RegistryContentUtils.serializeLabels(labels);
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertArtifact()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, artifactType)).bind(3, owner)).bind(4, createdOn)).bind(5, owner)).bind(6, createdOn)).bind(7, StringUtil.limitStr(amd.getName(), 512))).bind(8, StringUtil.limitStr(amd.getDescription(), 1024, true))).bind(9, labelsStr)).execute();
                if (labels != null && !labels.isEmpty()) {
                    labels.forEach((k, v) -> ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertArtifactLabel()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, StringUtil.limitStr(k.toLowerCase(), 256))).bind(3, StringUtil.limitStr(v.toLowerCase(), 512))).execute());
                }
                ArtifactMetaDataDto amdDto = ArtifactMetaDataDto.builder().groupId(groupId).artifactId(artifactId).name(amd.getName()).description(amd.getDescription()).createdOn(createdOn.getTime()).owner(owner).modifiedOn(createdOn.getTime()).modifiedBy(owner).artifactType(artifactType).labels(labels).build();
                if (versionContent != null) {
                    ArtifactVersionMetaDataDto vmdDto = this.createArtifactVersionRaw(handle, true, groupId, artifactId, version, versionMetaData, owner, createdOn, contentId, versionBranches);
                    pair = ImmutablePair.of((Object)amdDto, (Object)vmdDto);
                } else {
                    pair = ImmutablePair.of((Object)amdDto, null);
                }
                this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactCreated.of(amdDto)));
                return pair;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new ArtifactAlreadyExistsException(groupId, artifactId);
            }
            throw ex;
        }
    }

    private ArtifactVersionMetaDataDto createArtifactVersionRaw(Handle handle, boolean firstVersion, String groupId, String artifactId, String version, EditableVersionMetaDataDto metaData, String owner, Date createdOn, Long contentId, List<String> branches) {
        GAV gav;
        if (metaData == null) {
            metaData = EditableVersionMetaDataDto.builder().build();
        }
        ArtifactState state = ArtifactState.ENABLED;
        String labelsStr = RegistryContentUtils.serializeLabels(metaData.getLabels());
        Long globalId = this.nextGlobalIdRaw(handle);
        if (firstVersion) {
            if (version == null) {
                version = "1";
            }
            String finalVersion1 = version;
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertVersion(true)).bind(0, globalId)).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, finalVersion1)).bind(4, state)).bind(5, StringUtil.limitStr(metaData.getName(), 512))).bind(6, StringUtil.limitStr(metaData.getDescription(), 1024, true))).bind(7, owner)).bind(8, createdOn)).bind(9, owner)).bind(10, createdOn)).bind(11, labelsStr)).bind(12, contentId)).execute();
            gav = new GAV(groupId, artifactId, finalVersion1);
        } else {
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertVersion(false)).bind(0, globalId)).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).bind(4, RegistryContentUtils.normalizeGroupId(groupId))).bind(5, artifactId)).bind(6, state)).bind(7, StringUtil.limitStr(metaData.getName(), 512))).bind(8, StringUtil.limitStr(metaData.getDescription(), 1024, true))).bind(9, owner)).bind(10, createdOn)).bind(11, owner)).bind(12, createdOn)).bind(13, labelsStr)).bind(14, contentId)).execute();
            if (version == null) {
                ((Update)handle.createUpdate(this.sqlStatements.autoUpdateVersionForGlobalId()).bind(0, globalId)).execute();
            }
            gav = this.getGAVByGlobalIdRaw(handle, globalId);
        }
        if (metaData.getLabels() != null && !metaData.getLabels().isEmpty()) {
            metaData.getLabels().forEach((k, v) -> ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertVersionLabel()).bind(0, globalId)).bind(1, StringUtil.limitStr(k.toLowerCase(), 256))).bind(2, StringUtil.limitStr(v.toLowerCase(), 512))).execute());
        }
        this.createOrUpdateBranchRaw(handle, gav, BranchId.LATEST, true);
        this.createOrUpdateSemverBranchesRaw(handle, gav);
        if (branches != null && !branches.isEmpty()) {
            branches.forEach(branch -> {
                BranchId branchId = new BranchId((String)branch);
                this.createOrUpdateBranchRaw(handle, gav, branchId, false);
            });
        }
        ArtifactVersionMetaDataDto avmd = ((Query)handle.createQuery(this.sqlStatements.selectArtifactVersionMetaDataByGlobalId()).bind(0, globalId)).map(ArtifactVersionMetaDataDtoMapper.instance).one();
        this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactVersionCreated.of(avmd)));
        return avmd;
    }

    private void createOrUpdateSemverBranchesRaw(Handle handle, GAV gav) {
        Semver semver;
        boolean validationEnabled = this.semVerConfigProps.validationEnabled.get();
        boolean branchingEnabled = this.semVerConfigProps.branchingEnabled.get();
        boolean coerceInvalidVersions = this.semVerConfigProps.coerceInvalidVersions.get();
        if (validationEnabled && (semver = Semver.parse((String)gav.getRawVersionId())) == null) {
            throw new ValidationException("Version '" + gav.getRawVersionId() + "' does not conform to Semantic Versioning 2 format.");
        }
        if (!branchingEnabled) {
            return;
        }
        semver = null;
        if (coerceInvalidVersions) {
            semver = Semver.coerce((String)gav.getRawVersionId());
            if (semver == null) {
                throw new ValidationException("Version '" + gav.getRawVersionId() + "' cannot be coerced to Semantic Versioning 2 format.");
            }
        } else {
            semver = Semver.parse((String)gav.getRawVersionId());
            if (semver == null) {
                throw new ValidationException("Version '" + gav.getRawVersionId() + "' does not conform to Semantic Versioning 2 format.");
            }
        }
        if (semver == null) {
            throw new UnreachableCodeException("Unexpectedly reached unreachable code!");
        }
        this.createOrUpdateBranchRaw(handle, gav, new BranchId(semver.getMajor() + ".x"), true);
        this.createOrUpdateBranchRaw(handle, gav, new BranchId(semver.getMajor() + "." + semver.getMinor() + ".x"), true);
    }

    private Long ensureContentAndGetId(String artifactType, ContentWrapperDto contentDto) {
        String serializedReferences;
        String canonicalContentHash;
        String contentHash;
        List<ArtifactReferenceDto> references = contentDto.getReferences();
        TypedContent content = TypedContent.create((ContentHandle)contentDto.getContent(), (String)contentDto.getContentType());
        if (RegistryStorageContentUtils.notEmpty(references)) {
            Function<List<ArtifactReferenceDto>, Map<String, TypedContent>> referenceResolver = refs -> this.handles.withHandle(handle -> this.resolveReferencesRaw(handle, (List<ArtifactReferenceDto>)refs));
            contentHash = this.utils.getContentHash(content, references);
            canonicalContentHash = this.utils.getCanonicalContentHash(content, artifactType, references, referenceResolver);
            serializedReferences = RegistryContentUtils.serializeReferences(references);
        } else {
            contentHash = this.utils.getContentHash(content, null);
            canonicalContentHash = this.utils.getCanonicalContentHash(content, artifactType, null, null);
            serializedReferences = null;
        }
        this.ensureContent(content, contentHash, canonicalContentHash, references, serializedReferences);
        Optional<Long> contentId = this.contentIdFromHash(contentHash);
        return contentId.orElseThrow(() -> new RegistryStorageException("Failed to ensure content."));
    }

    private void ensureContent(TypedContent content, String contentHash, String canonicalContentHash, List<ArtifactReferenceDto> references, String referencesSerialized) {
        this.handles.withHandleNoException(handle -> {
            byte[] contentBytes = content.getContent().bytes();
            String sql = this.sqlStatements.insertContent();
            long contentId = this.nextContentIdRaw(handle);
            try {
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, contentId)).bind(1, canonicalContentHash)).bind(2, contentHash)).bind(3, content.getContentType())).bind(4, contentBytes)).bind(5, referencesSerialized)).execute();
            }
            catch (Exception e) {
                if (this.sqlStatements.isPrimaryKeyViolation(e)) {
                    return;
                }
                throw e;
            }
            this.insertReferencesRaw(handle, contentId, references);
        });
    }

    private void insertReferencesRaw(Handle handle, Long contentId, List<ArtifactReferenceDto> references) {
        if (references != null && !references.isEmpty()) {
            references.forEach(reference -> {
                block2: {
                    try {
                        ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertContentReference()).bind(0, contentId)).bind(1, RegistryContentUtils.normalizeGroupId(reference.getGroupId()))).bind(2, reference.getArtifactId())).bind(3, reference.getVersion())).bind(4, reference.getName())).execute();
                    }
                    catch (Exception e) {
                        if (this.sqlStatements.isPrimaryKeyViolation(e)) break block2;
                        throw e;
                    }
                }
            });
        }
    }

    @Override
    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Deleting an artifact: {} {}", (Object)groupId, (Object)artifactId);
        return this.handles.withHandle(handle -> {
            List<String> versions = ((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactVersions()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).mapTo(String.class).list();
            ((Update)((Update)handle.createUpdate(this.sqlStatements.deleteArtifactRules()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).execute();
            int rowCount = ((Update)((Update)handle.createUpdate(this.sqlStatements.deleteArtifact()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).execute();
            if (rowCount == 0) {
                throw new ArtifactNotFoundException(groupId, artifactId);
            }
            this.deleteAllOrphanedContentRaw(handle);
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactDeleted.of(groupId, artifactId)));
            return versions;
        });
    }

    @Override
    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        this.log.debug("Deleting all artifacts in group: {}", (Object)groupId);
        this.handles.withHandle(handle -> {
            ((Update)handle.createUpdate(this.sqlStatements.deleteArtifactRulesByGroupId()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).execute();
            int rowCount = ((Update)handle.createUpdate(this.sqlStatements.deleteArtifactsByGroupId()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).execute();
            if (rowCount == 0) {
                throw new ArtifactNotFoundException(groupId, null);
            }
            this.deleteAllOrphanedContentRaw(handle);
            return null;
        });
    }

    @Override
    public ArtifactVersionMetaDataDto createArtifactVersion(String groupId, String artifactId, String version, String artifactType, ContentWrapperDto content, EditableVersionMetaDataDto metaData, List<String> branches, boolean dryRun) throws VersionAlreadyExistsException, RegistryStorageException {
        this.log.debug("Creating new artifact version for {} {} (version {}).", new Object[]{groupId, artifactId, version});
        String owner = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        long contentId = this.ensureContentAndGetId(artifactType, content);
        try {
            return this.handles.withHandle(handle -> {
                if (dryRun) {
                    handle.setRollback(true);
                }
                boolean isFirstVersion = this.countArtifactVersionsRaw(handle, groupId, artifactId) == 0L;
                ArtifactVersionMetaDataDto versionDto = this.createArtifactVersionRaw(handle, isFirstVersion, groupId, artifactId, version, metaData == null ? EditableVersionMetaDataDto.builder().build() : metaData, owner, createdOn, contentId, branches);
                return versionDto;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new VersionAlreadyExistsException(groupId, artifactId, version);
            }
            throw ex;
        }
    }

    @Override
    public long countActiveArtifactVersions(String groupId, String artifactId) throws RegistryStorageException {
        this.log.debug("Searching for versions of artifact {} {}", (Object)groupId, (Object)artifactId);
        return this.handles.withHandleNoException(handle -> {
            Integer count = ((Query)((Query)handle.createQuery(this.sqlStatements.selectActiveArtifactVersionsCount()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).mapTo(Integer.class).one();
            return count.longValue();
        });
    }

    @Override
    public Set<String> getArtifactIds(Integer limit) {
        Integer adjustedLimit = limit == null ? Integer.MAX_VALUE : limit;
        this.log.debug("Getting the set of all artifact IDs");
        return this.handles.withHandleNoException(handle -> {
            Query query = handle.createQuery(this.sqlStatements.selectArtifactIds());
            query.bind(0, adjustedLimit);
            return new HashSet<String>(query.mapTo(String.class).list());
        });
    }

    @Override
    public ArtifactSearchResultsDto searchArtifacts(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) {
        return this.handles.withHandleNoException(handle -> {
            LinkedList<SqlStatementVariableBinder> binders = new LinkedList<SqlStatementVariableBinder>();
            StringBuilder selectTemplate = new StringBuilder();
            StringBuilder where = new StringBuilder();
            StringBuilder orderByQuery = new StringBuilder();
            StringBuilder limitOffset = new StringBuilder();
            selectTemplate.append("SELECT {{selectColumns}} FROM artifacts a ");
            boolean first = true;
            for (SearchFilter filter : filters) {
                if (first) {
                    where.append(" WHERE (");
                    first = false;
                } else {
                    where.append(" AND (");
                }
                switch (filter.getType()) {
                    case description: {
                        String op = filter.isNot() ? "NOT LIKE" : "LIKE";
                        where.append("a.description ");
                        where.append(op);
                        where.append(" ?");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case name: {
                        String op = filter.isNot() ? "NOT LIKE" : "LIKE";
                        where.append("a.name " + op + " ? OR a.artifactId " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case groupId: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("a.groupId " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, RegistryContentUtils.normalizeGroupId(filter.getStringValue())));
                        break;
                    }
                    case contentHash: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("EXISTS(SELECT c.* FROM content c JOIN versions v ON c.contentId = v.contentId WHERE v.groupId = a.groupId AND v.artifactId = a.artifactId AND ");
                        where.append("c.contentHash " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        where.append(")");
                        break;
                    }
                    case canonicalHash: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("EXISTS(SELECT c.* FROM content c JOIN versions v ON c.contentId = v.contentId WHERE v.groupId = a.groupId AND v.artifactId = a.artifactId AND ");
                        where.append("c.canonicalHash " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        where.append(")");
                        break;
                    }
                    case labels: {
                        String op = filter.isNot() ? "!=" : "=";
                        Pair<String, String> label = filter.getLabelFilterValue();
                        String labelKey = ((String)label.getKey()).toLowerCase();
                        where.append("EXISTS(SELECT l.* FROM artifact_labels l WHERE l.labelKey " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, labelKey));
                        if (label.getValue() != null) {
                            String labelValue = ((String)label.getValue()).toLowerCase();
                            where.append(" AND l.labelValue " + op + " ?");
                            binders.add((query, idx) -> query.bind(idx, labelValue));
                        }
                        where.append(" AND l.groupId = a.groupId AND l.artifactId = a.artifactId)");
                        break;
                    }
                    case globalId: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("EXISTS(SELECT v.* FROM versions v WHERE v.groupId = a.groupId AND v.artifactId = a.artifactId AND ");
                        where.append("v.globalId " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getNumberValue().longValue()));
                        where.append(")");
                        break;
                    }
                    case contentId: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("EXISTS(SELECT c.* FROM content c JOIN versions v ON c.contentId = v.contentId WHERE v.groupId = a.groupId AND v.artifactId = a.artifactId AND ");
                        where.append("v.contentId " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getNumberValue().longValue()));
                        where.append(")");
                        break;
                    }
                    case state: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("EXISTS(SELECT v.* FROM versions v WHERE v.groupId = a.groupId AND v.artifactId = a.artifactId AND ");
                        where.append("v.state " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        where.append(")");
                    }
                }
                where.append(")");
            }
            switch (orderBy) {
                case name: {
                    orderByQuery.append(" ORDER BY coalesce(a.name, a.artifactId)");
                    break;
                }
                case artifactId: {
                    orderByQuery.append(" ORDER BY a.artifactId");
                    break;
                }
                case createdOn: {
                    orderByQuery.append(" ORDER BY a.createdOn");
                    break;
                }
                case modifiedOn: {
                    orderByQuery.append(" ORDER BY a.modifiedOn");
                    break;
                }
                case artifactType: {
                    orderByQuery.append(" ORDER BY a.type");
                    break;
                }
                default: {
                    throw new RuntimeException("Sort by " + orderBy.name() + " not supported.");
                }
            }
            orderByQuery.append(" ").append(orderDirection.name());
            if ("mssql".equals(this.sqlStatements.dbType())) {
                limitOffset.append(" OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
            } else {
                limitOffset.append(" LIMIT ? OFFSET ?");
            }
            String artifactsQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).append((CharSequence)orderByQuery).append((CharSequence)limitOffset).toString().replace("{{selectColumns}}", "a.*");
            Query artifactsQuery = handle.createQuery(artifactsQuerySql);
            String countQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).toString().replace("{{selectColumns}}", "count(a.artifactId)");
            Query countQuery = handle.createQuery(countQuerySql);
            int idx2 = 0;
            for (SqlStatementVariableBinder binder : binders) {
                binder.bind(artifactsQuery, idx2);
                binder.bind(countQuery, idx2);
                ++idx2;
            }
            if ("mssql".equals(this.sqlStatements.dbType())) {
                artifactsQuery.bind(idx2++, offset);
                artifactsQuery.bind(idx2++, limit);
            } else {
                artifactsQuery.bind(idx2++, limit);
                artifactsQuery.bind(idx2++, offset);
            }
            List<SearchedArtifactDto> artifacts = artifactsQuery.map(SearchedArtifactMapper.instance).list();
            Integer count = countQuery.mapTo(Integer.class).one();
            ArtifactSearchResultsDto results = new ArtifactSearchResultsDto();
            results.setArtifacts(artifacts);
            results.setCount(count.intValue());
            return results;
        });
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Selecting artifact meta-data: {} {}", (Object)groupId, (Object)artifactId);
        return this.handles.withHandle(handle -> this.getArtifactMetaDataRaw(handle, groupId, artifactId));
    }

    private ArtifactMetaDataDto getArtifactMetaDataRaw(Handle handle, String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        Optional<ArtifactMetaDataDto> res = ((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactMetaData()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).map(ArtifactMetaDataDtoMapper.instance).findOne();
        return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
    }

    private String getContentHashRaw(Handle handle, String groupId, String artifactId, boolean canonical, TypedContent content, List<ArtifactReferenceDto> references) {
        if (canonical) {
            ArtifactMetaDataDto artifactMetaData = this.getArtifactMetaDataRaw(handle, groupId, artifactId);
            Function<List<ArtifactReferenceDto>, Map<String, TypedContent>> referenceResolver = refs -> this.resolveReferencesRaw(handle, (List<ArtifactReferenceDto>)refs);
            return this.utils.getCanonicalContentHash(content, artifactMetaData.getArtifactType(), references, referenceResolver);
        }
        return this.utils.getContentHash(content, references);
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaDataByContent(String groupId, String artifactId, boolean canonical, TypedContent content, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, RegistryStorageException {
        return this.handles.withHandle(handle -> {
            String hash = this.getContentHashRaw(handle, groupId, artifactId, canonical, content, references);
            String sql = canonical ? this.sqlStatements.selectArtifactVersionMetaDataByCanonicalHash() : this.sqlStatements.selectArtifactVersionMetaDataByContentHash();
            Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)handle.createQuery(sql).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, hash)).map(ArtifactVersionMetaDataDtoMapper.instance).findFirst();
            return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
        });
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Updating meta-data for an artifact: {} {}", (Object)groupId, (Object)artifactId);
        this.handles.withHandle(handle -> {
            int rowCount;
            boolean modified = false;
            if (metaData.getName() != null) {
                rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactName()).bind(0, StringUtil.limitStr(metaData.getName(), 512))).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                modified = true;
                if (rowCount == 0) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
            }
            if (metaData.getDescription() != null) {
                rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactDescription()).bind(0, StringUtil.limitStr(metaData.getDescription(), 1024))).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                modified = true;
                if (rowCount == 0) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
            }
            if (metaData.getOwner() != null && !metaData.getOwner().trim().isEmpty()) {
                rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactOwner()).bind(0, metaData.getOwner())).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                modified = true;
                if (rowCount == 0) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
            }
            if (metaData.getLabels() != null) {
                rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactLabels()).bind(0, RegistryContentUtils.serializeLabels(metaData.getLabels()))).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                modified = true;
                if (rowCount == 0) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                ((Update)((Update)handle.createUpdate(this.sqlStatements.deleteArtifactLabels()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).execute();
                Map<String, String> labels = metaData.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    labels.forEach((k, v) -> {
                        String sqli = this.sqlStatements.insertArtifactLabel();
                        ((Update)((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, StringUtil.limitStr(k.toLowerCase(), 256))).bind(3, StringUtil.limitStr(StringUtil.asLowerCase(v), 512))).execute();
                    });
                }
            }
            if (modified) {
                String modifiedBy = this.securityIdentity.getPrincipal().getName();
                Date modifiedOn = new Date();
                int rowCount2 = ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactModifiedByOn()).bind(0, modifiedBy)).bind(1, modifiedOn)).bind(2, RegistryContentUtils.normalizeGroupId(groupId))).bind(3, artifactId)).execute();
                modified = true;
                if (rowCount2 == 0) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactMetadataUpdated.of(groupId, artifactId, metaData)));
            }
            return null;
        });
    }

    @Override
    public List<RuleType> getArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Getting a list of all artifact rules for: {} {}", (Object)groupId, (Object)artifactId);
        return this.handles.withHandle(handle -> {
            List<RuleType> rules = ((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactRules()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).map(new RowMapper<RuleType>(){

                @Override
                public RuleType map(ResultSet rs) throws SQLException {
                    return RuleType.fromValue(rs.getString("type"));
                }
            }).list();
            if (rules.isEmpty() && !this.isArtifactExistsRaw(handle, groupId, artifactId)) {
                throw new ArtifactNotFoundException(groupId, artifactId);
            }
            return rules;
        });
    }

    @Override
    public List<RuleType> getGroupRules(String groupId) throws RegistryStorageException {
        this.log.debug("Getting a list of all group rules for: {}", (Object)groupId);
        return this.handles.withHandle(handle -> {
            List<RuleType> rules = ((Query)handle.createQuery(this.sqlStatements.selectGroupRules()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).map(new RowMapper<RuleType>(){

                @Override
                public RuleType map(ResultSet rs) throws SQLException {
                    return RuleType.fromValue(rs.getString("type"));
                }
            }).list();
            if (rules.isEmpty() && !this.isGroupExistsRaw(handle, groupId)) {
                throw new GroupNotFoundException(groupId);
            }
            return rules;
        });
    }

    @Override
    public void createArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException {
        this.log.debug("Inserting an artifact rule row for artifact: {} {} rule: {}", new Object[]{groupId, artifactId, rule.name()});
        try {
            this.handles.withHandle(handle -> {
                ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertArtifactRule()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, rule.name())).bind(3, config.getConfiguration())).execute();
                this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, config)));
                return null;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new RuleAlreadyExistsException(rule);
            }
            if (this.sqlStatements.isForeignKeyViolation(ex)) {
                throw new ArtifactNotFoundException(groupId, artifactId, ex);
            }
            throw ex;
        }
        this.log.debug("Artifact rule row successfully inserted.");
    }

    @Override
    public void createGroupRule(String groupId, RuleType rule, RuleConfigurationDto config) throws RegistryStorageException {
        this.log.debug("Inserting a group rule row for group: {} rule: {}", (Object)groupId, (Object)rule.name());
        try {
            this.handles.withHandle(handle -> {
                ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertGroupRule()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, rule.name())).bind(2, config.getConfiguration())).execute();
                this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, config)));
                return null;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new RuleAlreadyExistsException(rule);
            }
            if (this.sqlStatements.isForeignKeyViolation(ex)) {
                throw new GroupNotFoundException(groupId, ex);
            }
            throw ex;
        }
        this.log.debug("Group rule row successfully inserted.");
    }

    @Override
    public void deleteArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Deleting all artifact rules for artifact: {} {}", (Object)groupId, (Object)artifactId);
        this.handles.withHandle(handle -> {
            int count = ((Update)((Update)handle.createUpdate(this.sqlStatements.deleteArtifactRules()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).execute();
            if (count == 0 && !this.isArtifactExistsRaw(handle, groupId, artifactId)) {
                throw new ArtifactNotFoundException(groupId, artifactId);
            }
            return null;
        });
    }

    @Override
    public void deleteGroupRules(String groupId) throws RegistryStorageException {
        this.log.debug("Deleting all group rules for group: {}", (Object)groupId);
        this.handles.withHandle(handle -> {
            int count = ((Update)handle.createUpdate(this.sqlStatements.deleteGroupRules()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).execute();
            if (count == 0 && !this.isGroupExistsRaw(handle, groupId)) {
                throw new GroupNotFoundException(groupId);
            }
            return null;
        });
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single artifact rule for artifact: {} {} and rule: {}", new Object[]{groupId, artifactId, rule.name()});
        return this.handles.withHandle(handle -> {
            Optional<RuleConfigurationDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactRuleByType()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, rule.name())).map(RuleConfigurationDtoMapper.instance).findOne();
            return res.orElseThrow(() -> {
                if (!this.isArtifactExistsRaw(handle, groupId, artifactId)) {
                    return new ArtifactNotFoundException(groupId, artifactId);
                }
                return new RuleNotFoundException(rule);
            });
        });
    }

    @Override
    public RuleConfigurationDto getGroupRule(String groupId, RuleType rule) throws RegistryStorageException {
        this.log.debug("Selecting a single group rule for group: {} and rule: {}", (Object)groupId, (Object)rule.name());
        return this.handles.withHandle(handle -> {
            Optional<RuleConfigurationDto> res = ((Query)((Query)handle.createQuery(this.sqlStatements.selectGroupRuleByType()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, rule.name())).map(RuleConfigurationDtoMapper.instance).findOne();
            return res.orElseThrow(() -> {
                if (!this.isGroupExistsRaw(handle, groupId)) {
                    return new GroupNotFoundException(groupId);
                }
                return new RuleNotFoundException(rule);
            });
        });
    }

    @Override
    public void updateArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.log.debug("Updating an artifact rule for artifact: {} {} and rule: {}::{}", new Object[]{groupId, artifactId, rule.name(), config.getConfiguration()});
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactRule()).bind(0, config.getConfiguration())).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, rule.name())).execute();
            if (rowCount == 0) {
                if (!this.isArtifactExistsRaw(handle, groupId, artifactId)) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                throw new RuleNotFoundException(rule);
            }
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, config)));
            return null;
        });
    }

    @Override
    public void updateGroupRule(String groupId, RuleType rule, RuleConfigurationDto config) throws RegistryStorageException {
        this.log.debug("Updating a group rule for group: {} and rule: {}::{}", new Object[]{groupId, rule.name(), config.getConfiguration()});
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateGroupRule()).bind(0, config.getConfiguration())).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, rule.name())).execute();
            if (rowCount == 0) {
                if (!this.isGroupExistsRaw(handle, groupId)) {
                    throw new GroupNotFoundException(groupId);
                }
                throw new RuleNotFoundException(rule);
            }
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, config)));
            return null;
        });
    }

    @Override
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.log.debug("Deleting an artifact rule for artifact: {} {} and rule: {}", new Object[]{groupId, artifactId, rule.name()});
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.deleteArtifactRule()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, rule.name())).execute();
            if (rowCount == 0) {
                if (!this.isArtifactExistsRaw(handle, groupId, artifactId)) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                throw new RuleNotFoundException(rule);
            }
            switch (rule) {
                case VALIDITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, RuleConfigurationDto.builder().configuration(ValidityLevel.NONE.name()).build())));
                    break;
                }
                case COMPATIBILITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, RuleConfigurationDto.builder().configuration(CompatibilityLevel.NONE.name()).build())));
                    break;
                }
                case INTEGRITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactRuleConfigured.of(groupId, artifactId, rule, RuleConfigurationDto.builder().configuration(IntegrityLevel.NONE.name()).build())));
                }
            }
            return null;
        });
    }

    @Override
    public void deleteGroupRule(String groupId, RuleType rule) throws RegistryStorageException {
        this.log.debug("Deleting an group rule for group: {} and rule: {}", (Object)groupId, (Object)rule.name());
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)((Update)handle.createUpdate(this.sqlStatements.deleteGroupRule()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, rule.name())).execute();
            if (rowCount == 0) {
                if (!this.isGroupExistsRaw(handle, groupId)) {
                    throw new GroupNotFoundException(groupId);
                }
                throw new RuleNotFoundException(rule);
            }
            switch (rule) {
                case VALIDITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, RuleConfigurationDto.builder().configuration(ValidityLevel.NONE.name()).build())));
                    break;
                }
                case COMPATIBILITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, RuleConfigurationDto.builder().configuration(CompatibilityLevel.NONE.name()).build())));
                    break;
                }
                case INTEGRITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupRuleConfigured.of(groupId, rule, RuleConfigurationDto.builder().configuration(IntegrityLevel.NONE.name()).build())));
                }
            }
            return null;
        });
    }

    @Override
    public List<String> getArtifactVersions(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.getArtifactVersions(groupId, artifactId, this.storageBehaviorProps.getDefaultArtifactRetrievalBehavior());
    }

    @Override
    public List<String> getArtifactVersions(String groupId, String artifactId, RegistryStorage.RetrievalBehavior behavior) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Getting a list of versions for artifact: {} {}", (Object)groupId, (Object)artifactId);
        try {
            List versions = this.handles.withHandle(handle -> {
                switch (behavior) {
                    case DEFAULT: {
                        return this.getArtifactVersionsRaw(handle, groupId, artifactId, this.sqlStatements.selectArtifactVersions());
                    }
                    case SKIP_DISABLED_LATEST: {
                        return this.getArtifactVersionsRaw(handle, groupId, artifactId, this.sqlStatements.selectArtifactVersionsNotDisabled());
                    }
                }
                return null;
            });
            if (versions != null) {
                return versions;
            }
        }
        catch (BranchNotFoundException ex) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        throw new UnsupportedOperationException("Retrieval behavior not implemented: " + behavior.name());
    }

    private List<String> getArtifactVersionsRaw(Handle handle, String groupId, String artifactId, String sqlStatement) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Getting a list of versions for artifact: {} {}", (Object)groupId, (Object)artifactId);
        List<String> versions = ((Query)((Query)handle.createQuery(sqlStatement).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).map(StringMapper.instance).list();
        if (versions.isEmpty() && !this.isArtifactExistsRaw(handle, groupId, artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        return versions;
    }

    @Override
    public VersionSearchResultsDto searchVersions(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) throws RegistryStorageException {
        this.log.debug("Searching for versions");
        return this.handles.withHandleNoException(handle -> {
            LinkedList<SqlStatementVariableBinder> binders = new LinkedList<SqlStatementVariableBinder>();
            StringBuilder selectTemplate = new StringBuilder();
            StringBuilder where = new StringBuilder();
            StringBuilder orderByQuery = new StringBuilder();
            StringBuilder limitOffset = new StringBuilder();
            selectTemplate.append("SELECT {{selectColumns}} FROM versions v JOIN artifacts a ON v.groupId = a.groupId AND v.artifactId = a.artifactId");
            where.append(" WHERE (1 = 1)");
            for (SearchFilter filter : filters) {
                where.append(" AND (");
                switch (filter.getType()) {
                    case groupId: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("a.groupId " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, RegistryContentUtils.normalizeGroupId(filter.getStringValue())));
                        break;
                    }
                    case artifactId: 
                    case contentId: 
                    case globalId: 
                    case version: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("v.");
                        where.append(filter.getType().name());
                        where.append(" ");
                        where.append(op);
                        where.append(" ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        break;
                    }
                    case description: 
                    case name: {
                        String op = filter.isNot() ? "NOT LIKE" : "LIKE";
                        where.append("v.");
                        where.append(filter.getType().name());
                        where.append(" ");
                        where.append(op);
                        where.append(" ?");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case labels: {
                        String op = filter.isNot() ? "!=" : "=";
                        Pair<String, String> label = filter.getLabelFilterValue();
                        String labelKey = ((String)label.getKey()).toLowerCase();
                        where.append("EXISTS(SELECT l.* FROM version_labels l WHERE l.labelKey " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, labelKey));
                        if (label.getValue() != null) {
                            String labelValue = ((String)label.getValue()).toLowerCase();
                            where.append(" AND l.labelValue " + op + " ?");
                            binders.add((query, idx) -> query.bind(idx, labelValue));
                        }
                        where.append(" AND l.globalId = v.globalId)");
                        break;
                    }
                    case contentHash: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("EXISTS(SELECT c.* FROM content c WHERE c.contentId = v.contentId AND ");
                        where.append("c.contentHash " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        where.append(")");
                        break;
                    }
                    case canonicalHash: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("EXISTS(SELECT c.* FROM content c WHERE c.contentId = v.contentId AND ");
                        where.append("c.canonicalHash " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        where.append(")");
                        break;
                    }
                }
                where.append(")");
            }
            switch (orderBy) {
                case globalId: {
                    orderByQuery.append(" ORDER BY v.globalId");
                    break;
                }
                case version: {
                    orderByQuery.append(" ORDER BY v.version");
                    break;
                }
                case name: {
                    orderByQuery.append(" ORDER BY v.name");
                    break;
                }
                case createdOn: {
                    orderByQuery.append(" ORDER BY v.createdOn");
                    break;
                }
                case modifiedOn: {
                    orderByQuery.append(" ORDER BY v.modifiedOn");
                    break;
                }
            }
            orderByQuery.append(" ").append(orderDirection.name());
            if ("mssql".equals(this.sqlStatements.dbType())) {
                limitOffset.append(" OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
            } else {
                limitOffset.append(" LIMIT ? OFFSET ?");
            }
            String versionsQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).append((CharSequence)orderByQuery).append((CharSequence)limitOffset).toString().replace("{{selectColumns}}", "v.*, a.type");
            Query versionsQuery = handle.createQuery(versionsQuerySql);
            String countQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).toString().replace("{{selectColumns}}", "count(v.globalId)");
            Query countQuery = handle.createQuery(countQuerySql);
            int idx2 = 0;
            for (SqlStatementVariableBinder binder : binders) {
                binder.bind(versionsQuery, idx2);
                binder.bind(countQuery, idx2);
                ++idx2;
            }
            if ("mssql".equals(this.sqlStatements.dbType())) {
                versionsQuery.bind(idx2++, offset);
                versionsQuery.bind(idx2++, limit);
            } else {
                versionsQuery.bind(idx2++, limit);
                versionsQuery.bind(idx2++, offset);
            }
            List<SearchedVersionDto> versions = versionsQuery.map(SearchedVersionMapper.instance).list();
            Integer count = countQuery.mapTo(Integer.class).one();
            VersionSearchResultsDto results = new VersionSearchResultsDto();
            results.setVersions(versions);
            results.setCount(count.intValue());
            return results;
        });
    }

    @Override
    public StoredArtifactVersionDto getArtifactVersionContent(long globalId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single artifact version by globalId: {}", (Object)globalId);
        return this.handles.withHandle(handle -> {
            Optional<StoredArtifactVersionDto> res = ((Query)handle.createQuery(this.sqlStatements.selectArtifactVersionContentByGlobalId()).bind(0, globalId)).map(StoredArtifactMapper.instance).findOne();
            return res.orElseThrow(() -> new ArtifactNotFoundException(null, "gid-" + globalId));
        });
    }

    @Override
    public StoredArtifactVersionDto getArtifactVersionContent(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single artifact version by artifactId: {} {} and version {}", new Object[]{groupId, artifactId, version});
        return this.handles.withHandle(handle -> {
            Optional<StoredArtifactVersionDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactVersionContent()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).map(StoredArtifactMapper.instance).findOne();
            return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
        });
    }

    @Override
    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Deleting version {} of artifact {} {}", new Object[]{version, groupId, artifactId});
        this.handles.withHandle(handle -> {
            int rows = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.deleteVersion()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).execute();
            if (rows == 0) {
                throw new VersionNotFoundException(groupId, artifactId, version);
            }
            if (rows > 1) {
                throw new UnreachableCodeException();
            }
            this.deleteAllOrphanedContentRaw(handle);
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactVersionDeleted.of(groupId, artifactId, version)));
            return null;
        });
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(Long globalId) throws VersionNotFoundException, RegistryStorageException {
        return this.handles.withHandle(handle -> {
            Optional<ArtifactVersionMetaDataDto> res = ((Query)handle.createQuery(this.sqlStatements.selectArtifactVersionMetaDataByGlobalId()).bind(0, globalId)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
            return res.orElseThrow(() -> new VersionNotFoundException(globalId));
        });
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String groupId, String artifactId, String version) {
        return this.handles.withHandle(handle -> this.getArtifactVersionMetaDataRaw(handle, groupId, artifactId, version));
    }

    public ArtifactVersionMetaDataDto getArtifactVersionMetaDataRaw(Handle handle, String groupId, String artifactId, String version) {
        Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactVersionMetaData()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
        return res.orElseThrow(() -> new VersionNotFoundException(groupId, artifactId, version));
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableVersionMetaDataDto editableMetadata) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Updating meta-data for an artifact version: {} {}", (Object)groupId, (Object)artifactId);
        ArtifactVersionMetaDataDto metadata = this.getArtifactVersionMetaData(groupId, artifactId, version);
        long globalId = metadata.getGlobalId();
        this.handles.withHandle(handle -> {
            int rowCount;
            if (editableMetadata.getName() != null && (rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactVersionNameByGAV()).bind(0, StringUtil.limitStr(editableMetadata.getName(), 512))).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).execute()) == 0) {
                throw new VersionNotFoundException(groupId, artifactId, version);
            }
            if (editableMetadata.getDescription() != null && (rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactVersionDescriptionByGAV()).bind(0, StringUtil.limitStr(editableMetadata.getDescription(), 1024))).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).execute()) == 0) {
                throw new VersionNotFoundException(groupId, artifactId, version);
            }
            if (editableMetadata.getState() != null && (rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactVersionStateByGAV()).bind(0, editableMetadata.getState().name())).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).execute()) == 0) {
                throw new VersionNotFoundException(groupId, artifactId, version);
            }
            if (editableMetadata.getLabels() != null) {
                rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateArtifactVersionLabelsByGAV()).bind(0, RegistryContentUtils.serializeLabels(editableMetadata.getLabels()))).bind(1, RegistryContentUtils.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).execute();
                if (rowCount == 0) {
                    throw new VersionNotFoundException(groupId, artifactId, version);
                }
                ((Update)handle.createUpdate(this.sqlStatements.deleteVersionLabelsByGlobalId()).bind(0, globalId)).execute();
                Map<String, String> labels = editableMetadata.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    labels.forEach((k, v) -> {
                        String sqli = this.sqlStatements.insertVersionLabel();
                        ((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, globalId)).bind(1, StringUtil.limitStr(k.toLowerCase(), 256))).bind(2, StringUtil.limitStr(StringUtil.asLowerCase(v), 512))).execute();
                    });
                }
            }
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(ArtifactVersionMetadataUpdated.of(groupId, artifactId, version, editableMetadata)));
            return null;
        });
    }

    @Override
    public CommentDto createArtifactVersionComment(String groupId, String artifactId, String version, String value) {
        this.log.debug("Inserting an artifact comment row for artifact: {} {} version: {}", new Object[]{groupId, artifactId, version});
        String owner = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        try {
            ArtifactVersionMetaDataDto metadata = this.getArtifactVersionMetaData(groupId, artifactId, version);
            CommentEntity entity = CommentEntity.builder().commentId(String.valueOf(this.nextCommentId())).globalId(metadata.getGlobalId()).owner(owner).createdOn(createdOn.getTime()).value(value).build();
            this.importComment(entity);
            this.log.debug("Comment row successfully inserted.");
            return CommentDto.builder().commentId(entity.commentId).owner(owner).createdOn(createdOn.getTime()).value(value).build();
        }
        catch (VersionNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (this.sqlStatements.isForeignKeyViolation(ex)) {
                throw new ArtifactNotFoundException(groupId, artifactId, ex);
            }
            throw ex;
        }
    }

    @Override
    public List<CommentDto> getArtifactVersionComments(String groupId, String artifactId, String version) {
        this.log.debug("Getting a list of all artifact version comments for: {} {} @ {}", new Object[]{groupId, artifactId, version});
        try {
            return this.handles.withHandle(handle -> ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectVersionComments()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).map(CommentDtoMapper.instance).list());
        }
        catch (ArtifactNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RegistryStorageException(ex);
        }
    }

    @Override
    public void deleteArtifactVersionComment(String groupId, String artifactId, String version, String commentId) {
        this.log.debug("Deleting a version comment for artifact: {} {} @ {}", new Object[]{groupId, artifactId, version});
        String deletedBy = this.securityIdentity.getPrincipal().getName();
        this.handles.withHandle(handle -> {
            Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactVersionMetaData()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
            ArtifactVersionMetaDataDto avmdd = res.orElseThrow(() -> new VersionNotFoundException(groupId, artifactId, version));
            int rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.deleteVersionComment()).bind(0, avmdd.getGlobalId())).bind(1, commentId)).bind(2, deletedBy)).execute();
            if (rowCount == 0) {
                throw new CommentNotFoundException(commentId);
            }
            return null;
        });
    }

    @Override
    public void updateArtifactVersionComment(String groupId, String artifactId, String version, String commentId, String value) {
        this.log.debug("Updating a comment for artifact: {} {} @ {}", new Object[]{groupId, artifactId, version});
        String modifiedBy = this.securityIdentity.getPrincipal().getName();
        this.handles.withHandle(handle -> {
            Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectArtifactVersionMetaData()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
            ArtifactVersionMetaDataDto avmdd = res.orElseThrow(() -> new VersionNotFoundException(groupId, artifactId, version));
            int rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateVersionComment()).bind(0, value)).bind(1, avmdd.getGlobalId())).bind(2, commentId)).bind(3, modifiedBy)).execute();
            if (rowCount == 0) {
                throw new CommentNotFoundException(commentId);
            }
            return null;
        });
    }

    @Override
    public List<RuleType> getGlobalRules() throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> handle.createQuery(this.sqlStatements.selectGlobalRules()).map(rs -> RuleType.fromValue(rs.getString("type"))).list());
    }

    @Override
    public void createGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleAlreadyExistsException, RegistryStorageException {
        this.log.debug("Inserting a global rule row for: {}", (Object)rule.name());
        try {
            this.handles.withHandle(handle -> {
                ((Update)((Update)handle.createUpdate(this.sqlStatements.insertGlobalRule()).bind(0, rule.name())).bind(1, config.getConfiguration())).execute();
                this.outboxEvent.fire((Object)SqlOutboxEvent.of(GlobalRuleConfigured.of(rule, config)));
                return null;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new RuleAlreadyExistsException(rule);
            }
            throw ex;
        }
    }

    @Override
    public void deleteGlobalRules() throws RegistryStorageException {
        this.log.debug("Deleting all Global Rules");
        this.handles.withHandleNoException(handle -> {
            handle.createUpdate(this.sqlStatements.deleteGlobalRules()).execute();
            return null;
        });
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single global rule: {}", (Object)rule.name());
        return this.handles.withHandle(handle -> {
            Optional<RuleConfigurationDto> res = ((Query)handle.createQuery(this.sqlStatements.selectGlobalRuleByType()).bind(0, rule.name())).map(RuleConfigurationDtoMapper.instance).findOne();
            return res.orElseThrow(() -> new RuleNotFoundException(rule));
        });
    }

    @Override
    public void updateGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleNotFoundException, RegistryStorageException {
        this.log.debug("Updating a global rule: {}::{}", (Object)rule.name(), (Object)config.getConfiguration());
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)((Update)handle.createUpdate(this.sqlStatements.updateGlobalRule()).bind(0, config.getConfiguration())).bind(1, rule.name())).execute();
            if (rowCount == 0) {
                throw new RuleNotFoundException(rule);
            }
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(GlobalRuleConfigured.of(rule, config)));
            return null;
        });
    }

    @Override
    public void deleteGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        this.log.debug("Deleting a global rule: {}", (Object)rule.name());
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)handle.createUpdate(this.sqlStatements.deleteGlobalRule()).bind(0, rule.name())).execute();
            if (rowCount == 0) {
                throw new RuleNotFoundException(rule);
            }
            switch (rule) {
                case VALIDITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(GlobalRuleConfigured.of(rule, RuleConfigurationDto.builder().configuration(ValidityLevel.NONE.name()).build())));
                    break;
                }
                case COMPATIBILITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(GlobalRuleConfigured.of(rule, RuleConfigurationDto.builder().configuration(CompatibilityLevel.NONE.name()).build())));
                    break;
                }
                case INTEGRITY: {
                    this.outboxEvent.fire((Object)SqlOutboxEvent.of(GlobalRuleConfigured.of(rule, RuleConfigurationDto.builder().configuration(IntegrityLevel.NONE.name()).build())));
                }
            }
            return null;
        });
    }

    public List<DynamicConfigPropertyDto> getConfigProperties() throws RegistryStorageException {
        this.log.debug("Getting all config properties.");
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectConfigProperties();
            return handle.createQuery(sql).map(DynamicConfigPropertyDtoMapper.instance).list().stream().filter(Objects::nonNull).collect(Collectors.toList());
        });
    }

    public DynamicConfigPropertyDto getConfigProperty(String propertyName) throws RegistryStorageException {
        return this.getRawConfigProperty(propertyName);
    }

    @Override
    public DynamicConfigPropertyDto getRawConfigProperty(String propertyName) {
        this.log.debug("Selecting a single config property: {}", (Object)propertyName);
        return this.handles.withHandle(handle -> {
            String normalizedPropertyName = DtoUtil.appAuthPropertyToRegistry(propertyName);
            Optional<DynamicConfigPropertyDto> res = ((Query)handle.createQuery(this.sqlStatements.selectConfigPropertyByName()).bind(0, normalizedPropertyName)).map(DynamicConfigPropertyDtoMapper.instance).findOne();
            return res.orElse(null);
        });
    }

    public void setConfigProperty(DynamicConfigPropertyDto propertyDto) throws RegistryStorageException {
        this.log.debug("Setting a config property with name: {}  and value: {}", (Object)propertyDto.getName(), (Object)propertyDto.getValue());
        this.handles.withHandleNoException(handle -> {
            String propertyName = propertyDto.getName();
            String propertyValue = propertyDto.getValue();
            ((Update)handle.createUpdate(this.sqlStatements.deleteConfigProperty()).bind(0, propertyName)).execute();
            ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertConfigProperty()).bind(0, propertyName)).bind(1, propertyValue)).bind(2, System.currentTimeMillis())).execute();
            return null;
        });
    }

    public void deleteConfigProperty(String propertyName) throws RegistryStorageException {
        this.handles.withHandle(handle -> {
            ((Update)handle.createUpdate(this.sqlStatements.deleteConfigProperty()).bind(0, propertyName)).execute();
            return null;
        });
    }

    @Override
    public List<DynamicConfigPropertyDto> getStaleConfigProperties(Instant lastRefresh) throws RegistryStorageException {
        this.log.debug("Getting all stale config properties.");
        return this.handles.withHandleNoException(handle -> ((Query)handle.createQuery(this.sqlStatements.selectStaleConfigProperties()).bind(0, lastRefresh.toEpochMilli())).map(DynamicConfigPropertyDtoMapper.instance).list().stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void ensureGroup(GroupMetaDataDto group) {
        try {
            this.createGroup(group);
        }
        catch (GroupAlreadyExistsException groupAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void createGroup(GroupMetaDataDto group) throws GroupAlreadyExistsException, RegistryStorageException {
        try {
            this.handles.withHandle(handle -> {
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertGroup()).bind(0, group.getGroupId())).bind(1, group.getDescription())).bind(2, group.getArtifactsType())).bind(3, group.getOwner())).bind(4, group.getCreatedOn() == 0L ? new Date() : new Date(group.getCreatedOn()))).bind(5, group.getModifiedBy())).bind(6, group.getModifiedOn() == 0L ? new Date() : new Date(group.getModifiedOn()))).bind(7, RegistryContentUtils.serializeLabels(group.getLabels()))).execute();
                Map<String, String> labels = group.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    labels.forEach((k, v) -> {
                        String sqli = this.sqlStatements.insertGroupLabel();
                        ((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, group.getGroupId())).bind(1, StringUtil.limitStr(k.toLowerCase(), 256))).bind(2, StringUtil.limitStr(StringUtil.asLowerCase(v), 512))).execute();
                    });
                }
                this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupCreated.of(group)));
                return null;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new GroupAlreadyExistsException(group.getGroupId());
            }
            throw ex;
        }
    }

    @Override
    public void deleteGroup(String groupId) throws GroupNotFoundException, RegistryStorageException {
        this.handles.withHandleNoException(handle -> {
            ((Update)handle.createUpdate(this.sqlStatements.deleteArtifactRulesByGroupId()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).execute();
            ((Update)handle.createUpdate(this.sqlStatements.deleteArtifactsByGroupId()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).execute();
            int rows = ((Update)handle.createUpdate(this.sqlStatements.deleteGroup()).bind(0, groupId)).execute();
            if (rows == 0) {
                throw new GroupNotFoundException(groupId);
            }
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupDeleted.of(groupId)));
            return null;
        });
    }

    @Override
    public void updateGroupMetaData(String groupId, EditableGroupMetaDataDto dto) {
        String modifiedBy = this.securityIdentity.getPrincipal().getName();
        Date modifiedOn = new Date();
        this.log.debug("Updating metadata for group {}.", (Object)groupId);
        this.handles.withHandleNoException(handle -> {
            int rows = ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateGroup()).bind(0, dto.getDescription())).bind(1, modifiedBy)).bind(2, modifiedOn)).bind(3, RegistryContentUtils.serializeLabels(dto.getLabels()))).bind(4, groupId)).execute();
            if (rows == 0) {
                throw new GroupNotFoundException(groupId);
            }
            ((Update)handle.createUpdate(this.sqlStatements.deleteGroupLabelsByGroupId()).bind(0, groupId)).execute();
            if (dto.getLabels() != null && !dto.getLabels().isEmpty()) {
                dto.getLabels().forEach((k, v) -> {
                    String sqli = this.sqlStatements.insertGroupLabel();
                    ((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, groupId)).bind(1, StringUtil.limitStr(k.toLowerCase(), 256))).bind(2, StringUtil.limitStr(StringUtil.asLowerCase(v), 512))).execute();
                });
            }
            this.outboxEvent.fire((Object)SqlOutboxEvent.of(GroupMetadataUpdated.of(groupId, dto)));
            return null;
        });
    }

    @Override
    public List<String> getGroupIds(Integer limit) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            Query query = handle.createQuery(this.sqlStatements.selectGroups());
            query.bind(0, limit);
            return query.map(rs -> rs.getString("groupId")).list();
        });
    }

    @Override
    public GroupMetaDataDto getGroupMetaData(String groupId) throws GroupNotFoundException, RegistryStorageException {
        return this.handles.withHandle(handle -> {
            Optional<GroupMetaDataDto> res = ((Query)handle.createQuery(this.sqlStatements.selectGroupByGroupId()).bind(0, groupId)).map(GroupMetaDataDtoMapper.instance).findOne();
            return res.orElseThrow(() -> new GroupNotFoundException(groupId));
        });
    }

    @Override
    public void exportData(Function<Entity, Void> handler) throws RegistryStorageException {
        ManifestEntity manifest = new ManifestEntity();
        if (this.securityIdentity != null && this.securityIdentity.getPrincipal() != null) {
            manifest.exportedBy = this.securityIdentity.getPrincipal().getName();
        }
        manifest.systemName = this.system.getName();
        manifest.systemDescription = this.system.getDescription();
        manifest.systemVersion = this.system.getVersion();
        manifest.dbVersion = "" + DB_VERSION;
        handler.apply((Entity)manifest);
        this.handles.withHandle(handle -> {
            Stream<ContentEntity> stream;
            try (Stream<ContentEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportContent()).setFetchSize(50).map(ContentEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<GroupEntity> stream;
            try (Stream<GroupEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportGroups()).setFetchSize(50).map(GroupEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<GroupRuleEntity> stream;
            try (Stream<GroupRuleEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportGroupRules()).setFetchSize(50).map(GroupRuleEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<ArtifactEntity> stream;
            try (Stream<ArtifactEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportArtifacts()).setFetchSize(50).map(ArtifactEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<ArtifactVersionEntity> stream;
            try (Stream<ArtifactVersionEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportArtifactVersions()).setFetchSize(50).map(ArtifactVersionEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<CommentEntity> stream;
            try (Stream<CommentEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportVersionComments()).setFetchSize(50).map(CommentEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<BranchEntity> stream;
            try (Stream<BranchEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportBranches()).setFetchSize(50).map(BranchEntityMapper.instance).stream();){
                stream.forEach(branch -> {
                    branch.versions = this.getBranchVersionNumbersRaw(handle, branch.toGA(), branch.toBranchId());
                    handler.apply((Entity)branch);
                });
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<ArtifactRuleEntity> stream;
            try (Stream<ArtifactRuleEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportArtifactRules()).setFetchSize(50).map(ArtifactRuleEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
        this.handles.withHandle(handle -> {
            Stream<GlobalRuleEntity> stream;
            try (Stream<GlobalRuleEntity> stream2 = stream = handle.createQuery(this.sqlStatements.exportGlobalRules()).setFetchSize(50).map(GlobalRuleEntityMapper.instance).stream();){
                stream.forEach(handler::apply);
            }
            return null;
        });
    }

    @Override
    public void importData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) {
        SqlDataImporter dataImporter = new SqlDataImporter(this.log, this.utils, this, preserveGlobalId, preserveContentId);
        dataImporter.importData(entities, () -> {});
    }

    @Override
    public void upgradeData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) {
        SqlDataUpgrader dataImporter = new SqlDataUpgrader(this.log, this.utils, this, preserveGlobalId, preserveContentId);
        dataImporter.importData(entities, () -> {});
    }

    @Override
    public long countArtifacts() throws RegistryStorageException {
        return this.handles.withHandle(handle -> handle.createQuery(this.sqlStatements.selectAllArtifactCount()).mapTo(Long.class).one());
    }

    @Override
    public long countArtifactVersions(String groupId, String artifactId) throws RegistryStorageException {
        return this.handles.withHandle(handle -> {
            if (!this.isArtifactExistsRaw(handle, groupId, artifactId)) {
                throw new ArtifactNotFoundException(groupId, artifactId);
            }
            return this.countArtifactVersionsRaw(handle, groupId, artifactId);
        });
    }

    private long countArtifactVersionsRaw(Handle handle, String groupId, String artifactId) throws RegistryStorageException {
        return ((Query)((Query)handle.createQuery(this.sqlStatements.selectAllArtifactVersionsCount()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).mapTo(Long.class).one();
    }

    @Override
    public long countTotalArtifactVersions() throws RegistryStorageException {
        return this.handles.withHandle(handle -> handle.createQuery(this.sqlStatements.selectTotalArtifactVersionsCount()).mapTo(Long.class).one());
    }

    @Override
    public void createRoleMapping(String principalId, String role, String principalName) throws RegistryStorageException {
        this.log.debug("Inserting a role mapping row for: {}", (Object)principalId);
        try {
            this.handles.withHandle(handle -> {
                ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertRoleMapping()).bind(0, principalId)).bind(1, role)).bind(2, principalName)).execute();
                return null;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new RoleMappingAlreadyExistsException(principalId, role);
            }
            throw ex;
        }
    }

    @Override
    public void deleteRoleMapping(String principalId) throws RegistryStorageException {
        this.log.debug("Deleting a role mapping row for: {}", (Object)principalId);
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)handle.createUpdate(this.sqlStatements.deleteRoleMapping()).bind(0, principalId)).execute();
            if (rowCount == 0) {
                throw new RoleMappingNotFoundException(principalId);
            }
            return null;
        });
    }

    @Override
    public RoleMappingDto getRoleMapping(String principalId) throws RegistryStorageException {
        this.log.debug("Selecting a single role mapping for: {}", (Object)principalId);
        return this.handles.withHandle(handle -> {
            Optional<RoleMappingDto> res = ((Query)handle.createQuery(this.sqlStatements.selectRoleMappingByPrincipalId()).bind(0, principalId)).map(RoleMappingDtoMapper.instance).findOne();
            return res.orElseThrow(() -> new RoleMappingNotFoundException(principalId));
        });
    }

    @Override
    public String getRoleForPrincipal(String principalId) throws RegistryStorageException {
        this.log.debug("Selecting the role for: {}", (Object)principalId);
        return this.handles.withHandle(handle -> {
            Optional<String> res = ((Query)handle.createQuery(this.sqlStatements.selectRoleByPrincipalId()).bind(0, principalId)).mapTo(String.class).findOne();
            return res.orElse(null);
        });
    }

    @Override
    public List<RoleMappingDto> getRoleMappings() throws RegistryStorageException {
        this.log.debug("Getting a list of all role mappings.");
        return this.handles.withHandleNoException(handle -> handle.createQuery(this.sqlStatements.selectRoleMappings()).map(RoleMappingDtoMapper.instance).list());
    }

    @Override
    public RoleMappingSearchResultsDto searchRoleMappings(int offset, int limit) throws RegistryStorageException {
        this.log.debug("Searching role mappings.");
        return this.handles.withHandleNoException(handle -> {
            String query = this.sqlStatements.selectRoleMappings() + " LIMIT ? OFFSET ?";
            String countQuery = this.sqlStatements.countRoleMappings();
            List<RoleMappingDto> mappings = ((Query)((Query)handle.createQuery(query).bind(0, limit)).bind(1, offset)).map(RoleMappingDtoMapper.instance).list();
            Integer count = handle.createQuery(countQuery).mapTo(Integer.class).one();
            return RoleMappingSearchResultsDto.builder().count(count.intValue()).roleMappings(mappings).build();
        });
    }

    @Override
    public void updateRoleMapping(String principalId, String role) throws RegistryStorageException {
        this.log.debug("Updating a role mapping: {}::{}", (Object)principalId, (Object)role);
        this.handles.withHandle(handle -> {
            int rowCount = ((Update)((Update)handle.createUpdate(this.sqlStatements.updateRoleMapping()).bind(0, role)).bind(1, principalId)).execute();
            if (rowCount == 0) {
                throw new RoleMappingNotFoundException(principalId, role);
            }
            return null;
        });
    }

    @Override
    public String createDownload(DownloadContextDto context) throws RegistryStorageException {
        this.log.debug("Inserting a download.");
        String downloadId = UUID.randomUUID().toString();
        return this.handles.withHandleNoException(handle -> {
            ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertDownload()).bind(0, downloadId)).bind(1, context.getExpires())).bind(2, mapper.writeValueAsString((Object)context))).execute();
            return downloadId;
        });
    }

    @Override
    public DownloadContextDto consumeDownload(String downloadId) throws RegistryStorageException {
        this.log.debug("Consuming a download ID: {}", (Object)downloadId);
        return this.handles.withHandleNoException(handle -> {
            long now = System.currentTimeMillis();
            Optional<String> res = ((Query)((Query)handle.createQuery(this.sqlStatements.selectDownloadContext()).bind(0, downloadId)).bind(1, now)).mapTo(String.class).findOne();
            String downloadContext = res.orElseThrow(DownloadNotFoundException::new);
            int rowCount = ((Update)handle.createUpdate(this.sqlStatements.deleteDownload()).bind(0, downloadId)).execute();
            if (rowCount == 0) {
                throw new DownloadNotFoundException();
            }
            return (DownloadContextDto)mapper.readValue(downloadContext, DownloadContextDto.class);
        });
    }

    @Override
    public void deleteAllExpiredDownloads() throws RegistryStorageException {
        this.log.debug("Deleting all expired downloads");
        long now = System.currentTimeMillis();
        this.handles.withHandleNoException(handle -> {
            ((Update)handle.createUpdate(this.sqlStatements.deleteExpiredDownloads()).bind(0, now)).execute();
            return null;
        });
    }

    @Override
    public void deleteAllUserData() {
        this.log.debug("Deleting all user data");
        this.deleteGlobalRules();
        this.handles.withHandleNoException(handle -> {
            handle.createUpdate(this.sqlStatements.deleteAllContentReferences()).execute();
            handle.createUpdate(this.sqlStatements.deleteVersionLabelsByAll()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllVersionComments()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllBranches()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllVersions()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllArtifactRules()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllArtifacts()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllGroups()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllRoleMappings()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllContent()).execute();
            handle.createUpdate(this.sqlStatements.deleteAllConfigProperties()).execute();
            return null;
        });
    }

    private Map<String, TypedContent> resolveReferencesRaw(Handle handle, List<ArtifactReferenceDto> references) {
        if (references == null || references.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, TypedContent> result = new LinkedHashMap<String, TypedContent>();
        this.resolveReferencesRaw(handle, result, references);
        return result;
    }

    @Override
    public boolean isArtifactExists(String groupId, String artifactId) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> this.isArtifactExistsRaw(handle, groupId, artifactId));
    }

    private boolean isArtifactExistsRaw(Handle handle, String groupId, String artifactId) throws RegistryStorageException {
        return ((Query)((Query)handle.createQuery(this.sqlStatements().selectArtifactCountById()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).mapTo(Integer.class).one() > 0;
    }

    @Override
    public boolean isGroupExists(String groupId) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> this.isGroupExistsRaw(handle, groupId));
    }

    private boolean isGroupExistsRaw(Handle handle, String groupId) throws RegistryStorageException {
        return ((Query)handle.createQuery(this.sqlStatements().selectGroupCountById()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).mapTo(Integer.class).one() > 0;
    }

    @Override
    public List<Long> getContentIdsReferencingArtifactVersion(String groupId, String artifactId, String version) {
        return this.handles.withHandleNoException(handle -> ((Query)((Query)((Query)handle.createQuery(this.sqlStatements().selectContentIdsReferencingArtifactBy()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).mapTo(Long.class).list());
    }

    @Override
    public List<Long> getGlobalIdsReferencingArtifactVersion(String groupId, String artifactId, String version) {
        return this.handles.withHandleNoException(handle -> ((Query)((Query)((Query)handle.createQuery(this.sqlStatements().selectGlobalIdsReferencingArtifactBy()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).mapTo(Long.class).list());
    }

    @Override
    public List<ArtifactReferenceDto> getInboundArtifactReferences(String groupId, String artifactId, String version) {
        return this.handles.withHandleNoException(handle -> ((Query)((Query)((Query)handle.createQuery(this.sqlStatements().selectInboundContentReferencesByGAV()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, version)).map(ArtifactReferenceDtoMapper.instance).list());
    }

    @Override
    public boolean isArtifactVersionExists(String groupId, String artifactId, String version) throws RegistryStorageException {
        try {
            this.getArtifactVersionMetaData(groupId, artifactId, version);
            return true;
        }
        catch (VersionNotFoundException ignored) {
            return false;
        }
    }

    @Override
    public GroupSearchResultsDto searchGroups(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, Integer offset, Integer limit) {
        return this.handles.withHandleNoException(handle -> {
            LinkedList<SqlStatementVariableBinder> binders = new LinkedList<SqlStatementVariableBinder>();
            StringBuilder selectTemplate = new StringBuilder();
            StringBuilder where = new StringBuilder();
            StringBuilder orderByQuery = new StringBuilder();
            StringBuilder limitOffset = new StringBuilder();
            selectTemplate.append("SELECT {{selectColumns}} FROM groups g ");
            where.append(" WHERE (1 = 1)");
            for (SearchFilter filter : filters) {
                where.append(" AND (");
                switch (filter.getType()) {
                    case description: {
                        String op = filter.isNot() ? "NOT LIKE" : "LIKE";
                        where.append("g.description ");
                        where.append(op);
                        where.append(" ?");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case groupId: {
                        String op = filter.isNot() ? "!=" : "=";
                        where.append("g.groupId ");
                        where.append(op);
                        where.append(" ?");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        break;
                    }
                    case labels: {
                        String op = filter.isNot() ? "!=" : "=";
                        Pair<String, String> label = filter.getLabelFilterValue();
                        String labelKey = ((String)label.getKey()).toLowerCase();
                        where.append("EXISTS(SELECT l.* FROM group_labels l WHERE l.labelKey " + op + " ?");
                        binders.add((query, idx) -> query.bind(idx, labelKey));
                        if (label.getValue() != null) {
                            String labelValue = ((String)label.getValue()).toLowerCase();
                            where.append(" AND l.labelValue " + op + " ?");
                            binders.add((query, idx) -> query.bind(idx, labelValue));
                        }
                        where.append(" AND l.groupId = g.groupId)");
                        break;
                    }
                }
                where.append(")");
            }
            switch (orderBy) {
                case groupId: {
                    orderByQuery.append(" ORDER BY g.groupId");
                    break;
                }
                case createdOn: {
                    orderByQuery.append(" ORDER BY g.").append(orderBy.name());
                    break;
                }
            }
            orderByQuery.append(" ").append(orderDirection.name());
            if ("mssql".equals(this.sqlStatements.dbType())) {
                limitOffset.append(" OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
            } else {
                limitOffset.append(" LIMIT ? OFFSET ?");
            }
            String groupsQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).append((CharSequence)orderByQuery).append((CharSequence)limitOffset).toString().replace("{{selectColumns}}", "*");
            Query groupsQuery = handle.createQuery(groupsQuerySql);
            String countQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).toString().replace("{{selectColumns}}", "count(g.groupId)");
            Query countQuery = handle.createQuery(countQuerySql);
            int idx2 = 0;
            for (SqlStatementVariableBinder binder : binders) {
                binder.bind(groupsQuery, idx2);
                binder.bind(countQuery, idx2);
                ++idx2;
            }
            if ("mssql".equals(this.sqlStatements.dbType())) {
                groupsQuery.bind(idx2++, offset);
                groupsQuery.bind(idx2++, limit);
            } else {
                groupsQuery.bind(idx2++, limit);
                groupsQuery.bind(idx2++, offset);
            }
            List<SearchedGroupDto> groups = groupsQuery.map(SearchedGroupMapper.instance).list();
            Integer count = countQuery.mapTo(Integer.class).one();
            GroupSearchResultsDto results = new GroupSearchResultsDto();
            results.setGroups(groups);
            results.setCount(count);
            return results;
        });
    }

    @Override
    @Transactional
    public ContentWrapperDto getContentByReference(ArtifactReferenceDto reference) {
        try {
            ArtifactVersionMetaDataDto meta = this.getArtifactVersionMetaData(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
            ContentWrapperDto artifactByContentId = this.getContentById(meta.getContentId());
            artifactByContentId.setArtifactType(meta.getArtifactType());
            return artifactByContentId;
        }
        catch (VersionNotFoundException e) {
            return null;
        }
    }

    private void resolveReferencesRaw(Handle handle, Map<String, TypedContent> resolvedReferences, List<ArtifactReferenceDto> references) {
        if (references != null && !references.isEmpty()) {
            for (ArtifactReferenceDto reference : references) {
                if (reference.getArtifactId() == null || reference.getName() == null || reference.getVersion() == null) {
                    throw new IllegalStateException("Invalid reference: " + reference);
                }
                if (resolvedReferences.containsKey(reference.getName())) continue;
                try {
                    ArtifactVersionMetaDataDto referencedArtifactMetaData = this.getArtifactVersionMetaDataRaw(handle, reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
                    ContentWrapperDto referencedContent = this.getContentByIdRaw(handle, referencedArtifactMetaData.getContentId());
                    this.resolveReferencesRaw(handle, resolvedReferences, referencedContent.getReferences());
                    TypedContent typedContent = TypedContent.create((ContentHandle)referencedContent.getContent(), (String)referencedContent.getContentType());
                    resolvedReferences.put(reference.getName(), typedContent);
                }
                catch (VersionNotFoundException versionNotFoundException) {}
            }
        }
    }

    private void deleteAllOrphanedContentRaw(Handle handle) {
        this.log.debug("Deleting all orphaned content");
        handle.createUpdate(this.sqlStatements.deleteOrphanedContentReferences()).execute();
        handle.createUpdate(this.sqlStatements.deleteAllOrphanedContent()).execute();
    }

    private long getMaxGlobalIdRaw(Handle handle) {
        return this.getMaxIdRaw(handle, this.sqlStatements.selectMaxGlobalId());
    }

    private long getMaxContentIdRaw(Handle handle) {
        return this.getMaxIdRaw(handle, this.sqlStatements.selectMaxContentId());
    }

    private long getMaxVersionCommentIdRaw(Handle handle) {
        return this.getMaxIdRaw(handle, this.sqlStatements.selectMaxVersionCommentId());
    }

    private long getMaxIdRaw(Handle handle, String sql) {
        Optional<Long> maxIdTable = handle.createQuery(sql).mapTo(Long.class).findOne();
        return maxIdTable.orElse(1L);
    }

    @Override
    public void resetGlobalId() {
        this.handles.withHandleNoException(handle -> this.resetSequenceRaw(handle, GLOBAL_ID_SEQUENCE, this.sqlStatements.selectMaxGlobalId()));
    }

    @Override
    public void resetContentId() {
        this.handles.withHandleNoException(handle -> this.resetSequenceRaw(handle, CONTENT_ID_SEQUENCE, this.sqlStatements.selectMaxContentId()));
    }

    @Override
    public void resetCommentId() {
        this.handles.withHandleNoException(handle -> this.resetSequenceRaw(handle, COMMENT_ID_SEQUENCE, this.sqlStatements.selectMaxVersionCommentId()));
    }

    private void resetSequenceRaw(Handle handle, String sequenceName, String sqlMaxIdFromTable) {
        Optional<Long> current;
        Optional<Long> currentIdSeq;
        Optional<Long> maxIdTable = handle.createQuery(sqlMaxIdFromTable).mapTo(Long.class).findOne();
        Optional<Long> maxId = maxIdTable.map(arg_0 -> AbstractSqlRegistryStorage.lambda$resetSequenceRaw$144(currentIdSeq = (current = this.isH2() ? Optional.of(sequenceCounters.get(sequenceName).get()) : ((Query)handle.createQuery(this.sqlStatements.selectCurrentSequenceValue()).bind(0, sequenceName)).mapTo(Long.class).findOne()), arg_0));
        if (maxId.isPresent()) {
            this.log.info("Resetting {} sequence", (Object)sequenceName);
            long id = maxId.get();
            if (this.isPostgresql()) {
                ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.resetSequenceValue()).bind(0, sequenceName)).bind(1, id)).bind(2, id)).execute();
            } else if (this.isH2()) {
                sequenceCounters.get(sequenceName).set(id);
            } else {
                ((Update)((Update)handle.createUpdate(this.sqlStatements.resetSequenceValue()).bind(0, sequenceName)).bind(1, id)).execute();
            }
            this.log.info("Successfully reset {} to {}", (Object)sequenceName, (Object)id);
        }
    }

    @Override
    public void importGroupRule(GroupRuleEntity entity) {
        this.handles.withHandleNoException(handle -> {
            if (!this.isGroupExistsRaw(handle, entity.groupId)) {
                throw new GroupNotFoundException(entity.groupId);
            }
            ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.importGroupRule()).bind(0, RegistryContentUtils.normalizeGroupId(entity.groupId))).bind(1, entity.type.name())).bind(2, entity.configuration)).execute();
            return null;
        });
    }

    @Override
    public void importArtifactRule(ArtifactRuleEntity entity) {
        this.handles.withHandleNoException(handle -> {
            if (!this.isArtifactExistsRaw(handle, entity.groupId, entity.artifactId)) {
                throw new ArtifactNotFoundException(entity.groupId, entity.artifactId);
            }
            ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.importArtifactRule()).bind(0, RegistryContentUtils.normalizeGroupId(entity.groupId))).bind(1, entity.artifactId)).bind(2, entity.type.name())).bind(3, entity.configuration)).execute();
            return null;
        });
    }

    @Override
    public void importArtifact(ArtifactEntity entity) {
        this.handles.withHandleNoException(handle -> {
            if (!this.isArtifactExistsRaw(handle, entity.groupId, entity.artifactId)) {
                String labelsStr = RegistryContentUtils.serializeLabels(entity.labels);
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertArtifact()).bind(0, RegistryContentUtils.normalizeGroupId(entity.groupId))).bind(1, entity.artifactId)).bind(2, entity.artifactType)).bind(3, entity.owner)).bind(4, new Date(entity.createdOn))).bind(5, entity.modifiedBy)).bind(6, new Date(entity.modifiedOn))).bind(7, entity.name)).bind(8, entity.description)).bind(9, labelsStr)).execute();
                if (entity.labels != null && !entity.labels.isEmpty()) {
                    entity.labels.forEach((k, v) -> ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertArtifactLabel()).bind(0, RegistryContentUtils.normalizeGroupId(entity.groupId))).bind(1, entity.artifactId)).bind(2, k.toLowerCase())).bind(3, v == null ? null : v.toLowerCase())).execute());
                }
            } else {
                throw new ArtifactAlreadyExistsException(entity.groupId, entity.artifactId);
            }
            return null;
        });
    }

    @Override
    public void importArtifactVersion(ArtifactVersionEntity entity) {
        this.handles.withHandleNoException(handle -> {
            if (!this.isArtifactExistsRaw(handle, entity.groupId, entity.artifactId)) {
                throw new ArtifactNotFoundException(entity.groupId, entity.artifactId);
            }
            if (this.isGlobalIdExistsRaw(handle, entity.globalId)) {
                throw new VersionAlreadyExistsException(entity.globalId);
            }
            if (!this.isGlobalIdExistsRaw(handle, entity.globalId)) {
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.importArtifactVersion()).bind(0, entity.globalId)).bind(1, RegistryContentUtils.normalizeGroupId(entity.groupId))).bind(2, entity.artifactId)).bind(3, entity.version)).bind(4, entity.versionOrder)).bind(5, entity.state)).bind(6, entity.name)).bind(7, entity.description)).bind(8, entity.owner)).bind(9, new Date(entity.createdOn))).bind(10, entity.modifiedBy)).bind(11, new Date(entity.modifiedOn))).bind(12, RegistryContentUtils.serializeLabels(entity.labels))).bind(13, entity.contentId)).execute();
                if (entity.labels != null && !entity.labels.isEmpty()) {
                    entity.labels.forEach((k, v) -> ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertVersionLabel()).bind(0, entity.globalId)).bind(1, k.toLowerCase())).bind(2, v == null ? null : v.toLowerCase())).execute());
                }
            } else {
                throw new VersionAlreadyExistsException(entity.globalId);
            }
            return null;
        });
    }

    @Override
    public void importContent(ContentEntity entity) {
        this.handles.withHandleNoException(handle -> {
            if (this.isContentExistsRaw(handle, entity.contentId)) {
                throw new ContentAlreadyExistsException(entity.contentId);
            }
            ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.importContent()).bind(0, entity.contentId)).bind(1, entity.canonicalHash)).bind(2, entity.contentHash)).bind(3, entity.contentType)).bind(4, entity.contentBytes)).bind(5, entity.serializedReferences)).execute();
            this.insertReferencesRaw(handle, entity.contentId, RegistryContentUtils.deserializeReferences(entity.serializedReferences));
            return null;
        });
    }

    @Override
    public void importGlobalRule(GlobalRuleEntity entity) {
        this.handles.withHandleNoException(handle -> {
            ((Update)((Update)handle.createUpdate(this.sqlStatements.importGlobalRule()).bind(0, entity.ruleType.name())).bind(1, entity.configuration)).execute();
            return null;
        });
    }

    @Override
    public void importGroup(GroupEntity entity) {
        this.handles.withHandleNoException(handle -> {
            if (this.isGroupExistsRaw(handle, entity.groupId)) {
                throw new GroupAlreadyExistsException(entity.groupId);
            }
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.importGroup()).bind(0, RegistryContentUtils.normalizeGroupId(entity.groupId))).bind(1, entity.description)).bind(2, entity.artifactsType)).bind(3, entity.owner)).bind(4, new Date(entity.createdOn))).bind(5, entity.modifiedBy)).bind(6, new Date(entity.modifiedOn))).bind(7, RegistryContentUtils.serializeLabels(entity.labels))).execute();
            if (entity.labels != null && !entity.labels.isEmpty()) {
                entity.labels.forEach((k, v) -> ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertGroupLabel()).bind(0, RegistryContentUtils.normalizeGroupId(entity.groupId))).bind(1, k.toLowerCase())).bind(2, v.toLowerCase())).execute());
            }
            return null;
        });
    }

    @Override
    public void importComment(CommentEntity entity) {
        this.handles.withHandleNoException(handle -> {
            ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertVersionComment()).bind(0, entity.commentId)).bind(1, entity.globalId)).bind(2, entity.owner)).bind(3, new Date(entity.createdOn))).bind(4, entity.value)).execute();
            return null;
        });
    }

    @Override
    public boolean isEmpty() {
        return this.handles.withHandle(handle -> handle.createQuery(this.sqlStatements.selectAllContentCount()).mapTo(Long.class).one() == 0L);
    }

    private boolean isContentExistsRaw(Handle handle, long contentId) {
        return ((Query)handle.createQuery(this.sqlStatements().selectContentExists()).bind(0, contentId)).mapTo(Integer.class).one() > 0;
    }

    private boolean isGlobalIdExistsRaw(Handle handle, long globalId) {
        return ((Query)handle.createQuery(this.sqlStatements().selectGlobalIdExists()).bind(0, globalId)).mapTo(Integer.class).one() > 0;
    }

    @Override
    public long nextContentId() {
        return this.handles.withHandleNoException(this::nextContentIdRaw);
    }

    private long nextContentIdRaw(Handle handle) {
        return this.nextSequenceValueRaw(handle, CONTENT_ID_SEQUENCE);
    }

    @Override
    public long nextGlobalId() {
        return this.handles.withHandleNoException(this::nextGlobalIdRaw);
    }

    private long nextGlobalIdRaw(Handle handle) {
        return this.nextSequenceValueRaw(handle, GLOBAL_ID_SEQUENCE);
    }

    @Override
    public long nextCommentId() {
        return this.handles.withHandleNoException(this::nextCommentIdRaw);
    }

    private long nextCommentIdRaw(Handle handle) {
        return this.nextSequenceValueRaw(handle, COMMENT_ID_SEQUENCE);
    }

    private long nextSequenceValueRaw(Handle handle, String sequenceName) {
        if (this.isH2()) {
            return sequenceCounters.get(sequenceName).incrementAndGet();
        }
        return ((Query)handle.createQuery(this.sqlStatements.getNextSequenceValue()).bind(0, sequenceName)).mapTo(Long.class).one();
    }

    @Override
    public boolean isContentExists(String contentHash) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> ((Query)handle.createQuery(this.sqlStatements().selectContentCountByHash()).bind(0, contentHash)).mapTo(Integer.class).one() > 0);
    }

    @Override
    public boolean isArtifactRuleExists(String groupId, String artifactId, RuleType rule) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> ((Query)((Query)((Query)handle.createQuery(this.sqlStatements().selectArtifactRuleCountByType()).bind(0, RegistryContentUtils.normalizeGroupId(groupId))).bind(1, artifactId)).bind(2, rule.name())).mapTo(Integer.class).one() > 0);
    }

    @Override
    public boolean isGlobalRuleExists(RuleType rule) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> ((Query)handle.createQuery(this.sqlStatements().selectGlobalRuleCountByType()).bind(0, rule.name())).mapTo(Integer.class).one() > 0);
    }

    @Override
    public boolean isRoleMappingExists(String principalId) {
        return this.handles.withHandleNoException(handle -> ((Query)handle.createQuery(this.sqlStatements().selectRoleMappingCountByPrincipal()).bind(0, principalId)).mapTo(Integer.class).one() > 0);
    }

    @Override
    public void updateContentCanonicalHash(String newCanonicalHash, long contentId, String contentHash) {
        this.handles.withHandleNoException(handle -> {
            int rowCount = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements().updateContentCanonicalHash()).bind(0, newCanonicalHash)).bind(1, contentId)).bind(2, contentHash)).execute();
            if (rowCount == 0) {
                this.log.warn("update content canonicalHash, no row match contentId {} contentHash {}", (Object)contentId, (Object)contentHash);
            }
            return null;
        });
    }

    @Override
    public Optional<Long> contentIdFromHash(String contentHash) {
        return this.handles.withHandleNoException(handle -> this.contentIdFromHashRaw(handle, contentHash));
    }

    private Optional<Long> contentIdFromHashRaw(Handle handle, String contentHash) {
        return ((Query)handle.createQuery(this.sqlStatements().selectContentIdByHash()).bind(0, contentHash)).mapTo(Long.class).findOne();
    }

    @Override
    public BranchMetaDataDto createBranch(GA ga, BranchId branchId, String description, List<String> versions) {
        try {
            String user = this.securityIdentity.getPrincipal().getName();
            Date now = new Date();
            this.handles.withHandle(handle -> {
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertBranch()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).bind(3, description)).bind(4, false)).bind(5, user)).bind(6, now)).bind(7, user)).bind(8, now)).execute();
                if (versions != null) {
                    versions.forEach(version -> this.appendVersionToBranchRaw(handle, ga, branchId, new VersionId((String)version)));
                }
                return null;
            });
            return BranchMetaDataDto.builder().groupId(ga.getRawGroupIdWithNull()).artifactId(ga.getRawArtifactId()).branchId(branchId.getRawBranchId()).description(description).owner(user).createdOn(now.getTime()).modifiedBy(user).modifiedOn(now.getTime()).build();
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new BranchAlreadyExistsException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), branchId.getRawBranchId());
            }
            throw ex;
        }
    }

    @Override
    public void updateBranchMetaData(GA ga, BranchId branchId, EditableBranchMetaDataDto dto) {
        BranchMetaDataDto bmd = this.getBranchMetaData(ga, branchId);
        if (bmd.isSystemDefined()) {
            throw new NotAllowedException("System generated branches cannot be modified.");
        }
        String modifiedBy = this.securityIdentity.getPrincipal().getName();
        Date modifiedOn = new Date();
        this.log.debug("Updating metadata for branch {} of {}/{}.", new Object[]{branchId, ga.getRawGroupIdWithNull(), ga.getRawArtifactId()});
        this.handles.withHandleNoException(handle -> {
            int rows = ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateBranch()).bind(0, dto.getDescription())).bind(1, modifiedBy)).bind(2, modifiedOn)).bind(3, ga.getRawGroupId())).bind(4, ga.getRawArtifactId())).bind(5, branchId.getRawBranchId())).execute();
            if (rows == 0) {
                throw new BranchNotFoundException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), branchId.getRawBranchId());
            }
            this.updateBranchModifiedTimeRaw(handle, ga, branchId);
            return null;
        });
    }

    @Override
    public BranchSearchResultsDto getBranches(GA ga, int offset, int limit) {
        return this.handles.withHandleNoException(handle -> {
            LinkedList<SqlStatementVariableBinder> binders = new LinkedList<SqlStatementVariableBinder>();
            StringBuilder selectTemplate = new StringBuilder();
            StringBuilder where = new StringBuilder();
            StringBuilder orderByQuery = new StringBuilder();
            StringBuilder limitOffset = new StringBuilder();
            selectTemplate.append("SELECT {{selectColumns}} FROM branches b ");
            where.append(" WHERE b.groupId = ? AND b.artifactId = ?");
            binders.add((query, idx) -> query.bind(idx, ga.getRawGroupId()));
            binders.add((query, idx) -> query.bind(idx, ga.getRawArtifactId()));
            orderByQuery.append(" ORDER BY b.branchId ASC");
            if ("mssql".equals(this.sqlStatements.dbType())) {
                limitOffset.append(" OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
            } else {
                limitOffset.append(" LIMIT ? OFFSET ?");
            }
            String branchesQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).append((CharSequence)orderByQuery).append((CharSequence)limitOffset).toString().replace("{{selectColumns}}", "*");
            Query branchesQuery = handle.createQuery(branchesQuerySql);
            String countQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).toString().replace("{{selectColumns}}", "count(b.branchId)");
            Query countQuery = handle.createQuery(countQuerySql);
            int idx2 = 0;
            for (SqlStatementVariableBinder binder : binders) {
                binder.bind(branchesQuery, idx2);
                binder.bind(countQuery, idx2);
                ++idx2;
            }
            if ("mssql".equals(this.sqlStatements.dbType())) {
                branchesQuery.bind(idx2++, offset);
                branchesQuery.bind(idx2++, limit);
            } else {
                branchesQuery.bind(idx2++, limit);
                branchesQuery.bind(idx2++, offset);
            }
            List<SearchedBranchDto> branches = branchesQuery.map(SearchedBranchMapper.instance).list();
            Integer count = countQuery.mapTo(Integer.class).one();
            this.getArtifactMetaDataRaw(handle, ga.getRawGroupIdWithNull(), ga.getRawArtifactId());
            BranchSearchResultsDto results = new BranchSearchResultsDto();
            results.setBranches(branches);
            results.setCount(count);
            return results;
        });
    }

    @Override
    public BranchMetaDataDto getBranchMetaData(GA ga, BranchId branchId) {
        return this.handles.withHandle(handle -> {
            Optional<BranchMetaDataDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectBranch()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).map(BranchMetaDataDtoMapper.instance).findOne();
            return res.orElseThrow(() -> new BranchNotFoundException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), branchId.getRawBranchId()));
        });
    }

    private List<String> getBranchVersionNumbersRaw(Handle handle, GA ga, BranchId branchId) {
        return ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectBranchVersionNumbers()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).map(StringMapper.instance).list();
    }

    @Override
    public VersionSearchResultsDto getBranchVersions(GA ga, BranchId branchId, int offset, int limit) {
        return this.handles.withHandleNoException(handle -> {
            LinkedList<SqlStatementVariableBinder> binders = new LinkedList<SqlStatementVariableBinder>();
            StringBuilder selectTemplate = new StringBuilder();
            StringBuilder where = new StringBuilder();
            StringBuilder orderByQuery = new StringBuilder();
            StringBuilder limitOffset = new StringBuilder();
            selectTemplate.append("SELECT {{selectColumns}} FROM branch_versions bv JOIN versions v ON bv.groupId = v.groupId AND bv.artifactId = v.artifactId AND bv.version = v.version JOIN artifacts a ON a.groupId = v.groupId AND a.artifactId = v.artifactId ");
            where.append(" WHERE bv.groupId = ? AND bv.artifactId = ? AND bv.branchId = ?");
            binders.add((query, idx) -> query.bind(idx, ga.getRawGroupId()));
            binders.add((query, idx) -> query.bind(idx, ga.getRawArtifactId()));
            binders.add((query, idx) -> query.bind(idx, branchId.getRawBranchId()));
            orderByQuery.append(" ORDER BY bv.branchOrder DESC");
            if ("mssql".equals(this.sqlStatements.dbType())) {
                limitOffset.append(" OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
            } else {
                limitOffset.append(" LIMIT ? OFFSET ?");
            }
            String versionsQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).append((CharSequence)orderByQuery).append((CharSequence)limitOffset).toString().replace("{{selectColumns}}", "v.*, a.type");
            Query versionsQuery = handle.createQuery(versionsQuerySql);
            String countQuerySql = new StringBuilder(selectTemplate).append((CharSequence)where).toString().replace("{{selectColumns}}", "count(v.globalId)");
            Query countQuery = handle.createQuery(countQuerySql);
            int idx2 = 0;
            for (SqlStatementVariableBinder binder : binders) {
                binder.bind(versionsQuery, idx2);
                binder.bind(countQuery, idx2);
                ++idx2;
            }
            if ("mssql".equals(this.sqlStatements.dbType())) {
                versionsQuery.bind(idx2++, offset);
                versionsQuery.bind(idx2, limit);
            } else {
                versionsQuery.bind(idx2++, limit);
                versionsQuery.bind(idx2, offset);
            }
            List<SearchedVersionDto> versions = versionsQuery.map(SearchedVersionMapper.instance).list();
            Integer count = countQuery.mapTo(Integer.class).one();
            VersionSearchResultsDto results = new VersionSearchResultsDto();
            results.setVersions(versions);
            results.setCount(count.intValue());
            return results;
        });
    }

    @Override
    public void appendVersionToBranch(GA ga, BranchId branchId, VersionId version) {
        BranchMetaDataDto bmd = this.getBranchMetaData(ga, branchId);
        if (bmd.isSystemDefined()) {
            throw new NotAllowedException("System generated branches cannot be modified.");
        }
        try {
            this.handles.withHandle(handle -> {
                this.appendVersionToBranchRaw(handle, ga, branchId, version);
                this.updateBranchModifiedTimeRaw(handle, ga, branchId);
                return null;
            });
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new VersionAlreadyExistsOnBranchException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), version.getRawVersionId(), branchId.getRawBranchId());
            }
            throw ex;
        }
    }

    private void appendVersionToBranchRaw(Handle handle, GA ga, BranchId branchId, VersionId version) {
        try {
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.appendBranchVersion()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).bind(3, version.getRawVersionId())).bind(4, ga.getRawGroupId())).bind(5, ga.getRawArtifactId())).bind(6, branchId.getRawBranchId())).execute();
        }
        catch (Exception ex) {
            if (this.sqlStatements.isPrimaryKeyViolation(ex)) {
                throw new VersionAlreadyExistsOnBranchException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), version.getRawVersionId(), branchId.getRawBranchId());
            }
            if (this.sqlStatements.isForeignKeyViolation(ex)) {
                throw new VersionNotFoundException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), version.getRawVersionId());
            }
            throw ex;
        }
    }

    @Override
    public void replaceBranchVersions(GA ga, BranchId branchId, List<VersionId> versions) {
        BranchMetaDataDto bmd = this.getBranchMetaData(ga, branchId);
        if (bmd.isSystemDefined()) {
            throw new NotAllowedException("System generated branches cannot be modified.");
        }
        this.handles.withHandle(handle -> {
            ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.deleteBranchVersions()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).execute();
            int branchOrder = 0;
            for (VersionId version : versions) {
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertBranchVersion()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).bind(3, branchOrder++)).bind(4, version.getRawVersionId())).execute();
            }
            this.updateBranchModifiedTimeRaw(handle, ga, branchId);
            return null;
        });
    }

    private void createOrUpdateBranchRaw(Handle handle, GAV gav, BranchId branchId, boolean systemDefined) {
        block2: {
            try {
                String user = this.securityIdentity.getPrincipal().getName();
                Date now = new Date();
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.upsertBranch()).bind(0, gav.getRawGroupId())).bind(1, gav.getRawArtifactId())).bind(2, branchId.getRawBranchId())).bind(3, (String)null)).bind(4, systemDefined)).bind(5, user)).bind(6, now)).bind(7, user)).bind(8, now)).execute();
            }
            catch (Exception ex) {
                if (this.sqlStatements.isPrimaryKeyViolation(ex)) break block2;
                throw ex;
            }
        }
        this.appendVersionToBranchRaw(handle, gav, branchId, gav.getVersionId());
    }

    private void updateBranchModifiedTimeRaw(Handle handle, GA ga, BranchId branchId) {
        String user = this.securityIdentity.getPrincipal().getName();
        Date now = new Date();
        ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.updateBranchModifiedTime()).bind(0, user)).bind(1, now)).bind(2, ga.getRawGroupId())).bind(3, ga.getRawArtifactId())).bind(4, branchId.getRawBranchId())).execute();
    }

    @Override
    public GAV getBranchTip(GA ga, BranchId branchId, RegistryStorage.RetrievalBehavior behavior) {
        return this.handles.withHandleNoException(handle -> {
            switch (behavior) {
                case DEFAULT: {
                    return ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectBranchTip()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).map(GAVMapper.instance).findOne().orElseThrow(() -> new VersionNotFoundException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), "<tip of the branch '" + branchId.getRawBranchId() + "'>"));
                }
                case SKIP_DISABLED_LATEST: {
                    return ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectBranchTipNotDisabled()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).map(GAVMapper.instance).findOne().orElseThrow(() -> new VersionNotFoundException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), "<tip of the branch '" + branchId.getRawBranchId() + "' that does not have disabled status>"));
                }
            }
            throw new UnreachableCodeException();
        });
    }

    private GAV getGAVByGlobalIdRaw(Handle handle, long globalId) {
        return ((Query)handle.createQuery(this.sqlStatements.selectGAVByGlobalId()).bind(0, globalId)).map(GAVMapper.instance).findOne().orElseThrow(() -> new VersionNotFoundException(globalId));
    }

    @Override
    public void deleteBranch(GA ga, BranchId branchId) {
        BranchMetaDataDto bmd = this.getBranchMetaData(ga, branchId);
        if (bmd.isSystemDefined()) {
            throw new NotAllowedException("System generated branches cannot be deleted.");
        }
        this.handles.withHandleNoException(handle -> {
            int affected = ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.deleteBranch()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).execute();
            if (affected == 0) {
                throw new BranchNotFoundException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId(), branchId.getRawBranchId());
            }
        });
    }

    @Override
    public void importBranch(BranchEntity entity) {
        GA ga = entity.toGA();
        BranchId branchId = entity.toBranchId();
        this.handles.withHandleNoException(handle -> {
            if (!this.isArtifactExistsRaw(handle, entity.groupId, entity.artifactId)) {
                throw new ArtifactNotFoundException(ga.getRawGroupIdWithDefaultString(), ga.getRawArtifactId());
            }
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.importBranch()).bind(0, ga.getRawGroupId())).bind(1, ga.getRawArtifactId())).bind(2, branchId.getRawBranchId())).bind(3, entity.description)).bind(4, entity.systemDefined)).bind(5, entity.owner)).bind(6, new Date(entity.createdOn))).bind(7, entity.modifiedBy)).bind(8, new Date(entity.modifiedOn))).execute();
            if (entity.versions != null) {
                entity.versions.forEach(version -> this.appendVersionToBranchRaw(handle, ga, branchId, new VersionId((String)version)));
            }
        });
    }

    @Override
    public String triggerSnapshotCreation() throws RegistryStorageException {
        throw new RegistryStorageException("Directly triggering the snapshot creation is not supported for sql storages.");
    }

    @Override
    public String createSnapshot(String location) throws RegistryStorageException {
        if (!StringUtil.isEmpty(location)) {
            this.log.debug("Creating internal database snapshot to location {}.", (Object)location);
            this.handles.withHandleNoException(handle -> ((Query)handle.createQuery(this.sqlStatements.createDataSnapshot()).bind(0, location)).mapTo(String.class).first());
            return location;
        }
        this.log.warn("Skipping database snapshot because no location has been provided");
        return null;
    }

    @Override
    public String createEvent(OutboxEvent event) {
        if (this.supportsDatabaseEvents()) {
            this.handles.withHandle(handle -> {
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.createOutboxEvent()).bind(0, event.getId())).bind(1, this.eventsTopic)).bind(2, event.getAggregateId())).bind(3, event.getType())).bind(4, event.getPayload().toString())).execute();
                return ((Update)handle.createUpdate(this.sqlStatements.deleteOutboxEvent()).bind(0, event.getId())).execute();
            });
        }
        return event.getId();
    }

    @Override
    public boolean supportsDatabaseEvents() {
        return this.isPostgresql() || this.isMssql();
    }

    private boolean isPostgresql() {
        return this.sqlStatements.dbType().equals("postgresql");
    }

    private boolean isMssql() {
        return this.sqlStatements.dbType().equals("mssql");
    }

    private boolean isH2() {
        return this.sqlStatements.dbType().equals("h2");
    }

    private static /* synthetic */ Long lambda$resetSequenceRaw$144(Optional currentIdSeq, Long maxIdTableValue) {
        if (currentIdSeq.isPresent() && (Long)currentIdSeq.get() > maxIdTableValue) {
            return (Long)currentIdSeq.get();
        }
        return maxIdTableValue;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
        sequenceCounters = new HashMap<String, AtomicLong>();
        sequenceCounters.put(GLOBAL_ID_SEQUENCE, new AtomicLong(0L));
        sequenceCounters.put(CONTENT_ID_SEQUENCE, new AtomicLong(0L));
        sequenceCounters.put(COMMENT_ID_SEQUENCE, new AtomicLong(0L));
    }
}

