/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.DdlParser;
import io.apicurio.registry.storage.impl.sql.SqlStatements;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonSqlStatements
implements SqlStatements {
    @Override
    public List<String> databaseInitialization() {
        List<String> list;
        block9: {
            DdlParser parser = new DdlParser();
            InputStream input = this.getClass().getResourceAsStream(this.dbType() + ".ddl");
            try {
                if (input == null) {
                    throw new RuntimeException("DDL not found for dbtype: " + this.dbType());
                }
                list = parser.parse(input);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return list;
    }

    @Override
    public List<String> databaseUpgrade(int fromVersion, int toVersion) {
        ArrayList<String> statements = new ArrayList<String>();
        DdlParser parser = new DdlParser();
        for (int version = fromVersion + 1; version <= toVersion; ++version) {
            try (InputStream input = this.getClass().getResourceAsStream("upgrades/" + version + "/" + this.dbType() + ".upgrade.ddl");){
                statements.addAll(parser.parse(input));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return statements;
    }

    @Override
    public String getDatabaseVersion() {
        return "SELECT a.propValue FROM apicurio a WHERE a.propName = ?";
    }

    @Override
    public String insertGlobalRule() {
        return "INSERT INTO global_rules (type, configuration) VALUES (?, ?)";
    }

    @Override
    public String selectGlobalRules() {
        return "SELECT r.type FROM global_rules r ";
    }

    @Override
    public String selectGlobalRuleByType() {
        return "SELECT r.* FROM global_rules r WHERE r.type = ?";
    }

    @Override
    public String deleteGlobalRule() {
        return "DELETE FROM global_rules WHERE type = ?";
    }

    @Override
    public String deleteGlobalRules() {
        return "DELETE FROM global_rules";
    }

    @Override
    public String updateGlobalRule() {
        return "UPDATE global_rules SET configuration = ? WHERE type = ?";
    }

    @Override
    public String insertArtifact() {
        return "INSERT INTO artifacts (groupId, artifactId, type, owner, createdOn, modifiedBy, modifiedOn, name, description, labels) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String autoUpdateVersionForGlobalId() {
        return "UPDATE versions SET version = versionOrder WHERE globalId = ?";
    }

    @Override
    public String insertVersion(boolean firstVersion) {
        String query = firstVersion ? "INSERT INTO versions (globalId, groupId, artifactId, version, versionOrder, state, name, description, owner, createdOn, modifiedBy, modifiedOn, labels, contentId) VALUES (?, ?, ?, ?, 1, ?, ?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO versions (globalId, groupId, artifactId, version, versionOrder, state, name, description, owner, createdOn, modifiedBy, modifiedOn, labels, contentId) VALUES (?, ?, ?, ?, (SELECT MAX(versionOrder) + 1 FROM versions WHERE groupId = ? AND artifactId = ?), ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        return query;
    }

    @Override
    public String selectArtifactVersionMetaDataByGlobalId() {
        return "SELECT v.*, a.type FROM versions v JOIN artifacts a ON v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.globalId = ?";
    }

    @Override
    public String selectArtifactVersions() {
        return "SELECT version FROM versions WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String selectArtifactVersionsNotDisabled() {
        return "SELECT version FROM versions WHERE groupId = ? AND artifactId = ? AND state != 'DISABLED'";
    }

    @Override
    public String selectArtifactVersionMetaData() {
        return "SELECT v.*, a.type FROM versions v JOIN artifacts a ON v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.groupId = ? AND v.artifactId = ? AND v.version = ?";
    }

    @Override
    public String selectArtifactVersionMetaDataByContentHash() {
        return "SELECT v.*, a.type FROM versions v JOIN content c ON v.contentId = c.contentId JOIN artifacts a ON v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.groupId = ? AND v.artifactId = ? AND c.contentHash = ? ORDER BY v.globalId DESC";
    }

    @Override
    public String selectArtifactVersionMetaDataByContentId() {
        return "SELECT a.*, v.contentId, v.globalId, v.version, v.versionOrder, v.state, v.name, v.description, v.labels, v.owner AS modifiedBy, v.createdOn AS modifiedOn FROM versions v JOIN artifacts a ON v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.contentId = ?";
    }

    @Override
    public String selectArtifactVersionMetaDataByCanonicalHash() {
        return "SELECT v.*, a.type FROM versions v JOIN content c ON v.contentId = c.contentId JOIN artifacts a ON v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE v.groupId = ? AND v.artifactId = ? AND c.canonicalHash = ? ORDER BY v.globalId DESC";
    }

    @Override
    public String selectArtifactVersionContentByGlobalId() {
        return "SELECT v.globalId, v.version, v.versionOrder, v.contentId, c.content, c.contentType, c.refs FROM versions v JOIN content c ON v.contentId = c.contentId WHERE v.globalId = ?";
    }

    @Override
    public String selectArtifactVersionContent() {
        return "SELECT v.globalId, v.version, v.versionOrder, c.contentId, c.content, c.contentType, c.refs FROM versions v JOIN content c ON v.contentId = c.contentId WHERE v.groupId = ? AND v.artifactId = ? AND v.version = ?";
    }

    @Override
    public String selectArtifactContentIds() {
        return "SELECT v.contentId FROM versions v WHERE v.groupId = ? AND v.artifactId = ? AND v.state != 'DISABLED' ORDER BY v.versionOrder";
    }

    @Override
    public String selectArtifactMetaData() {
        return "SELECT a.* FROM artifacts a WHERE a.groupId = ? AND a.artifactId = ?";
    }

    @Override
    public String selectContentIdByHash() {
        return "SELECT c.contentId FROM content c WHERE c.contentHash = ?";
    }

    @Override
    public String selectArtifactRules() {
        return "SELECT r.* FROM artifact_rules r WHERE r.groupId = ? AND r.artifactId = ?";
    }

    @Override
    public String insertArtifactRule() {
        return "INSERT INTO artifact_rules (groupId, artifactId, type, configuration) VALUES (?, ?, ?, ?)";
    }

    @Override
    public String selectArtifactRuleByType() {
        return "SELECT r.* FROM artifact_rules r WHERE r.groupId = ? AND r.artifactId = ? AND r.type = ?";
    }

    @Override
    public String updateArtifactRule() {
        return "UPDATE artifact_rules SET configuration = ? WHERE groupId = ? AND artifactId = ? AND type = ?";
    }

    @Override
    public String updateArtifactModifiedByOn() {
        return "UPDATE artifacts SET modifiedBy = ?, modifiedOn = ? WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String updateArtifactOwner() {
        return "UPDATE artifacts SET owner = ? WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String updateArtifactName() {
        return "UPDATE artifacts SET name = ? WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String updateArtifactDescription() {
        return "UPDATE artifacts SET description = ? WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String updateArtifactLabels() {
        return "UPDATE artifacts SET labels = ? WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteArtifactRule() {
        return "DELETE FROM artifact_rules WHERE groupId = ? AND artifactId = ? AND type = ?";
    }

    @Override
    public String deleteArtifactRules() {
        return "DELETE FROM artifact_rules WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteArtifactRulesByGroupId() {
        return "DELETE FROM artifact_rules WHERE groupId = ?";
    }

    @Override
    public String deleteAllArtifactRules() {
        return "DELETE FROM artifact_rules";
    }

    @Override
    public String updateArtifactVersionNameByGAV() {
        return "UPDATE versions SET name = ? WHERE groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String updateArtifactVersionDescriptionByGAV() {
        return "UPDATE versions SET description = ? WHERE groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String updateArtifactVersionOwnerByGAV() {
        return "UPDATE versions SET owner = ? WHERE groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String updateArtifactVersionStateByGAV() {
        return "UPDATE versions SET state = ? WHERE groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String updateArtifactVersionLabelsByGAV() {
        return "UPDATE versions SET labels = ? WHERE groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String updateArtifactVersionState() {
        return "UPDATE versions SET state = ? WHERE globalId = ?";
    }

    @Override
    public String deleteGroupLabelsByGroupId() {
        return "DELETE FROM group_labels WHERE groupId = ?";
    }

    @Override
    public String deleteArtifactLabels() {
        return "DELETE FROM artifact_labels WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteVersionLabelsByGlobalId() {
        return "DELETE FROM version_labels WHERE globalId = ?";
    }

    @Override
    public String deleteVersionLabelsByAll() {
        return "DELETE FROM version_labels WHERE globalId IN (SELECT globalId FROM versions)";
    }

    @Override
    public String deleteAllVersionComments() {
        return "DELETE FROM version_comments WHERE globalId IN (SELECT globalId FROM versions)";
    }

    @Override
    public String deleteAllVersions() {
        return "DELETE FROM versions";
    }

    @Override
    public String deleteArtifact() {
        return "DELETE FROM artifacts WHERE groupId = ? AND artifactId = ?";
    }

    @Override
    public String deleteArtifactsByGroupId() {
        return "DELETE FROM artifacts WHERE groupId = ?";
    }

    @Override
    public String deleteAllArtifacts() {
        return "DELETE FROM artifacts";
    }

    @Override
    public String selectArtifactIds() {
        return "SELECT artifactId FROM artifacts LIMIT ?";
    }

    @Override
    public String deleteVersion() {
        return "DELETE FROM versions WHERE groupId = ? AND artifactId = ? AND version = ?";
    }

    @Override
    public String deleteVersionLabelsByGAV() {
        return "DELETE FROM version_labels WHERE globalId IN (SELECT v.globalId FROM versions v WHERE v.groupId = ? AND v.artifactId = ? AND v.version = ?)";
    }

    @Override
    public String insertVersionLabel() {
        return "INSERT INTO version_labels (globalId, labelKey, labelValue) VALUES (?, ?, ?)";
    }

    @Override
    public String insertArtifactLabel() {
        return "INSERT INTO artifact_labels (groupId, artifactId, labelKey, labelValue) VALUES (?, ?, ?, ?)";
    }

    @Override
    public String insertGroupLabel() {
        return "INSERT INTO group_labels (groupId, labelKey, labelValue) VALUES (?, ?, ?)";
    }

    @Override
    public String selectAllArtifactVersions() {
        return "SELECT v.*, a.type FROM versions v JOIN artifacts a ON a.groupId = v.groupId AND a.artifactId = v.artifactId WHERE a.groupId = ? AND a.artifactId = ?";
    }

    @Override
    public String selectAllArtifactCount() {
        return "SELECT COUNT(a.artifactId) FROM artifacts a ";
    }

    @Override
    public String selectAllContentCount() {
        return "SELECT COUNT(c.contentId) FROM content c ";
    }

    @Override
    public String selectAllArtifactVersionsCount() {
        return "SELECT COUNT(v.globalId) FROM versions v WHERE v.groupId = ? AND v.artifactId = ? ";
    }

    @Override
    public String selectActiveArtifactVersionsCount() {
        return "SELECT COUNT(v.globalId) FROM versions v WHERE v.groupId = ? AND v.artifactId = ? AND v.state != 'DISABLED'";
    }

    @Override
    public String selectTotalArtifactVersionsCount() {
        return "SELECT COUNT(v.globalId) FROM versions v";
    }

    @Override
    public String selectArtifactCountById() {
        return "SELECT COUNT(a.artifactId) FROM artifacts a WHERE a.groupId = ? AND a.artifactId = ?";
    }

    @Override
    public String selectGroupCountById() {
        return "SELECT COUNT(g.groupId) FROM groups g WHERE g.groupId = ?";
    }

    @Override
    public String selectArtifactRuleCountByType() {
        return "SELECT COUNT(r.type) FROM artifact_rules r WHERE r.groupId = ? AND r.artifactId = ? AND r.type = ?";
    }

    @Override
    public String selectGlobalRuleCountByType() {
        return "SELECT COUNT(r.type) FROM global_rules r WHERE r.type = ?";
    }

    @Override
    public String selectContentCountByHash() {
        return "SELECT COUNT(c.contentId) FROM content c WHERE c.contentHash = ? ";
    }

    @Override
    public String selectContentById() {
        return "SELECT c.content, c.contentType, c.refs FROM content c WHERE c.contentId = ?";
    }

    @Override
    public String selectContentByContentHash() {
        return "SELECT c.content, c.contentType, c.refs FROM content c WHERE c.contentHash = ?";
    }

    @Override
    public String deleteAllOrphanedContent() {
        return "DELETE FROM content c WHERE NOT EXISTS (SELECT 1 FROM versions v WHERE v.contentId = c.contentId)";
    }

    @Override
    public String deleteAllContent() {
        return "DELETE FROM content";
    }

    @Override
    public String updateContentCanonicalHash() {
        return "UPDATE content SET canonicalHash = ? WHERE contentId = ? AND contentHash = ?";
    }

    @Override
    public String insertContent() {
        return "INSERT INTO content (contentId, canonicalHash, contentHash, contentType, content, refs) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String insertContentReference() {
        return "INSERT INTO content_references (contentId, groupId, artifactId, version, name) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public String insertGroup() {
        return "INSERT INTO groups (groupId, description, artifactsType, owner, createdOn, modifiedBy, modifiedOn, labels) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String updateGroup() {
        return "UPDATE groups SET description = ? , modifiedBy = ? , modifiedOn = ? , labels = ? WHERE groupId = ?";
    }

    @Override
    public String deleteGroup() {
        return "DELETE FROM groups WHERE groupId = ?";
    }

    @Override
    public String deleteAllGroups() {
        return "DELETE FROM groups ";
    }

    @Override
    public String selectGroups() {
        return "SELECT g.* FROM groups g ORDER BY g.groupId ASC LIMIT ?";
    }

    @Override
    public String selectGroupByGroupId() {
        return "SELECT g.* FROM groups g WHERE g.groupId = ?";
    }

    @Override
    public String exportGroupRules() {
        return "SELECT * FROM group_rules r";
    }

    @Override
    public String exportArtifactRules() {
        return "SELECT * FROM artifact_rules r";
    }

    @Override
    public String exportArtifacts() {
        return "SELECT * FROM artifacts";
    }

    @Override
    public String exportArtifactVersions() {
        return "SELECT * FROM versions";
    }

    @Override
    public String exportVersionComments() {
        return "SELECT * FROM version_comments c ";
    }

    @Override
    public String exportContent() {
        return "SELECT c.contentId, c.canonicalHash, c.contentHash, c.contentType, c.content, c.refs FROM content c ";
    }

    @Override
    public String exportGlobalRules() {
        return "SELECT * FROM global_rules r ";
    }

    @Override
    public String exportGroups() {
        return "SELECT * FROM groups g ";
    }

    @Override
    public String exportBranches() {
        return "SELECT * FROM branches";
    }

    @Override
    public String importArtifactRule() {
        return "INSERT INTO artifact_rules (groupId, artifactId, type, configuration) VALUES (?, ?, ?, ?)";
    }

    @Override
    public String importGroupRule() {
        return "INSERT INTO group_rules (groupId, type, configuration) VALUES (?, ?, ?)";
    }

    @Override
    public String importArtifactVersion() {
        return "INSERT INTO versions (globalId, groupId, artifactId, version, versionOrder, state, name, description, owner, createdOn, modifiedBy, modifiedOn, labels, contentId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String importContent() {
        return "INSERT INTO content (contentId, canonicalHash, contentHash, contentType, content, refs) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String importGlobalRule() {
        return "INSERT INTO global_rules (type, configuration) VALUES (?, ?)";
    }

    @Override
    public String importGroup() {
        return "INSERT INTO groups (groupId, description, artifactsType, owner, createdOn, modifiedBy, modifiedOn, labels) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String selectMaxContentId() {
        return "SELECT MAX(contentId) FROM content ";
    }

    @Override
    public String selectMaxGlobalId() {
        return "SELECT MAX(globalId) FROM versions ";
    }

    @Override
    public String selectMaxVersionCommentId() {
        return "SELECT MAX(commentId) FROM version_comments ";
    }

    @Override
    public String selectContentExists() {
        return "SELECT COUNT(contentId) FROM content WHERE contentId = ? ";
    }

    @Override
    public String selectGlobalIdExists() {
        return "SELECT COUNT(globalId) FROM versions WHERE globalId = ? ";
    }

    @Override
    public String insertRoleMapping() {
        return "INSERT INTO acls (principalId, role, principalName) VALUES (?, ?, ?)";
    }

    @Override
    public String deleteRoleMapping() {
        return "DELETE FROM acls WHERE principalId = ?";
    }

    @Override
    public String deleteAllRoleMappings() {
        return "DELETE FROM acls ";
    }

    @Override
    public String selectRoleMappingByPrincipalId() {
        return "SELECT a.* FROM acls a WHERE a.principalId = ?";
    }

    @Override
    public String selectRoleByPrincipalId() {
        return "SELECT a.role FROM acls a WHERE a.principalId = ?";
    }

    @Override
    public String selectRoleMappings() {
        return "SELECT a.* FROM acls a ";
    }

    @Override
    public String countRoleMappings() {
        return "SELECT count(a.principalId) FROM acls a ";
    }

    @Override
    public String updateRoleMapping() {
        return "UPDATE acls SET role = ? WHERE principalId = ?";
    }

    @Override
    public String selectRoleMappingCountByPrincipal() {
        return "SELECT COUNT(a.principalId) FROM acls a WHERE a.principalId = ?";
    }

    @Override
    public String insertDownload() {
        return "INSERT INTO downloads (downloadId, expires, context) VALUES (?, ?, ?)";
    }

    @Override
    public String selectDownloadContext() {
        return "SELECT d.context FROM downloads d WHERE d.downloadId = ? AND expires > ?";
    }

    @Override
    public String deleteDownload() {
        return "DELETE FROM downloads WHERE downloadId = ?";
    }

    @Override
    public String deleteExpiredDownloads() {
        return "DELETE FROM downloads WHERE expires < ?";
    }

    @Override
    public String selectConfigProperties() {
        return "SELECT c.* FROM config c ";
    }

    @Override
    public String selectConfigPropertyByName() {
        return "SELECT c.* FROM config c WHERE c.propName = ?";
    }

    @Override
    public String deleteConfigProperty() {
        return "DELETE FROM config WHERE propName = ?";
    }

    @Override
    public String insertConfigProperty() {
        return "INSERT INTO config (propName, propValue, modifiedOn) VALUES (?, ?, ?)";
    }

    @Override
    public String deleteAllConfigProperties() {
        return "DELETE FROM config ";
    }

    @Override
    public String selectStaleConfigProperties() {
        return "SELECT * FROM config c WHERE c.modifiedOn >= ?";
    }

    @Override
    public String deleteAllContentReferences() {
        return "DELETE FROM content_references ";
    }

    @Override
    public String deleteOrphanedContentReferences() {
        return "DELETE FROM content_references WHERE NOT EXISTS (SELECT 1 FROM versions v WHERE v.contentId = contentId)";
    }

    @Override
    public String selectContentIdsReferencingArtifactBy() {
        return "SELECT contentId FROM content_references WHERE groupId=? AND artifactId=? AND version=?";
    }

    @Override
    public String selectGlobalIdsReferencingArtifactBy() {
        return "SELECT DISTINCT v.globalId FROM versions v JOIN content_references ar ON v.contentId=ar.contentId WHERE ar.groupId=? AND ar.artifactId=? AND ar.version=?";
    }

    @Override
    public String selectInboundContentReferencesByGAV() {
        return "SELECT DISTINCT v.groupId, v.artifactId, v.version, ar.name as name FROM versions v JOIN content_references ar ON v.contentId=ar.contentId WHERE ar.groupId=? AND ar.artifactId=? AND ar.version=?";
    }

    @Override
    public String insertSequenceValue() {
        return "INSERT INTO sequences (seqName, seqValue) VALUES (?, ?)";
    }

    @Override
    public String selectCurrentSequenceValue() {
        return "SELECT seqValue FROM sequences WHERE seqName = ? ";
    }

    @Override
    public String insertVersionComment() {
        return "INSERT INTO version_comments (commentId, globalId, owner, createdOn, cvalue) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public String selectVersionComments() {
        return "SELECT c.* FROM version_comments c JOIN versions v ON v.globalId = c.globalId WHERE v.groupId = ? AND v.artifactId = ? AND v.version = ? ORDER BY c.createdOn DESC";
    }

    @Override
    public String deleteVersionComment() {
        return "DELETE FROM version_comments WHERE globalId = ? AND commentId = ? AND owner = ?";
    }

    @Override
    public String updateVersionComment() {
        return "UPDATE version_comments SET cvalue = ? WHERE globalId = ? AND commentId = ? AND owner = ?";
    }

    @Override
    public String selectGAVByGlobalId() {
        return "SELECT groupId, artifactId, version FROM versions WHERE globalId = ?";
    }

    @Override
    public String insertBranch() {
        return "INSERT INTO branches (groupId, artifactId, branchId, description, systemDefined, owner, createdOn, modifiedBy, modifiedOn) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
    }

    @Override
    public String upsertBranch() {
        return "INSERT INTO branches (groupId, artifactId, branchId, description, systemDefined, owner, createdOn, modifiedBy, modifiedOn) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
    }

    @Override
    public String importBranch() {
        return "INSERT INTO branches (groupId, artifactId, branchId, description, systemDefined, owner, createdOn, modifiedBy, modifiedOn) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String updateBranch() {
        return "UPDATE branches SET description = ? , modifiedBy = ? , modifiedOn = ? WHERE groupId = ? AND artifactId = ? AND branchId = ?";
    }

    @Override
    public String updateBranchModifiedTime() {
        return "UPDATE branches SET modifiedBy = ? , modifiedOn = ? WHERE groupId = ? AND artifactId = ? AND branchId = ?";
    }

    @Override
    public String selectBranch() {
        return "SELECT b.* FROM branches b WHERE b.groupId = ? AND b.artifactId = ? AND b.branchId = ?";
    }

    @Override
    public String selectBranchVersionNumbers() {
        return "SELECT bv.version FROM branch_versions bv WHERE bv.groupId = ? AND bv.artifactId = ? AND bv.branchId = ?";
    }

    @Override
    public String selectBranchTip() {
        return "SELECT bv.groupId, bv.artifactId, bv.version FROM branch_versions bv WHERE bv.groupId = ? AND bv.artifactId = ? AND bv.branchId = ? ORDER BY bv.branchOrder DESC LIMIT 1";
    }

    @Override
    public String selectBranchTipNotDisabled() {
        return "SELECT bv.groupId, bv.artifactId, bv.version FROM branch_versions bv JOIN versions v ON bv.groupId = v.groupId AND bv.artifactId = v.artifactId AND bv.version = v.version WHERE bv.groupId = ? AND bv.artifactId = ? AND bv.branchId = ? AND v.state != 'DISABLED' ORDER BY bv.branchOrder DESC LIMIT 1";
    }

    @Override
    public String insertBranchVersion() {
        return "INSERT INTO branch_versions (groupId, artifactId, branchId, branchOrder, version) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public String appendBranchVersion() {
        return "INSERT INTO branch_versions (groupId, artifactId, branchId, branchOrder, version) SELECT ?, ?, ?, COALESCE(MAX(bv.branchOrder), 0) + 1, ? FROM branch_versions bv WHERE bv.groupId = ? AND bv.artifactId = ? AND bv.branchId = ?";
    }

    @Override
    public String deleteBranchVersions() {
        return "DELETE FROM branch_versions WHERE groupId = ? AND artifactId = ? AND branchId = ?";
    }

    @Override
    public String deleteBranch() {
        return "DELETE FROM branches WHERE groupId = ? AND artifactId = ? AND branchId = ?";
    }

    @Override
    public String deleteAllBranches() {
        return "DELETE FROM branches";
    }

    @Override
    public String insertGroupRule() {
        return "INSERT INTO group_rules (groupId, type, configuration) VALUES (?, ?, ?)";
    }

    @Override
    public String selectGroupRules() {
        return "SELECT r.* FROM group_rules r WHERE r.groupId = ?";
    }

    @Override
    public String updateGroupRule() {
        return "UPDATE group_rules SET configuration = ? WHERE groupId = ? AND type = ?";
    }

    @Override
    public String selectGroupRuleByType() {
        return "SELECT r.* FROM group_rules r WHERE r.groupId = ? AND r.type = ?";
    }

    @Override
    public String deleteGroupRule() {
        return "DELETE FROM group_rules WHERE groupId = ? AND type = ?";
    }

    @Override
    public String deleteGroupRules() {
        return "DELETE FROM group_rules WHERE groupId = ?";
    }

    @Override
    public String createOutboxEvent() {
        return "INSERT INTO outbox (id, aggregatetype, aggregateid, type, payload) VALUES (?, ?, ?, ?, ?::jsonb)";
    }

    @Override
    public String deleteOutboxEvent() {
        return "DELETE FROM outbox o WHERE o.id= ?";
    }
}

