/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.refs.JsonPointerExternalReference;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.types.RegistryException;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.types.provider.DefaultArtifactTypeUtilProviderImpl;
import io.apicurio.registry.utils.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryContentUtils {
    private static final Logger log = LoggerFactory.getLogger(RegistryContentUtils.class);
    private static final String NULL_GROUP_ID = "__$GROUPID$__";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final ArtifactTypeUtilProviderFactory ARTIFACT_TYPE_UTIL = new DefaultArtifactTypeUtilProviderImpl();

    private RegistryContentUtils() {
    }

    public static Map<String, TypedContent> recursivelyResolveReferences(List<ArtifactReferenceDto> references, Function<ArtifactReferenceDto, ContentWrapperDto> loader) {
        if (references == null || references.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, TypedContent> result = new LinkedHashMap<String, TypedContent>();
        RegistryContentUtils.resolveReferences(result, references, loader);
        return result;
    }

    public static RewrittenContentHolder recursivelyResolveReferencesWithContext(TypedContent mainContent, String mainContentType, List<ArtifactReferenceDto> references, Function<ArtifactReferenceDto, ContentWrapperDto> loader) {
        if (references == null || references.isEmpty()) {
            return new RewrittenContentHolder(mainContent, Collections.emptyMap());
        }
        LinkedHashMap<String, TypedContent> resolvedReferences = new LinkedHashMap<String, TypedContent>();
        return RegistryContentUtils.resolveReferencesWithContext(mainContent, mainContentType, resolvedReferences, references, loader);
    }

    private static RewrittenContentHolder resolveReferencesWithContext(TypedContent mainContent, String schemaType, Map<String, TypedContent> partialRecursivelyResolvedReferences, List<ArtifactReferenceDto> references, Function<ArtifactReferenceDto, ContentWrapperDto> loader) {
        HashMap<String, String> referencesRewrites = new HashMap<String, String>();
        if (references != null && !references.isEmpty()) {
            for (ArtifactReferenceDto reference : references) {
                JsonPointerExternalReference refPointer;
                if (reference.getArtifactId() == null || reference.getName() == null || reference.getVersion() == null) {
                    throw new IllegalStateException("Invalid reference: " + reference);
                }
                String refName = reference.getName();
                String referenceCoordinates = RegistryContentUtils.concatArtifactVersionCoordinatesWithRefName(reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), refName);
                JsonPointerExternalReference coordinatePointer = new JsonPointerExternalReference(referenceCoordinates, (refPointer = new JsonPointerExternalReference(refName)).getComponent());
                String newRefName = coordinatePointer.toString();
                if (partialRecursivelyResolvedReferences.containsKey(newRefName)) continue;
                try {
                    ContentWrapperDto nested = loader.apply(reference);
                    if (nested == null) continue;
                    ArtifactTypeUtilProvider typeUtilProvider = ARTIFACT_TYPE_UTIL.getArtifactTypeProvider(nested.getArtifactType());
                    RewrittenContentHolder rewrittenContentHolder = RegistryContentUtils.resolveReferencesWithContext(TypedContent.create((ContentHandle)nested.getContent(), (String)nested.getArtifactType()), nested.getArtifactType(), partialRecursivelyResolvedReferences, nested.getReferences(), loader);
                    referencesRewrites.put(refName, referenceCoordinates);
                    TypedContent rewrittenContent = typeUtilProvider.getContentDereferencer().rewriteReferences(rewrittenContentHolder.getRewrittenContent(), referencesRewrites);
                    partialRecursivelyResolvedReferences.put(newRefName, rewrittenContent);
                }
                catch (Exception ex) {
                    log.error("Could not resolve reference " + reference + ".", (Throwable)ex);
                }
            }
        }
        ArtifactTypeUtilProvider typeUtilProvider = ARTIFACT_TYPE_UTIL.getArtifactTypeProvider(schemaType);
        TypedContent rewrittenContent = typeUtilProvider.getContentDereferencer().rewriteReferences(mainContent, referencesRewrites);
        return new RewrittenContentHolder(rewrittenContent, partialRecursivelyResolvedReferences);
    }

    private static void resolveReferences(Map<String, TypedContent> partialRecursivelyResolvedReferences, List<ArtifactReferenceDto> references, Function<ArtifactReferenceDto, ContentWrapperDto> loader) {
        if (references != null && !references.isEmpty()) {
            for (ArtifactReferenceDto reference : references) {
                if (reference.getArtifactId() == null || reference.getName() == null || reference.getVersion() == null) {
                    throw new IllegalStateException("Invalid reference: " + reference);
                }
                if (partialRecursivelyResolvedReferences.containsKey(reference.getName())) continue;
                try {
                    ContentWrapperDto nested = loader.apply(reference);
                    if (nested == null) continue;
                    RegistryContentUtils.resolveReferences(partialRecursivelyResolvedReferences, nested.getReferences(), loader);
                    partialRecursivelyResolvedReferences.put(reference.getName(), TypedContent.create((ContentHandle)nested.getContent(), (String)nested.getArtifactType()));
                }
                catch (Exception ex) {
                    log.error("Could not resolve reference " + reference + ".", (Throwable)ex);
                }
            }
        }
    }

    private static TypedContent canonicalizeContent(String artifactType, TypedContent content, Map<String, TypedContent> recursivelyResolvedReferences) {
        try {
            return ARTIFACT_TYPE_UTIL.getArtifactTypeProvider(artifactType).getContentCanonicalizer().canonicalize(content, recursivelyResolvedReferences);
        }
        catch (Exception ex) {
            log.debug("Failed to canonicalize content: {}", (Object)content.getContent());
            return content;
        }
    }

    public static TypedContent canonicalizeContent(String artifactType, ContentWrapperDto data, Function<ArtifactReferenceDto, ContentWrapperDto> loader) {
        try {
            return RegistryContentUtils.canonicalizeContent(artifactType, TypedContent.create((ContentHandle)data.getContent(), (String)data.getArtifactType()), RegistryContentUtils.recursivelyResolveReferences(data.getReferences(), loader));
        }
        catch (Exception ex) {
            throw new RegistryException("Failed to canonicalize content.", ex);
        }
    }

    public static String canonicalContentHash(String artifactType, ContentWrapperDto data, Function<ArtifactReferenceDto, ContentWrapperDto> loader) {
        try {
            if (RegistryContentUtils.notEmpty(data.getReferences())) {
                String serializedReferences = RegistryContentUtils.serializeReferences(data.getReferences());
                TypedContent canonicalContent = RegistryContentUtils.canonicalizeContent(artifactType, data, loader);
                return DigestUtils.sha256Hex((byte[])RegistryContentUtils.concatContentAndReferences(canonicalContent.getContent().bytes(), serializedReferences));
            }
            TypedContent canonicalContent = RegistryContentUtils.canonicalizeContent(artifactType, TypedContent.create((ContentHandle)data.getContent(), (String)data.getArtifactType()), Map.of());
            return DigestUtils.sha256Hex((byte[])canonicalContent.getContent().bytes());
        }
        catch (IOException ex) {
            throw new RegistryException("Failed to compute canonical content hash.", ex);
        }
    }

    public static String contentHash(ContentWrapperDto data) {
        try {
            if (RegistryContentUtils.notEmpty(data.getReferences())) {
                String serializedReferences = RegistryContentUtils.serializeReferences(data.getReferences());
                return DigestUtils.sha256Hex((byte[])RegistryContentUtils.concatContentAndReferences(data.getContent().bytes(), serializedReferences));
            }
            return data.getContent().getSha256Hash();
        }
        catch (IOException ex) {
            throw new RegistryException("Failed to compute content hash.", ex);
        }
    }

    private static byte[] concatContentAndReferences(byte[] contentBytes, String serializedReferences) throws IOException {
        if (serializedReferences != null && !serializedReferences.isEmpty()) {
            byte[] serializedReferencesBytes = ContentHandle.create((String)serializedReferences).bytes();
            ByteBuffer bytes = ByteBuffer.allocate(contentBytes.length + serializedReferencesBytes.length);
            bytes.put(contentBytes);
            bytes.put(serializedReferencesBytes);
            return bytes.array();
        }
        throw new IllegalArgumentException("serializedReferences is null or empty");
    }

    public static String serializeLabels(Map<String, String> labels) {
        try {
            if (labels == null) {
                return null;
            }
            if (labels.isEmpty()) {
                return null;
            }
            return MAPPER.writeValueAsString(labels);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> deserializeLabels(String labelsStr) {
        try {
            if (StringUtil.isEmpty(labelsStr)) {
                return null;
            }
            return (Map)MAPPER.readValue(labelsStr, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String serializeReferences(List<ArtifactReferenceDto> references) {
        try {
            if (references == null || references.isEmpty()) {
                return null;
            }
            return MAPPER.writeValueAsString(references);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<ArtifactReferenceDto> deserializeReferences(String references) {
        try {
            if (StringUtil.isEmpty(references)) {
                return Collections.emptyList();
            }
            return (List)MAPPER.readValue(references, (TypeReference)new TypeReference<List<ArtifactReferenceDto>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String normalizeGroupId(String groupId) {
        if (groupId == null || "default".equals(groupId)) {
            return NULL_GROUP_ID;
        }
        return groupId;
    }

    public static String denormalizeGroupId(String groupId) {
        if (NULL_GROUP_ID.equals(groupId)) {
            return null;
        }
        return groupId;
    }

    public static boolean notEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static String concatArtifactVersionCoordinatesWithRefName(String groupId, String artifactId, String version, String referenceName) {
        return groupId + ":" + artifactId + ":" + version + ":" + referenceName;
    }

    public static class RewrittenContentHolder {
        final TypedContent rewrittenContent;
        final Map<String, TypedContent> resolvedReferences;

        public RewrittenContentHolder(TypedContent rewrittenContent, Map<String, TypedContent> resolvedReferences) {
            this.rewrittenContent = rewrittenContent;
            this.resolvedReferences = resolvedReferences;
        }

        public TypedContent getRewrittenContent() {
            return this.rewrittenContent;
        }

        public Map<String, TypedContent> getResolvedReferences() {
            return this.resolvedReferences;
        }
    }
}

