/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalPropertiesReader;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.storage.impl.sql.RegistryDatabaseKind;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Produces;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

public class RegistryDatasourceProducer {
    @Inject
    Logger log;
    @ConfigProperty(name="apicurio.storage.sql.kind", defaultValue="h2")
    @Info(category="storage", description="Application datasource database type", availableSince="3.0.0.Final")
    String databaseType;
    @ConfigProperty(name="apicurio.datasource.url", defaultValue="jdbc:h2:mem:registry_db")
    @Info(category="storage", description="Application datasource jdbc url", availableSince="3.0.0.Final")
    String jdbcUrl;
    @ConfigProperty(name="apicurio.datasource.username", defaultValue="sa")
    @Info(category="storage", description="Application datasource username", availableSince="3.0.0.Final")
    String username;
    @ConfigProperty(name="apicurio.datasource.password", defaultValue="sa")
    @Info(category="storage", description="Application datasource password", availableSince="3.0.0.Final")
    String password;
    @ConfigProperty(name="apicurio.datasource.jdbc.initial-size", defaultValue="20")
    @Info(category="storage", description="Application datasource pool initial size", availableSince="3.0.0.Final")
    String initialSize;
    @ConfigProperty(name="apicurio.datasource.jdbc.min-size", defaultValue="20")
    @Info(category="storage", description="Application datasource pool minimum size", availableSince="3.0.0.Final")
    String minSize;
    @ConfigProperty(name="apicurio.datasource.jdbc.max-size", defaultValue="100")
    @Info(category="storage", description="Application datasource pool maximum size", availableSince="3.0.0.Final")
    String maxSize;

    @Produces
    @ApplicationScoped
    @Named(value="application")
    public AgroalDataSource produceDatasource() throws SQLException {
        this.log.debug("Creating an instance of ISqlStatements for DB: " + this.databaseType);
        RegistryDatabaseKind databaseKind = RegistryDatabaseKind.valueOf(this.databaseType);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("maxSize", this.maxSize);
        props.put("minSize", this.minSize);
        props.put("initialSize", this.initialSize);
        props.put("jdbcUrl", this.jdbcUrl);
        props.put("principal", this.username);
        props.put("credential", this.password);
        props.put("providerClassName", databaseKind.getDriverClassName());
        props.put("autoCommit", "false");
        props.put("jdbcTransactionIsolation", AgroalConnectionFactoryConfiguration.TransactionIsolation.READ_COMMITTED.name());
        props.put("transactionRequirement", AgroalConnectionPoolConfiguration.TransactionRequirement.WARN.name());
        props.put("flushOnClose", "true");
        AgroalDataSource datasource = AgroalDataSource.from((AgroalDataSourceConfiguration)new AgroalPropertiesReader().readProperties(props).get(), (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
        this.log.info("Using {} SQL storage.", (Object)this.databaseType);
        return datasource;
    }
}

