/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.types.RegistryException;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.ArtifactTypeUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryStorageContentUtils {
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    Logger log;

    public TypedContent canonicalizeContent(String artifactType, TypedContent content, Map<String, TypedContent> resolvedReferences) {
        try {
            return this.factory.getArtifactTypeProvider(artifactType).getContentCanonicalizer().canonicalize(content, resolvedReferences);
        }
        catch (Exception ex) {
            this.log.debug("Failed to canonicalize content: {}", (Object)artifactType);
            return content;
        }
    }

    public TypedContent canonicalizeContent(String artifactType, TypedContent content, List<ArtifactReferenceDto> references, Function<List<ArtifactReferenceDto>, Map<String, TypedContent>> referenceResolver) {
        try {
            return this.canonicalizeContent(artifactType, content, referenceResolver.apply(references));
        }
        catch (Exception ex) {
            throw new RegistryException("Failed to canonicalize content.", ex);
        }
    }

    public String getCanonicalContentHash(TypedContent content, String artifactType, List<ArtifactReferenceDto> references, Function<List<ArtifactReferenceDto>, Map<String, TypedContent>> referenceResolver) {
        try {
            if (RegistryStorageContentUtils.notEmpty(references)) {
                String referencesSerialized = RegistryContentUtils.serializeReferences(references);
                TypedContent canonicalContent = this.canonicalizeContent(artifactType, content, referenceResolver.apply(references));
                return DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(canonicalContent.getContent().bytes(), referencesSerialized));
            }
            TypedContent canonicalContent = this.canonicalizeContent(artifactType, content, Map.of());
            return DigestUtils.sha256Hex((byte[])canonicalContent.getContent().bytes());
        }
        catch (IOException ex) {
            throw new RegistryException("Failed to compute canonical content hash.", ex);
        }
    }

    public String getContentHash(TypedContent content, List<ArtifactReferenceDto> references) {
        try {
            if (RegistryStorageContentUtils.notEmpty(references)) {
                String referencesSerialized = RegistryContentUtils.serializeReferences(references);
                return DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(content.getContent().bytes(), referencesSerialized));
            }
            return DigestUtils.sha256Hex((byte[])content.getContent().bytes());
        }
        catch (IOException ex) {
            throw new RegistryException("Failed to compute content hash.", ex);
        }
    }

    private byte[] concatContentAndReferences(byte[] contentBytes, String references) throws IOException {
        if (references != null && !references.isEmpty()) {
            byte[] referencesBytes = ContentHandle.create((String)references).bytes();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(contentBytes.length + referencesBytes.length);
            outputStream.write(contentBytes);
            outputStream.write(referencesBytes);
            return outputStream.toByteArray();
        }
        throw new IllegalArgumentException("references");
    }

    public String determineArtifactType(TypedContent content, String artifactTypeHint) {
        return ArtifactTypeUtil.determineArtifactType(content, artifactTypeHint, null, this.factory);
    }

    public String determineArtifactType(TypedContent content, String artifactTypeHint, Map<String, TypedContent> resolvedReferences) {
        return ArtifactTypeUtil.determineArtifactType(content, artifactTypeHint, resolvedReferences, this.factory);
    }

    public static boolean notEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }
}

