/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.CommonSqlStatements;

public class SQLServerSqlStatements
extends CommonSqlStatements {
    @Override
    public String dbType() {
        return "mssql";
    }

    @Override
    public boolean isPrimaryKeyViolation(Exception error) {
        return error.getMessage().contains("Violation of PRIMARY KEY constraint");
    }

    @Override
    public boolean isForeignKeyViolation(Exception error) {
        return error.getMessage().contains("conflicted with the FOREIGN KEY constraint");
    }

    @Override
    public String isDatabaseInitialized() {
        return "SELECT count(*) AS count FROM information_schema.tables WHERE table_name = 'artifacts'";
    }

    @Override
    public String upsertBranch() {
        return "MERGE INTO branches AS target\nUSING (VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)) AS source (groupId, artifactId, branchId, description, systemDefined, owner, createdOn, modifiedBy, modifiedOn)\nON (target.groupId = source.groupId AND target.artifactId = source.artifactId AND target.branchId = source.branchId)\nWHEN NOT MATCHED THEN\nINSERT (groupId, artifactId, branchId, description, systemDefined, owner, createdOn, modifiedBy, modifiedOn)\nVALUES (source.groupId, source.artifactId, source.branchId, source.description, source.systemDefined, source.owner, source.createdOn, source.modifiedBy, source.modifiedOn)\n";
    }

    @Override
    public String getNextSequenceValue() {
        return "MERGE INTO sequences AS target\nUSING (VALUES  (?)) AS source (seqName)\nON (target.seqName = source.seqName)\nWHEN MATCHED THEN\nUPDATE SET seqValue = target.seqValue + 1\nWHEN NOT MATCHED THEN\nINSERT (seqName, seqValue)\nVALUES (source.seqName, 1)\nOUTPUT INSERTED.seqValue\n";
    }

    @Override
    public String resetSequenceValue() {
        return "MERGE INTO sequences AS target\nUSING (VALUES (?, ?)) AS source (seqName, seqValue)\nON (target.seqName = source.seqName)\nWHEN MATCHED THEN\nUPDATE SET seqValue = ?\nWHEN NOT MATCHED THEN\nINSERT (seqName, seqValue)\nVALUES (source.seqName, source.seqValue)\nOUTPUT INSERTED.seqValue\n";
    }

    @Override
    public String selectArtifactIds() {
        return "SELECT TOP (?) artifactId FROM artifacts ";
    }

    @Override
    public String selectGroups() {
        return "SELECT TOP (?) * FROM groups ORDER BY groupId ASC";
    }

    @Override
    public String selectBranchTip() {
        return "SELECT ab.groupId, ab.artifactId, ab.version FROM artifact_branches ab WHERE ab.groupId = ? AND ab.artifactId = ? AND ab.branchId = ? ORDER BY ab.branchOrder DESC OFFSET 0 ROWS FETCH NEXT 1 ROWS ONLY";
    }

    @Override
    public String selectBranchTipNotDisabled() {
        return "SELECT ab.groupId, ab.artifactId, ab.version FROM artifact_branches ab JOIN versions v ON ab.groupId = v.groupId AND ab.artifactId = v.artifactId AND ab.version = v.version WHERE ab.groupId = ? AND ab.artifactId = ? AND ab.branchId = ? AND v.state != 'DISABLED' ORDER BY ab.branchOrder DESC OFFSET 0 ROWS FETCH NEXT 1 ROWS ONLY";
    }

    @Override
    public String deleteAllOrphanedContent() {
        return "DELETE FROM content WHERE NOT EXISTS (SELECT 1 FROM versions v WHERE v.contentId = contentId )";
    }

    @Override
    public String createDataSnapshot() {
        throw new IllegalStateException("Snapshot creation is not supported for Sqlserver storage");
    }

    @Override
    public String restoreFromSnapshot() {
        throw new IllegalStateException("Restoring from snapshot is not supported for Sqlserver storage");
    }
}

