/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.metrics.StorageMetricsApply;
import io.apicurio.registry.metrics.health.liveness.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.health.readiness.PersistenceTimeoutReadinessApply;
import io.apicurio.registry.storage.impl.sql.AbstractSqlRegistryStorage;
import io.apicurio.registry.storage.impl.sql.HandleFactory;
import io.apicurio.registry.storage.impl.sql.jdb.Update;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;

@ApplicationScoped
@PersistenceExceptionLivenessApply
@PersistenceTimeoutReadinessApply
@StorageMetricsApply
@Logged
public class SqlRegistryStorage
extends AbstractSqlRegistryStorage {
    @Inject
    HandleFactory handleFactory;

    @Override
    public String storageName() {
        return "sql";
    }

    @Override
    public void initialize() {
        this.initialize(this.handleFactory, true);
    }

    public void restoreFromSnapshot(String snapshotLocation) {
        this.handleFactory.withHandle(handle -> ((Update)handle.createUpdate(this.sqlStatements.restoreFromSnapshot()).bind(0, snapshotLocation)).execute());
    }

    @Transactional
    public void executeSqlStatement(String sqlStatement) {
        this.handleFactory.withHandle(handle -> handle.createUpdate(sqlStatement).execute());
    }
}

