/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.jdb;

import io.apicurio.registry.storage.impl.sql.jdb.MappedQuery;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.storage.impl.sql.jdb.RuntimeSqlException;
import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MappedQueryImpl<T>
implements MappedQuery<T>,
Closeable {
    final PreparedStatement statement;
    final RowMapper<T> mapper;

    public MappedQueryImpl(PreparedStatement statement, RowMapper<T> mapper) throws SQLException {
        this.statement = statement;
        this.mapper = mapper;
    }

    @Override
    public T one() {
        T rval;
        block13: {
            rval = null;
            try (ResultSet resultSet = this.statement.executeQuery();){
                if (resultSet.next()) {
                    rval = this.mapper.map(resultSet);
                    if (resultSet.next()) {
                        throw new RuntimeSqlException("SQL error: Expected only one result but got multiple.");
                    }
                    break block13;
                }
                throw new RuntimeSqlException("SQL error: Expected only one result row but got none.");
            }
            catch (SQLException e) {
                throw new RuntimeSqlException(e);
            }
            finally {
                this.close();
            }
        }
        return rval;
    }

    @Override
    public T first() {
        T rval;
        block12: {
            rval = null;
            try (ResultSet resultSet = this.statement.executeQuery();){
                if (resultSet.next()) {
                    rval = this.mapper.map(resultSet);
                    break block12;
                }
                throw new RuntimeSqlException("SQL error: Expected AT LEAST one result row but got none.");
            }
            catch (SQLException e) {
                throw new RuntimeSqlException(e);
            }
            finally {
                this.close();
            }
        }
        return rval;
    }

    @Override
    public Optional<T> findOne() {
        Optional rval;
        try (ResultSet resultSet = this.statement.executeQuery();){
            if (resultSet.next()) {
                rval = Optional.of(this.mapper.map(resultSet));
                if (resultSet.next()) {
                    throw new RuntimeSqlException("SQL error: Expected only one result but got multiple.");
                }
            } else {
                rval = Optional.empty();
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public Optional<T> findFirst() {
        Optional rval = null;
        try (ResultSet resultSet = this.statement.executeQuery();){
            rval = resultSet.next() ? Optional.of(this.mapper.map(resultSet)) : Optional.empty();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public Optional<T> findLast() {
        Optional rval = null;
        try (ResultSet resultSet = this.statement.executeQuery();){
            while (resultSet.next()) {
                rval = Optional.of(this.mapper.map(resultSet));
            }
            if (rval == null) {
                rval = Optional.empty();
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public List<T> list() {
        LinkedList<T> rval = new LinkedList<T>();
        try (ResultSet resultSet = this.statement.executeQuery();){
            while (resultSet.next()) {
                T t = this.mapper.map(resultSet);
                rval.add(t);
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public Stream<T> stream() {
        try {
            final ResultSet resultSet = this.statement.executeQuery();
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1297){

                @Override
                public boolean tryAdvance(Consumer<? super T> action) {
                    try {
                        if (!resultSet.next()) {
                            return false;
                        }
                        Object t = MappedQueryImpl.this.mapper.map(resultSet);
                        action.accept(t);
                        return true;
                    }
                    catch (SQLException e) {
                        throw new RuntimeSqlException(e);
                    }
                }
            }, false).onClose(() -> {
                try {
                    resultSet.close();
                    this.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }
}

