/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.mappers;

import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Optional;

public class GroupEntityMapper
implements RowMapper<GroupEntity> {
    public static final GroupEntityMapper instance = new GroupEntityMapper();

    private GroupEntityMapper() {
    }

    @Override
    public GroupEntity map(ResultSet rs) throws SQLException {
        String type;
        GroupEntity entity = new GroupEntity();
        entity.groupId = RegistryContentUtils.denormalizeGroupId(rs.getString("groupId"));
        entity.description = rs.getString("description");
        entity.artifactsType = type = rs.getString("artifactsType");
        entity.owner = rs.getString("owner");
        entity.createdOn = rs.getTimestamp("createdOn").getTime();
        entity.modifiedBy = rs.getString("modifiedBy");
        entity.modifiedOn = Optional.ofNullable(rs.getTimestamp("modifiedOn")).map(Timestamp::getTime).orElse(0L);
        entity.labels = RegistryContentUtils.deserializeLabels(rs.getString("labels"));
        return entity;
    }
}

