/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.importing.v2;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.error.InvalidArtifactTypeException;
import io.apicurio.registry.storage.error.VersionAlreadyExistsException;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.storage.impl.sql.RegistryStorageContentUtils;
import io.apicurio.registry.storage.importing.v2.AbstractDataImporter;
import io.apicurio.registry.types.RegistryException;
import io.apicurio.registry.types.VersionState;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityInputStream;
import io.apicurio.registry.utils.impexp.v2.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v2.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v2.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v2.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

public class SqlDataUpgrader
extends AbstractDataImporter {
    protected RegistryStorageContentUtils utils;
    protected final RegistryStorage storage;
    protected final boolean preserveGlobalId;
    protected final boolean preserveContentId;
    protected final Map<Long, Long> globalIdMapping = new HashMap<Long, Long>();
    protected final Map<Long, Long> contentIdMapping = new HashMap<Long, Long>();
    private Set<Long> deferredCanonicalHashContentIds = new HashSet<Long>();

    public SqlDataUpgrader(Logger logger, RegistryStorageContentUtils utils, RegistryStorage storage, boolean preserveGlobalId, boolean preserveContentId) {
        super(logger);
        this.utils = utils;
        this.storage = storage;
        this.preserveGlobalId = preserveGlobalId;
        this.preserveContentId = preserveContentId;
    }

    @Override
    protected void importArtifactRule(ArtifactRuleEntity entity) {
        try {
            io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity newEntity = io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity.builder().type(entity.type).artifactId(entity.artifactId).configuration(entity.configuration).groupId(entity.groupId).build();
            this.storage.importArtifactRule(newEntity);
            this.log.debug("Artifact rule imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import artifact rule {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importArtifactVersion(ArtifactVersionEntity entity) {
        try {
            entity.contentId = this.contentIdMapping.get(entity.contentId);
            long oldGlobalId = entity.globalId;
            if (!this.preserveGlobalId) {
                entity.globalId = this.storage.nextGlobalId();
            }
            HashMap artifactVersionLabels = new HashMap();
            if (entity.labels != null) {
                entity.labels.forEach(label -> artifactVersionLabels.put(label, null));
            }
            if (entity.properties != null) {
                artifactVersionLabels.putAll(entity.properties);
            }
            io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity newEntity = io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity.builder().createdOn(entity.createdOn).description(entity.description).labels(artifactVersionLabels).name(entity.name).owner(entity.createdBy).state(VersionState.fromValue(entity.state.value())).artifactId(entity.artifactId).versionOrder(entity.versionId).modifiedOn(entity.createdOn).modifiedBy(entity.createdBy).version(entity.version).globalId(entity.globalId).contentId(entity.contentId).groupId(entity.groupId).build();
            if (!this.storage.isArtifactExists(entity.groupId, entity.artifactId)) {
                ArtifactEntity artifactEntity = ArtifactEntity.builder().artifactId(entity.artifactId).artifactType(entity.artifactType).createdOn(entity.createdOn).description(entity.description).groupId(entity.groupId).labels(artifactVersionLabels).modifiedBy(entity.createdBy).modifiedOn(entity.createdOn).name(entity.name).owner(entity.createdBy).build();
                this.storage.importArtifact(artifactEntity);
            }
            if (entity.isLatest) {
                EditableArtifactMetaDataDto editableArtifactMetaDataDto = EditableArtifactMetaDataDto.builder().name(newEntity.name).owner(newEntity.owner).description(newEntity.description).labels(newEntity.labels).build();
                this.storage.updateArtifactMetaData(newEntity.groupId, newEntity.artifactId, editableArtifactMetaDataDto);
            }
            this.storage.importArtifactVersion(newEntity);
            this.log.debug("Artifact version imported successfully: {}", (Object)entity);
            this.globalIdMapping.put(oldGlobalId, entity.globalId);
        }
        catch (VersionAlreadyExistsException ex) {
            if (ex.getGlobalId() != null) {
                this.log.warn("Duplicate globalId {} detected, skipping import of artifact version: {}", (Object)ex.getGlobalId(), (Object)entity);
            } else {
                this.log.warn("Failed to import artifact version {}: {}", (Object)entity, (Object)ex.getMessage());
            }
        }
        catch (Exception ex) {
            this.log.warn("Failed to import artifact version {}: {}", new Object[]{entity, ex.getMessage(), ex});
        }
    }

    @Override
    public void importContent(io.apicurio.registry.utils.impexp.v2.ContentEntity entity) {
        try {
            long oldContentId = entity.contentId;
            if (!this.preserveContentId) {
                entity.contentId = this.storage.nextContentId();
            }
            List<ArtifactReferenceDto> references = RegistryContentUtils.deserializeReferences(entity.serializedReferences);
            TypedContent typedContent = TypedContent.create((ContentHandle)ContentHandle.create((byte[])entity.contentBytes), null);
            entity.contentHash = this.utils.getContentHash(typedContent, references);
            try {
                Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(references, this.storage::getContentByReference);
                entity.artifactType = this.utils.determineArtifactType(typedContent, null, resolvedReferences);
                TypedContent canonicalContent = this.utils.canonicalizeContent(entity.artifactType, typedContent, resolvedReferences);
                entity.canonicalHash = DigestUtils.sha256Hex((byte[])canonicalContent.getContent().bytes());
            }
            catch (Exception ex) {
                this.log.debug("Deferring canonical hash calculation: " + ex.getMessage());
                this.deferredCanonicalHashContentIds.add(entity.contentId);
                entity.artifactType = "AVRO";
            }
            ContentEntity newEntity = ContentEntity.builder().contentType(this.determineContentType(entity.artifactType, typedContent)).contentHash(entity.contentHash).artifactType(entity.artifactType).contentBytes(entity.contentBytes).serializedReferences(entity.serializedReferences).canonicalHash(entity.canonicalHash).contentId(entity.contentId).build();
            this.storage.importContent(newEntity);
            this.log.debug("Content imported successfully: {}", (Object)entity);
            this.contentIdMapping.put(oldContentId, entity.contentId);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import content {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importGlobalRule(GlobalRuleEntity entity) {
        try {
            this.storage.importGlobalRule(io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity.builder().configuration(entity.configuration).ruleType(entity.ruleType).build());
            this.log.debug("Global rule imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import global rule {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importGroup(GroupEntity entity) {
        try {
            io.apicurio.registry.utils.impexp.v3.GroupEntity newEntity = io.apicurio.registry.utils.impexp.v3.GroupEntity.builder().artifactsType(entity.artifactsType).createdOn(entity.createdOn).description(entity.description).groupId(entity.groupId).labels(Collections.emptyMap()).modifiedBy(entity.modifiedBy).modifiedOn(entity.modifiedOn).owner(entity.createdBy).build();
            this.storage.importGroup(newEntity);
            this.log.debug("Group imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import group {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importComment(io.apicurio.registry.utils.impexp.v2.CommentEntity entity) {
        try {
            entity.globalId = this.globalIdMapping.get(entity.globalId);
            CommentEntity newEntity = CommentEntity.builder().commentId(entity.commentId).createdOn(entity.createdOn).globalId(entity.globalId).owner(entity.createdBy).value(entity.value).build();
            this.storage.importComment(newEntity);
            this.log.debug("Comment imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import comment {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importData(EntityInputStream entities, Runnable postImportAction) {
        try {
            Entity entity = null;
            while ((entity = entities.nextEntity()) != null) {
                this.importEntity(entity);
            }
            postImportAction.run();
            this.storage.resetContentId();
            this.storage.resetGlobalId();
            this.storage.resetCommentId();
            this.deferredCanonicalHashContentIds.forEach(id -> this.recalculateCanonicalHash((Long)id));
        }
        catch (IOException ex) {
            throw new RegistryException("Could not read next entity to import", ex);
        }
    }

    private void recalculateCanonicalHash(Long contentId) {
        try {
            ContentWrapperDto wrapperDto = this.storage.getContentById(contentId);
            List<ArtifactReferenceDto> references = wrapperDto.getReferences();
            List<ArtifactVersionMetaDataDto> versions = this.storage.getArtifactVersionsByContentId(contentId);
            if (versions.isEmpty()) {
                return;
            }
            TypedContent content = TypedContent.create((ContentHandle)wrapperDto.getContent(), (String)wrapperDto.getContentType());
            String artifactType = versions.get(0).getArtifactType();
            Map<String, TypedContent> resolvedReferences = RegistryContentUtils.recursivelyResolveReferences(references, this.storage::getContentByReference);
            TypedContent canonicalContent = this.utils.canonicalizeContent(artifactType, content, resolvedReferences);
            String canonicalHash = DigestUtils.sha256Hex((byte[])canonicalContent.getContent().bytes());
            String contentHash = this.utils.getContentHash(content, references);
            this.storage.updateContentCanonicalHash(canonicalHash, contentId, contentHash);
        }
        catch (Exception ex) {
            this.log.warn("Failed to recalculate canonical hash for: " + contentId, (Throwable)ex);
        }
    }

    private String determineContentType(String artifactTypeHint, TypedContent content) {
        if (content.getContentType() != null) {
            return content.getContentType();
        }
        switch (artifactTypeHint) {
            case "ASYNCAPI": 
            case "JSON": 
            case "OPENAPI": 
            case "AVRO": {
                return "application/json";
            }
            case "PROTOBUF": {
                return "application/x-protobuf";
            }
            case "GRAPHQL": {
                return "application/graphql";
            }
            case "XML": 
            case "XSD": 
            case "WSDL": {
                return "application/xml";
            }
        }
        throw new InvalidArtifactTypeException("Invalid or unknown artifact type: " + artifactTypeHint);
    }
}

