/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.importing.v3;

import io.apicurio.registry.storage.error.RegistryStorageException;
import io.apicurio.registry.storage.importing.DataImporter;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import org.slf4j.Logger;

public abstract class AbstractDataImporter
implements DataImporter {
    protected final Logger log;

    public AbstractDataImporter(Logger log) {
        this.log = log;
    }

    @Override
    public void importEntity(Entity entity) {
        switch (entity.getEntityType()) {
            case ArtifactRule: {
                this.importArtifactRule((ArtifactRuleEntity)entity);
                break;
            }
            case Artifact: {
                this.importArtifact((ArtifactEntity)entity);
                break;
            }
            case ArtifactVersion: {
                this.importArtifactVersion((ArtifactVersionEntity)entity);
                break;
            }
            case Content: {
                this.importContent((ContentEntity)entity);
                break;
            }
            case GlobalRule: {
                this.importGlobalRule((GlobalRuleEntity)entity);
                break;
            }
            case Group: {
                this.importGroup((GroupEntity)entity);
                break;
            }
            case GroupRule: {
                this.importGroupRule((GroupRuleEntity)entity);
                break;
            }
            case Comment: {
                this.importComment((CommentEntity)entity);
                break;
            }
            case Branch: {
                this.importBranch((BranchEntity)entity);
                break;
            }
            case Manifest: {
                ManifestEntity manifest = (ManifestEntity)entity;
                this.log.info("---------- Import Info ----------");
                this.log.info("System Name:    {}", (Object)manifest.systemName);
                this.log.info("System Desc:    {}", (Object)manifest.systemDescription);
                this.log.info("System Version: {}", (Object)manifest.systemVersion);
                this.log.info("Data exported on {} by user {}", (Object)manifest.exportedOn, (Object)manifest.exportedBy);
                this.log.info("---------- ----------- ----------");
                break;
            }
            default: {
                throw new RegistryStorageException("Unhandled entity type during import: " + entity.getEntityType());
            }
        }
    }

    protected abstract void importArtifactRule(ArtifactRuleEntity var1);

    protected abstract void importArtifact(ArtifactEntity var1);

    protected abstract void importArtifactVersion(ArtifactVersionEntity var1);

    protected abstract void importComment(CommentEntity var1);

    protected abstract void importContent(ContentEntity var1);

    protected abstract void importGlobalRule(GlobalRuleEntity var1);

    protected abstract void importGroup(GroupEntity var1);

    protected abstract void importGroupRule(GroupRuleEntity var1);

    protected abstract void importBranch(BranchEntity var1);
}

