/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.importing.v3;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.error.VersionAlreadyExistsException;
import io.apicurio.registry.storage.impl.sql.RegistryContentUtils;
import io.apicurio.registry.storage.impl.sql.RegistryStorageContentUtils;
import io.apicurio.registry.storage.importing.v3.AbstractDataImporter;
import io.apicurio.registry.types.RegistryException;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityInputStream;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

public class SqlDataImporter
extends AbstractDataImporter {
    protected RegistryStorageContentUtils utils;
    protected final RegistryStorage storage;
    protected final boolean preserveGlobalId;
    protected final boolean preserveContentId;
    protected final Map<Long, Long> globalIdMapping = new HashMap<Long, Long>();
    protected final Map<Long, Long> contentIdMapping = new HashMap<Long, Long>();

    public SqlDataImporter(Logger logger, RegistryStorageContentUtils utils, RegistryStorage storage, boolean preserveGlobalId, boolean preserveContentId) {
        super(logger);
        this.utils = utils;
        this.storage = storage;
        this.preserveGlobalId = preserveGlobalId;
        this.preserveContentId = preserveContentId;
    }

    @Override
    public void importArtifactRule(ArtifactRuleEntity entity) {
        try {
            this.storage.importArtifactRule(entity);
            this.log.debug("Artifact rule imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import artifact rule {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    protected void importArtifact(ArtifactEntity entity) {
        try {
            this.storage.importArtifact(entity);
            this.log.debug("Artifact imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import artifact {} / {}: {}", new Object[]{entity.groupId, entity.artifactId, ex.getMessage()});
        }
    }

    @Override
    public void importArtifactVersion(ArtifactVersionEntity entity) {
        try {
            entity.contentId = this.contentIdMapping.get(entity.contentId);
            long oldGlobalId = entity.globalId;
            if (!this.preserveGlobalId) {
                entity.globalId = this.storage.nextGlobalId();
            }
            this.storage.importArtifactVersion(entity);
            this.log.debug("Artifact version imported successfully: {}", (Object)entity);
            this.globalIdMapping.put(oldGlobalId, entity.globalId);
        }
        catch (VersionAlreadyExistsException ex) {
            if (ex.getGlobalId() != null) {
                this.log.warn("Duplicate globalId {} detected, skipping import of artifact version: {}", (Object)ex.getGlobalId(), (Object)entity);
            } else {
                this.log.warn("Failed to import artifact version {}: {}", (Object)entity, (Object)ex.getMessage());
            }
        }
        catch (Exception ex) {
            this.log.warn("Failed to import artifact version {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importContent(ContentEntity entity) {
        try {
            List<ArtifactReferenceDto> references = RegistryContentUtils.deserializeReferences(entity.serializedReferences);
            if (entity.contentType == null) {
                throw new RuntimeException("ContentEntity is missing required field: contentType");
            }
            TypedContent typedContent = TypedContent.create((ContentHandle)ContentHandle.create((byte[])entity.contentBytes), (String)entity.contentType);
            if (entity.canonicalHash == null && entity.artifactType != null) {
                TypedContent canonicalContent = this.utils.canonicalizeContent(entity.artifactType, typedContent, RegistryContentUtils.recursivelyResolveReferences(references, this.storage::getContentByReference));
                entity.canonicalHash = DigestUtils.sha256Hex((byte[])canonicalContent.getContent().bytes());
            }
            long oldContentId = entity.contentId;
            if (!this.preserveContentId) {
                entity.contentId = this.storage.nextContentId();
            }
            this.storage.importContent(entity);
            this.log.debug("Content imported successfully: {}", (Object)entity);
            this.contentIdMapping.put(oldContentId, entity.contentId);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import content {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importGlobalRule(GlobalRuleEntity entity) {
        try {
            this.storage.importGlobalRule(entity);
            this.log.debug("Global rule imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import global rule {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importGroup(GroupEntity entity) {
        try {
            this.storage.importGroup(entity);
            this.log.debug("Group imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import group {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importGroupRule(GroupRuleEntity entity) {
        try {
            this.storage.importGroupRule(entity);
            this.log.debug("Group rule imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import group rule {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importComment(CommentEntity entity) {
        try {
            entity.globalId = this.globalIdMapping.get(entity.globalId);
            this.storage.importComment(entity);
            this.log.debug("Comment imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import comment {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    protected void importBranch(BranchEntity entity) {
        try {
            this.storage.importBranch(entity);
            this.log.debug("Branch imported successfully: {}", (Object)entity);
        }
        catch (Exception ex) {
            this.log.warn("Failed to import branch {}: {}", (Object)entity, (Object)ex.getMessage());
        }
    }

    @Override
    public void importData(EntityInputStream entities, Runnable postImportAction) {
        try {
            Entity entity = null;
            while ((entity = entities.nextEntity()) != null) {
                this.importEntity(entity);
            }
            postImportAction.run();
            this.storage.resetContentId();
            this.storage.resetGlobalId();
            this.storage.resetCommentId();
        }
        catch (IOException ex) {
            throw new RegistryException("Could not read next entity to import", ex);
        }
    }
}

