/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ApplicationScoped
public class StorageMetricsStore {
    @Inject
    Logger log;
    @Inject
    @ConfigProperty(defaultValue="30000", name="apicurio.storage.metrics.cache.check-period.ms")
    @Info(category="health", description="Storage metrics cache check period", availableSince="2.1.0.Final")
    Long limitsCheckPeriod;
    @Inject
    @ConfigProperty(defaultValue="1000", name="apicurio.storage.metrics.cache.max-size")
    @Info(category="limits", description="Storage metrics cache max size.", availableSince="2.4.1.Final")
    Long cacheMaxSize;
    private static final String TOTAL_SCHEMAS_KEY = "TOTAL_SCHEMAS";
    private static final String ARTIFACT_COUNTER = "ARTIFACTS_COUNTER";
    @Inject
    @Current
    RegistryStorage storage;
    private LoadingCache<String, AtomicLong> countersCache;
    private LoadingCache<ArtifactVersionKey, AtomicLong> artifactVersionsCounters;
    CacheLoader<String, AtomicLong> totalSchemaCountersLoader;
    CacheLoader<ArtifactVersionKey, AtomicLong> artifactVersionsCountersLoader;

    public void onStart(@Observes StartupEvent ev) {
        this.createCountersCache();
        this.createTotalArtifactVersionsCache();
    }

    private void createCountersCache() {
        this.totalSchemaCountersLoader = new CacheLoader<String, AtomicLong>(){

            public AtomicLong load(@NotNull String key) {
                if (key.equals(StorageMetricsStore.TOTAL_SCHEMAS_KEY)) {
                    StorageMetricsStore.this.log.info("Initializing total schemas counter");
                    long count = StorageMetricsStore.this.storage.countTotalArtifactVersions();
                    return new AtomicLong(count);
                }
                StorageMetricsStore.this.log.info("Initializing total schemas counter");
                long count = StorageMetricsStore.this.storage.countArtifacts();
                return new AtomicLong(count);
            }
        };
        this.countersCache = CacheBuilder.newBuilder().expireAfterWrite(this.limitsCheckPeriod.longValue(), TimeUnit.MILLISECONDS).maximumSize(this.cacheMaxSize.longValue()).build(this.totalSchemaCountersLoader);
    }

    private void createTotalArtifactVersionsCache() {
        this.artifactVersionsCountersLoader = new CacheLoader<ArtifactVersionKey, AtomicLong>(){

            public AtomicLong load(@NotNull ArtifactVersionKey artifactVersionKey) {
                StorageMetricsStore.this.log.info("Initializing total artifact versions counter for artifact gid {} ai {}", (Object)artifactVersionKey.groupId, (Object)artifactVersionKey.artifactId);
                long count = StorageMetricsStore.this.storage.countArtifactVersions(artifactVersionKey.groupId, artifactVersionKey.artifactId);
                return new AtomicLong(count);
            }
        };
        this.artifactVersionsCounters = CacheBuilder.newBuilder().expireAfterWrite(this.limitsCheckPeriod.longValue(), TimeUnit.MILLISECONDS).maximumSize(this.cacheMaxSize.longValue()).build(this.artifactVersionsCountersLoader);
    }

    public long getOrInitializeTotalSchemasCounter() {
        return ((AtomicLong)this.countersCache.getUnchecked((Object)TOTAL_SCHEMAS_KEY)).get();
    }

    public long getOrInitializeArtifactsCounter() {
        return ((AtomicLong)this.countersCache.getUnchecked((Object)ARTIFACT_COUNTER)).get();
    }

    public long getOrInitializeArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        return ((AtomicLong)this.artifactVersionsCounters.getUnchecked((Object)avk)).get();
    }

    public void incrementTotalSchemasCounter() {
        this.log.info("Incrementing total schemas counter");
        AtomicLong counter = (AtomicLong)this.countersCache.getUnchecked((Object)TOTAL_SCHEMAS_KEY);
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void incrementArtifactsCounter() {
        AtomicLong counter = (AtomicLong)this.countersCache.getUnchecked((Object)ARTIFACT_COUNTER);
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void incrementArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        AtomicLong counter = (AtomicLong)this.artifactVersionsCounters.getUnchecked((Object)avk);
        if (counter == null) {
            return;
        }
        counter.incrementAndGet();
    }

    public void resetTotalSchemasCounter() {
        this.countersCache.invalidate((Object)TOTAL_SCHEMAS_KEY);
    }

    public void resetArtifactsCounter() {
        this.countersCache.invalidate((Object)ARTIFACT_COUNTER);
    }

    public void resetArtifactVersionsCounter(String groupId, String artifactId) {
        ArtifactVersionKey avk = new ArtifactVersionKey();
        avk.groupId = groupId;
        avk.artifactId = artifactId;
        this.artifactVersionsCounters.invalidate((Object)avk);
    }

    private static class ArtifactVersionKey {
        String groupId;
        String artifactId;

        private ArtifactVersionKey() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactVersionKey)) {
                return false;
            }
            ArtifactVersionKey other = (ArtifactVersionKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.groupId;
            String other$groupId = other.groupId;
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.artifactId;
            String other$artifactId = other.artifactId;
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ArtifactVersionKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.groupId;
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.artifactId;
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }
    }
}

