/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui;

import io.apicurio.common.apps.config.Info;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class URLUtil {
    @ConfigProperty(name="apicurio.url.override.host")
    @Info(category="redirects", description="Override the hostname used for generating externally-accessible URLs. The host and port overrides are useful when deploying Registry with HTTPS passthrough Ingress or Route. In cases like these, the request URL (and port) that is then re-used for redirection does not belong to actual external URL used by the client, because the request is proxied. The redirection then fails because the target URL is not reachable.", availableSince="2.5.0.Final")
    Optional<String> urlOverrideHost;
    @ConfigProperty(name="apicurio.url.override.port")
    @Info(category="redirects", description="Override the port used for generating externally-accessible URLs.", availableSince="2.5.0.Final")
    Optional<Integer> urlOverridePort;
    @Inject
    Logger log;

    public URL getExternalAbsoluteURL(HttpServletRequest request, String relativePath) {
        String targetProtocol = null;
        String targetHost = null;
        int targetPort = -1;
        try {
            String requestURLStr = request.getRequestURL().toString();
            URL requestURL = new URL(requestURLStr);
            String forwardedProtoHeaderValue = request.getHeader("X-Forwarded-Proto");
            String forwardedHostHeaderValue = request.getHeader("X-Forwarded-Host");
            targetProtocol = requestURL.getProtocol();
            if ("http".equals(targetProtocol) && request.isSecure()) {
                this.log.debug("Generating absolute URL: Switching from HTTP to HTTPS protocol for a secure request.");
                targetProtocol = "https";
            }
            if (forwardedProtoHeaderValue != null && !forwardedProtoHeaderValue.isBlank()) {
                this.log.debug("Generating absolute URL: Using X-Forwarded-Proto header value for the protocol.");
                targetProtocol = forwardedProtoHeaderValue;
            }
            targetHost = requestURL.getHost();
            if (this.urlOverrideHost.isPresent() && !this.urlOverrideHost.get().isBlank()) {
                this.log.debug("Generating absolute URL: Using configured override for the host.");
                targetHost = this.urlOverrideHost.get();
            } else if (forwardedHostHeaderValue != null && !forwardedHostHeaderValue.isBlank()) {
                this.log.debug("Generating absolute URL: Using X-Forwarded-Host header value for the host.");
                targetHost = forwardedHostHeaderValue;
            }
            targetPort = requestURL.getPort();
            if (this.urlOverridePort.isPresent() && this.urlOverridePort.get() > 0) {
                this.log.debug("Generating absolute URL: Using configured override for the port.");
                targetPort = this.urlOverridePort.get();
            }
            if ("https".equals(targetProtocol) && targetPort == 443 || "http".equals(targetProtocol) && targetPort == 80) {
                targetPort = -1;
            }
            URL targetURL = new URL(targetProtocol, targetHost, targetPort, relativePath);
            this.log.debug("Generating absolute URL: {} -> {}", (Object)requestURL, (Object)targetURL);
            return targetURL;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(String.format("Could not generate a valid absolute URL from: protocol = '%s', host = '%s', port = '%s', and relativePath = '%s'.", targetProtocol, targetHost, targetPort, relativePath), ex);
        }
    }
}

