/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

@ApplicationScoped
public class SpecUrlFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        CharResponseWrapper wrappedResponse = new CharResponseWrapper((HttpServletResponse)resp);
        chain.doFilter(req, (ServletResponse)wrappedResponse);
        byte[] bytes = wrappedResponse.getByteArray();
        if (bytes != null && resp.getContentType() != null && resp.getContentType().contains("text/html")) {
            String specUrl = this.generateSpecUrl((HttpServletRequest)req);
            String title = this.generateSpecTitle((HttpServletRequest)req);
            String out = new String(bytes, StandardCharsets.UTF_8);
            out = out.replace("SPEC_URL", specUrl);
            out = out.replace("API_TITLE", title);
            byte[] newBytes = out.getBytes(StandardCharsets.UTF_8);
            resp.setContentLength(newBytes.length);
            resp.getOutputStream().write(newBytes);
        } else if (bytes != null && bytes.length > 0) {
            resp.getOutputStream().write(bytes);
        }
    }

    public void destroy() {
    }

    private String generateSpecUrl(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        Object apiSpec = servletPath.replace("/apis/", "/api-specifications/");
        if (!((String)apiSpec).endsWith("/")) {
            apiSpec = (String)apiSpec + "/";
        }
        apiSpec = (String)apiSpec + "openapi.json";
        return apiSpec;
    }

    private String generateSpecTitle(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath.contains("registry/v2")) {
            return "Core Registry API (v2)";
        }
        if (servletPath.contains("ccompat")) {
            return "Confluent Schema Registry API";
        }
        return "";
    }

    public class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayPrintWriter output;
        private boolean usingWriter;

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
            this.usingWriter = false;
            this.output = new ByteArrayPrintWriter();
        }

        public byte[] getByteArray() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.usingWriter) {
                super.getOutputStream();
            }
            this.usingWriter = true;
            return this.output.getStream();
        }

        public PrintWriter getWriter() throws IOException {
            if (this.usingWriter) {
                super.getWriter();
            }
            this.usingWriter = true;
            return this.output.getWriter();
        }

        public String toString() {
            return this.output.toString();
        }
    }

    private static class ByteArrayPrintWriter {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter pw = new PrintWriter(this.baos);
        private ServletOutputStream sos = new ByteArrayServletStream(this.baos);

        private ByteArrayPrintWriter() {
        }

        public PrintWriter getWriter() {
            return this.pw;
        }

        public ServletOutputStream getStream() {
            return this.sos;
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }

    private static class ByteArrayServletStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        ByteArrayServletStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int param) throws IOException {
            this.baos.write(param);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

