/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.storage.error.InvalidArtifactTypeException;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import java.util.Collections;
import java.util.Map;

public final class ArtifactTypeUtil {
    private ArtifactTypeUtil() {
    }

    public static String determineArtifactType(TypedContent content, String artifactType, ArtifactTypeUtilProviderFactory artifactTypeProviderFactory) {
        return ArtifactTypeUtil.determineArtifactType(content, artifactType, Collections.emptyMap(), artifactTypeProviderFactory);
    }

    public static String determineArtifactType(TypedContent content, String artifactType, Map<String, TypedContent> resolvedReferences, ArtifactTypeUtilProviderFactory artifactTypeProviderFactory) {
        if ("".equals(artifactType)) {
            artifactType = null;
        }
        if (artifactType == null && content != null) {
            artifactType = ArtifactTypeUtil.discoverType(content, resolvedReferences, artifactTypeProviderFactory);
        }
        if (!artifactTypeProviderFactory.getAllArtifactTypes().contains(artifactType)) {
            throw new InvalidArtifactTypeException("Invalid or unknown artifact type: " + artifactType);
        }
        return artifactType;
    }

    private static String discoverType(TypedContent content, Map<String, TypedContent> resolvedReferences, ArtifactTypeUtilProviderFactory artifactTypeProviderFactory) throws InvalidArtifactTypeException {
        for (ArtifactTypeUtilProvider provider : artifactTypeProviderFactory.getAllArtifactTypeProviders()) {
            if (!provider.acceptsContent(content, resolvedReferences)) continue;
            return provider.getArtifactType();
        }
        throw new InvalidArtifactTypeException("Failed to discover artifact type from content.");
    }
}

