/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.JavaScriptRequestChecker;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_STATIC_TENANT_ID = "static.tenant.id";
    private static final String CURRENT_STATIC_TENANT_ID_NULL = "static.tenant.id.null";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG = "dynamic.tenant.config";
    private final ConcurrentHashMap<String, BackChannelLogoutTokenCache> backChannelLogoutTokens;
    private final BlockingTaskRunner<OidcTenantConfig> blockingRequestContext;
    private final boolean securityEventObserved;
    private final TenantConfigBean tenantConfigBean;
    private final TenantResolver[] staticTenantResolvers;
    private final boolean annotationBasedTenantResolutionEnabled;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    @Inject
    Instance<JavaScriptRequestChecker> javaScriptRequestChecker;
    @Inject
    Instance<TokenStateManager> tokenStateManager;
    @Inject
    Instance<TokenIntrospectionCache> tokenIntrospectionCache;
    @Inject
    Instance<UserInfoCache> userInfoCache;
    @Inject
    Event<SecurityEvent> securityEvent;
    @Inject
    @ConfigProperty(name="quarkus.http.proxy.enable-forwarded-prefix")
    boolean enableHttpForwardedPrefix;

    DefaultTenantConfigResolver(BlockingSecurityExecutor blockingExecutor, BeanManager beanManager, Instance<TenantResolver> tenantResolverInstance, @ConfigProperty(name="quarkus.oidc.resolve-tenants-with-issuer") boolean resolveTenantsWithIssuer, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, @ConfigProperty(name="quarkus.http.root-path") String rootPath, TenantConfigBean tenantConfigBean) {
        this.backChannelLogoutTokens = new ConcurrentHashMap();
        this.blockingRequestContext = new BlockingTaskRunner(blockingExecutor);
        this.securityEventObserved = SecurityEventHelper.isEventObserved((io.quarkus.security.spi.runtime.SecurityEvent)new SecurityEvent(null, (SecurityIdentity)null), (BeanManager)beanManager, (boolean)securityEventsEnabled);
        this.tenantConfigBean = tenantConfigBean;
        this.staticTenantResolvers = DefaultTenantConfigResolver.prepareStaticTenantResolvers(tenantConfigBean, rootPath, tenantResolverInstance, resolveTenantsWithIssuer, (TenantResolver)new DefaultStaticTenantResolver(this));
        this.annotationBasedTenantResolutionEnabled = Boolean.getBoolean("io.quarkus.oidc.runtime.select-tenants-with-annotation");
    }

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        if (this.tokenStateManager.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenStateManager.class + " beans registered");
        }
        if (this.tokenIntrospectionCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TokenIntrospectionCache.class + " beans registered");
        }
        if (this.userInfoCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + UserInfo.class + " beans registered");
        }
        if (this.javaScriptRequestChecker.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + JavaScriptRequestChecker.class + " beans registered");
        }
    }

    Uni<OidcTenantConfig> resolveConfig(RoutingContext context) {
        return this.getDynamicTenantConfig(context).map((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    Uni<TenantConfigContext> resolveContext(String tenantId) {
        return this.initializeStaticTenantIfContextNotReady(this.getStaticTenantContext(tenantId));
    }

    Uni<TenantConfigContext> resolveContext(RoutingContext context) {
        return this.getDynamicTenantContext(context).onItem().ifNull().switchTo((Supplier)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Uni<TenantConfigContext> initializeStaticTenantIfContextNotReady(TenantConfigContext tenantContext) {
        if (tenantContext != null && !tenantContext.ready) {
            TenantConfigContext readyTenantContext = (TenantConfigContext)this.tenantConfigBean.getDynamicTenantsConfig().get(tenantContext.oidcConfig.tenantId.get());
            if (readyTenantContext == null) {
                LOG.debugf("Tenant '%s' is not initialized yet, trying to create OIDC connection now", tenantContext.oidcConfig.tenantId.get());
                return (Uni)this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantContext.oidcConfig);
            }
            tenantContext = readyTenantContext;
        }
        return Uni.createFrom().item((Object)tenantContext);
    }

    private TenantConfigContext getStaticTenantContext(RoutingContext context) {
        String tenantId = (String)context.get("static.tenant.id");
        if (tenantId == null && context.get("static.tenant.id.null") == null) {
            tenantId = this.resolveStaticTenantId(context);
            if (tenantId != null) {
                context.put("static.tenant.id", (Object)tenantId);
            } else {
                context.put("static.tenant.id.null", (Object)true);
            }
        }
        return this.getStaticTenantContext(tenantId);
    }

    private String resolveStaticTenantId(RoutingContext context) {
        String tenantId = (String)context.get("tenant-id");
        if (this.isTenantSetByAnnotation(context, tenantId)) {
            return tenantId;
        }
        for (TenantResolver staticTenantResolver : this.staticTenantResolvers) {
            tenantId = staticTenantResolver.resolve(context);
            if (tenantId == null) continue;
            return tenantId;
        }
        return (String)context.get("tenant-id");
    }

    private boolean isTenantSetByAnnotation(RoutingContext context, String tenantId) {
        return this.annotationBasedTenantResolutionEnabled && tenantId != null && context.get("tenant-id-set-by-annotation") != null;
    }

    private TenantConfigContext getStaticTenantContext(String tenantId) {
        TenantConfigContext configContext;
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? (TenantConfigContext)this.tenantConfigBean.getStaticTenantsConfig().get(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty()) {
                LOG.debugf("Registered TenantResolver has not provided the configuration for tenant '%s', using the default tenant", (Object)tenantId);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    TokenStateManager getTokenStateManager() {
        return (TokenStateManager)this.tokenStateManager.get();
    }

    TokenIntrospectionCache getTokenIntrospectionCache() {
        return this.tokenIntrospectionCache.isResolvable() ? (TokenIntrospectionCache)this.tokenIntrospectionCache.get() : null;
    }

    UserInfoCache getUserInfoCache() {
        return this.userInfoCache.isResolvable() ? (UserInfoCache)this.userInfoCache.get() : null;
    }

    private Uni<OidcTenantConfig> getDynamicTenantConfig(RoutingContext context) {
        if (this.isTenantSetByAnnotation(context, (String)context.get("tenant-id"))) {
            return Uni.createFrom().nullItem();
        }
        if (this.tenantConfigResolver.isResolvable()) {
            Uni oidcConfig = (Uni)context.get("dynamic.tenant.config");
            if (oidcConfig == null) {
                oidcConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context, this.blockingRequestContext);
                if (oidcConfig == null) {
                    oidcConfig = Uni.createFrom().nullItem();
                }
                oidcConfig = (oidcConfig = oidcConfig.memoize().indefinitely()) == null ? Uni.createFrom().nullItem() : oidcConfig.onItem().transform(cfg -> OidcUtils.resolveProviderConfig((OidcTenantConfig)cfg));
                context.put("dynamic.tenant.config", (Object)oidcConfig);
            }
            return oidcConfig;
        }
        return Uni.createFrom().nullItem();
    }

    private Uni<TenantConfigContext> getDynamicTenantContext(RoutingContext context) {
        return this.getDynamicTenantConfig(context).chain((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    boolean isEnableHttpForwardedPrefix() {
        return this.enableHttpForwardedPrefix;
    }

    public Map<String, BackChannelLogoutTokenCache> getBackChannelLogoutTokens() {
        return this.backChannelLogoutTokens;
    }

    public TenantConfigBean getTenantConfigBean() {
        return this.tenantConfigBean;
    }

    public JavaScriptRequestChecker getJavaScriptRequestChecker() {
        return this.javaScriptRequestChecker.isResolvable() ? (JavaScriptRequestChecker)this.javaScriptRequestChecker.get() : null;
    }

    private static TenantResolver[] prepareStaticTenantResolvers(TenantConfigBean tenantConfigBean, String rootPath, Instance<TenantResolver> tenantResolverInstance, boolean resolveTenantsWithIssuer, TenantResolver defaultStaticTenantResolver) {
        PathMatchingTenantResolver pathMatchingTenantResolver;
        ArrayList<Object> staticTenantResolvers = new ArrayList<Object>();
        if (tenantResolverInstance.isResolvable()) {
            if (tenantResolverInstance.isAmbiguous()) {
                throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
            }
            staticTenantResolvers.add((TenantResolver)tenantResolverInstance.get());
        }
        if ((pathMatchingTenantResolver = PathMatchingTenantResolver.of((Map)tenantConfigBean.getStaticTenantsConfig(), (String)rootPath, (TenantConfigContext)tenantConfigBean.getDefaultTenant())) != null) {
            staticTenantResolvers.add(pathMatchingTenantResolver);
        }
        if (!tenantConfigBean.getStaticTenantsConfig().isEmpty()) {
            staticTenantResolvers.add(defaultStaticTenantResolver);
        }
        if (resolveTenantsWithIssuer) {
            IssuerBasedTenantResolver.addIssuerBasedTenantResolver(staticTenantResolvers, (Map)tenantConfigBean.getStaticTenantsConfig(), (TenantConfigContext)tenantConfigBean.getDefaultTenant());
        }
        return staticTenantResolvers.toArray(new TenantResolver[0]);
    }

    public OidcTenantConfig getResolvedConfig(String sessionTenantId) {
        if ("Default".equals(sessionTenantId)) {
            return this.tenantConfigBean.getDefaultTenant().getOidcTenantConfig();
        }
        if (this.tenantConfigBean.getStaticTenantsConfig().containsKey(sessionTenantId)) {
            return ((TenantConfigContext)this.tenantConfigBean.getStaticTenantsConfig().get(sessionTenantId)).getOidcTenantConfig();
        }
        if (this.tenantConfigBean.getDynamicTenantsConfig().containsKey(sessionTenantId)) {
            return ((TenantConfigContext)this.tenantConfigBean.getDynamicTenantsConfig().get(sessionTenantId)).getOidcTenantConfig();
        }
        return null;
    }

    public DefaultTenantConfigResolver() {
    }
}

