/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism;
import io.quarkus.smallrye.jwt.runtime.auth.JsonWebTokenCredential;
import io.quarkus.smallrye.jwt.runtime.auth.SmallRyeJwtConfig;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

@ApplicationScoped
public class JWTAuthMechanism
implements HttpAuthenticationMechanism {
    private static final String ERROR_MSG = "SmallRye JWT requires a safe (isolated) Vert.x sub-context for propagation of the '" + TokenCredential.class.getName() + "', but the current context hasn't been flagged as such.";
    protected static final String COOKIE_HEADER = "Cookie";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BEARER = "Bearer";
    private final boolean propagateTokenCredentialWithDuplicatedCtx;
    @Inject
    JWTAuthContextInfo authContextInfo;
    private final boolean silent;

    public JWTAuthMechanism(SmallRyeJwtConfig config) {
        this.silent = config == null ? false : config.silent();
        this.propagateTokenCredentialWithDuplicatedCtx = Boolean.getBoolean("io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism.PROPAGATE_TOKEN_CREDENTIAL_WITH_DUPLICATED_CTX");
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String jwtToken = new VertxBearerTokenExtractor(this.authContextInfo, context).getBearerToken();
        if (jwtToken != null) {
            context.put(HttpAuthenticationMechanism.class.getName(), (Object)this);
            if (this.propagateTokenCredentialWithDuplicatedCtx) {
                VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
                Context ctx = Vertx.currentContext();
                JsonWebTokenCredential token = new JsonWebTokenCredential(jwtToken);
                ctx.putLocal((Object)TokenCredential.class.getName(), (Object)token);
                return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)token), (RoutingContext)context)).invoke((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TokenAuthenticationRequest((TokenCredential)new JsonWebTokenCredential(jwtToken)), (RoutingContext)context));
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        String authHeader;
        if (this.silent && (authHeader = context.request().headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION)) == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        ChallengeData result = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, BEARER);
        return Uni.createFrom().item((Object)result);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        String tokenHeaderName = this.authContextInfo.getTokenHeader();
        if (COOKIE_HEADER.equals(tokenHeaderName)) {
            String tokenCookieName = this.authContextInfo.getTokenCookie();
            if (tokenCookieName == null) {
                tokenCookieName = BEARER;
            }
            return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.COOKIE, tokenCookieName));
        }
        if (AUTHORIZATION_HEADER.equals(tokenHeaderName)) {
            return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, BEARER));
        }
        return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.OTHER_HEADER, tokenHeaderName));
    }

    public JWTAuthMechanism() {
    }
}

