/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.KeyProvider;
import io.smallrye.jwt.SmallryeJwtUtils;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.config.ConfigLogging;
import io.smallrye.jwt.config.ConfigMessages;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_SCHEME = "Bearer";
    private static final String NONE = "NONE";
    private static final String DEFAULT_GROUPS_SEPARATOR = " ";
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    String mpJwtPublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.algorithm")
    Optional<SignatureAlgorithm> mpJwtPublicKeyAlgorithm;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    String mpJwtLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.decrypt.key.location", defaultValue="NONE")
    String mpJwtDecryptKeyLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.decrypt.key.algorithm", defaultValue="RSA_OAEP,RSA_OAEP_256")
    Set<KeyEncryptionAlgorithm> mpJwtDecryptKeyAlgorithm = new HashSet<KeyEncryptionAlgorithm>(Arrays.asList(KeyEncryptionAlgorithm.RSA_OAEP, KeyEncryptionAlgorithm.RSA_OAEP_256));
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.key")
    Optional<String> jwtDecryptKey;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key.location", defaultValue="NONE")
    String verifyKeyLocation;
    @Deprecated
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.key.location", defaultValue="NONE")
    String decryptionKeyLocation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.algorithm")
    @Deprecated
    Optional<KeyEncryptionAlgorithm> keyEncryptionAlgorithm;
    @Inject
    @ConfigProperty(name="mp.jwt.token.header")
    Optional<String> mpJwtTokenHeader;
    @Inject
    @ConfigProperty(name="mp.jwt.token.cookie")
    Optional<String> mpJwtTokenCookie;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.audiences")
    Optional<Set<String>> mpJwtVerifyAudiences;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.clock.skew", defaultValue="60")
    int mpJwtVerifyClockSkew;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.token.age")
    Optional<Long> mpJwtVerifyTokenAge;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.header")
    @Deprecated
    Optional<String> tokenHeader;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.cookie")
    @Deprecated
    Optional<String> tokenCookie;
    @Inject
    @ConfigProperty(name="smallrye.jwt.always-check-authorization", defaultValue="false")
    boolean alwaysCheckAuthorization;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.kid")
    Optional<String> tokenKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.decryption.kid")
    Optional<String> tokenDecryptionKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.schemes", defaultValue="Bearer")
    String tokenSchemes;
    @Inject
    @ConfigProperty(name="smallrye.jwt.require.named-principal", defaultValue="true")
    Optional<Boolean> requireNamedPrincipal = Optional.of(Boolean.TRUE);
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.sub")
    Optional<String> defaultSubClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.sub")
    Optional<String> subPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.groups")
    Optional<String> defaultGroupsClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.groups")
    Optional<String> groupsPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.groups-separator", defaultValue=" ")
    String groupsSeparator;
    @Inject
    @ConfigProperty(name="smallrye.jwt.expiration.grace", defaultValue="0")
    @Deprecated
    int expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.time-to-live")
    Optional<Long> maxTimeToLiveSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.refresh-interval", defaultValue="60")
    int jwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.forced-refresh-interval", defaultValue="30")
    int forcedJwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.algorithm")
    Optional<SignatureAlgorithm> signatureAlgorithm;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.certificateThumbprint", defaultValue="false")
    boolean verifyCertificateThumbprint;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key-format", defaultValue="ANY")
    KeyFormat keyFormat;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key-provider", defaultValue="DEFAULT")
    KeyProvider keyProvider;
    @Inject
    @ConfigProperty(name="smallrye.jwt.key-cache-size", defaultValue="100")
    int keyCacheSize;
    @Inject
    @ConfigProperty(name="smallrye.jwt.key-cache-time-to-live", defaultValue="10")
    int keyCacheTimeToLive;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.relax-key-validation", defaultValue="true")
    boolean relaxVerificationKeyValidation = true;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.aud")
    @Deprecated
    Optional<Set<String>> expectedAudience;
    @Inject
    @ConfigProperty(name="smallrye.jwt.required.claims")
    Optional<Set<String>> requiredClaims;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.certificate")
    Optional<String> tlsCertificate;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.certificate.path")
    Optional<String> tlsCertificatePath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.trust-all", defaultValue="false")
    boolean tlsTrustAll;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.hosts")
    Optional<Set<String>> tlsTrustedHosts;
    @Inject
    @ConfigProperty(name="smallrye.jwt.http.proxy.host")
    Optional<String> httpProxyHost;
    @Inject
    @ConfigProperty(name="smallrye.jwt.http.proxy.port", defaultValue="80")
    int httpProxyPort = 80;
    @ConfigProperty(name="smallrye.jwt.keystore.type")
    Optional<String> keyStoreType = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.provider")
    Optional<String> keyStoreProvider = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.password")
    Optional<String> keyStorePassword = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.verify.key.alias")
    Optional<String> keyStoreVerifyKeyAlias = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.decrypt.key.alias")
    Optional<String> keyStoreDecryptKeyAlias = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.decrypt.key.password")
    Optional<String> keyStoreDecryptKeyPassword = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.resolve-remote-keys-at-startup", defaultValue="false")
    boolean fetchRemoteKeysOnStartup = false;

    public static JWTAuthContextInfoProvider createWithKey(String publicKey, String issuer) {
        return JWTAuthContextInfoProvider.create(publicKey, NONE, false, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithDecryptionKey(String decryptionKey, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, NONE, false, false, issuer, Optional.of(decryptionKey));
    }

    public static JWTAuthContextInfoProvider createWithKeyLocation(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, false, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithCertificate(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, false, true, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithSecretKeyLocation(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, true, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithVerifyKeyStoreLocation(String keyLocation, Optional<String> theKeyStorePassword, Optional<String> theKeyStoreVerifyKeyAlias, Optional<String> theKeyStoreDecryptKeyAlias, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, Optional.empty(), Optional.empty(), theKeyStorePassword, theKeyStoreVerifyKeyAlias, theKeyStoreDecryptKeyAlias, false, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithKeyStoreLocation(String keyLocation, Optional<String> theKeyStorePassword, Optional<String> theKeyStoreVerifyKeyAlias, Optional<String> theKeyStoreDecryptKeyAlias, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, Optional.empty(), Optional.empty(), theKeyStorePassword, theKeyStoreVerifyKeyAlias, theKeyStoreDecryptKeyAlias, false, false, issuer, Optional.empty());
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String keyLocation, boolean secretKey, boolean verifyCertificateThumbprint, String issuer, Optional<String> decryptionKey) {
        return JWTAuthContextInfoProvider.create(publicKey, keyLocation, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), secretKey, verifyCertificateThumbprint, issuer, decryptionKey);
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String keyLocation, Optional<String> theKeyStoreType, Optional<String> theKeyStoreProvider, Optional<String> theKeyStorePassword, Optional<String> theKeyStoreVerifyKeyAlias, Optional<String> theKeyStoreDecryptKeyAlias, boolean secretKey, boolean verifyCertificateThumbprint, String issuer, Optional<String> decryptionKey) {
        JWTAuthContextInfoProvider provider = new JWTAuthContextInfoProvider();
        provider.mpJwtPublicKey = publicKey;
        provider.mpJwtPublicKeyAlgorithm = Optional.of(SignatureAlgorithm.RS256);
        provider.mpJwtLocation = !secretKey && !theKeyStoreDecryptKeyAlias.isPresent() ? keyLocation : NONE;
        provider.verifyKeyLocation = secretKey ? keyLocation : NONE;
        provider.verifyCertificateThumbprint = verifyCertificateThumbprint;
        provider.mpJwtIssuer = issuer;
        provider.mpJwtDecryptKeyLocation = theKeyStoreDecryptKeyAlias.isPresent() ? keyLocation : NONE;
        provider.jwtDecryptKey = decryptionKey;
        provider.decryptionKeyLocation = NONE;
        provider.mpJwtTokenHeader = Optional.of(AUTHORIZATION_HEADER);
        provider.mpJwtTokenCookie = Optional.of(BEARER_SCHEME);
        provider.tokenHeader = provider.mpJwtTokenHeader;
        provider.tokenCookie = provider.mpJwtTokenCookie;
        provider.tokenKeyId = Optional.empty();
        provider.tokenDecryptionKeyId = Optional.empty();
        provider.tokenSchemes = BEARER_SCHEME;
        provider.requireNamedPrincipal = Optional.of(Boolean.TRUE);
        provider.defaultSubClaim = Optional.empty();
        provider.subPath = Optional.empty();
        provider.defaultGroupsClaim = Optional.empty();
        provider.groupsPath = Optional.empty();
        provider.expGracePeriodSecs = 0;
        provider.maxTimeToLiveSecs = Optional.empty();
        provider.mpJwtVerifyClockSkew = 60;
        provider.mpJwtVerifyTokenAge = Optional.empty();
        provider.jwksRefreshInterval = 60;
        provider.forcedJwksRefreshInterval = 30;
        provider.signatureAlgorithm = Optional.of(SignatureAlgorithm.RS256);
        provider.keyEncryptionAlgorithm = Optional.empty();
        provider.mpJwtDecryptKeyAlgorithm = new HashSet<KeyEncryptionAlgorithm>(Arrays.asList(KeyEncryptionAlgorithm.RSA_OAEP, KeyEncryptionAlgorithm.RSA_OAEP_256));
        provider.keyFormat = KeyFormat.ANY;
        provider.keyProvider = KeyProvider.DEFAULT;
        provider.mpJwtVerifyAudiences = Optional.empty();
        provider.expectedAudience = Optional.empty();
        provider.groupsSeparator = DEFAULT_GROUPS_SEPARATOR;
        provider.requiredClaims = Optional.empty();
        provider.tlsCertificate = Optional.empty();
        provider.tlsCertificatePath = Optional.empty();
        provider.tlsTrustedHosts = Optional.empty();
        provider.httpProxyHost = Optional.empty();
        provider.httpProxyPort = 80;
        provider.keyStoreType = theKeyStoreType;
        provider.keyStoreProvider = theKeyStoreProvider;
        provider.keyStorePassword = theKeyStorePassword;
        provider.keyStoreVerifyKeyAlias = theKeyStoreVerifyKeyAlias;
        provider.keyStoreDecryptKeyAlias = theKeyStoreDecryptKeyAlias;
        provider.keyStoreDecryptKeyPassword = Optional.empty();
        return provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        Set<KeyEncryptionAlgorithm> theDecryptionKeyAlgorithm;
        Optional<Object> resolvedAlgorithm;
        JWTAuthContextInfo contextInfo;
        String resolvedVerifyKeyLocation;
        block75: {
            block80: {
                String theDecryptionKeyLocation;
                block79: {
                    block73: {
                        block78: {
                            block77: {
                                resolvedVerifyKeyLocation = !NONE.equals(this.verifyKeyLocation) ? this.verifyKeyLocation : this.mpJwtLocation;
                                contextInfo = new JWTAuthContextInfo();
                                if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
                                    contextInfo.setIssuedBy(this.mpJwtIssuer.trim());
                                }
                                if (NONE.equals(this.mpJwtPublicKey)) break block77;
                                contextInfo.setPublicKeyContent(this.mpJwtPublicKey);
                                break block73;
                            }
                            if (NONE.equals(resolvedVerifyKeyLocation)) break block78;
                            String resolvedVerifyKeyLocationTrimmed = resolvedVerifyKeyLocation.trim();
                            if (resolvedVerifyKeyLocationTrimmed.startsWith("http")) {
                                if (this.fetchRemoteKeysOnStartup) {
                                    try {
                                        InputStream is = ResourceUtils.getResourceStream((String)resolvedVerifyKeyLocationTrimmed);
                                        if (is == null) break block73;
                                        try (InputStream keyStream = is;){
                                            String KeyContent = new String(ResourceUtils.readBytes((InputStream)keyStream));
                                            contextInfo.setPublicKeyContent(KeyContent);
                                        }
                                        if (contextInfo.getPublicKeyContent() == null) {
                                            throw ConfigMessages.msg.invalidPublicKeyLocation();
                                        }
                                        break block73;
                                    }
                                    catch (Exception ex) {
                                        throw ConfigMessages.msg.readingPublicKeyLocationFailed((Throwable)ex);
                                    }
                                }
                                contextInfo.setPublicKeyLocation(resolvedVerifyKeyLocationTrimmed);
                                break block73;
                            } else {
                                if (this.isPublicKeyInKeystore()) {
                                    try {
                                        contextInfo.setPublicVerificationKey(this.getVerificationKeyFromKeystore(resolvedVerifyKeyLocationTrimmed));
                                    }
                                    catch (Exception ex) {
                                        throw ConfigMessages.msg.readingPublicKeyLocationFailed((Throwable)ex);
                                    }
                                }
                                try {
                                    contextInfo.setPublicKeyContent(ResourceUtils.readResource((String)resolvedVerifyKeyLocationTrimmed));
                                    if (contextInfo.getPublicKeyContent() == null) {
                                        throw ConfigMessages.msg.invalidPublicKeyLocation();
                                    }
                                    break block73;
                                }
                                catch (IOException ex) {
                                    throw ConfigMessages.msg.readingPublicKeyLocationFailed((Throwable)ex);
                                }
                            }
                        }
                        if (this.isPublicKeyInKeystore()) {
                            try {
                                contextInfo.setPublicVerificationKey(this.getVerificationKeyFromKeystore(null));
                            }
                            catch (Exception ex) {
                                throw ConfigMessages.msg.readingPublicKeyLocationFailed((Throwable)ex);
                            }
                        }
                    }
                    if (!NONE.equals(this.mpJwtDecryptKeyLocation)) {
                        theDecryptionKeyLocation = this.mpJwtDecryptKeyLocation;
                    } else if (!NONE.equals(this.decryptionKeyLocation)) {
                        ConfigLogging.log.replacedConfig("smallrye.jwt.decrypt.key.location", "mp.jwt.decrypt.key.location");
                        theDecryptionKeyLocation = this.decryptionKeyLocation;
                    } else {
                        theDecryptionKeyLocation = NONE;
                    }
                    if (!this.jwtDecryptKey.isPresent()) break block79;
                    contextInfo.setDecryptionKeyContent(this.jwtDecryptKey.get());
                    break block75;
                }
                if (NONE.equals(theDecryptionKeyLocation)) break block80;
                String decryptionKeyLocationTrimmed = theDecryptionKeyLocation.trim();
                if (decryptionKeyLocationTrimmed.startsWith("http")) {
                    if (this.fetchRemoteKeysOnStartup) {
                        try {
                            InputStream is = ResourceUtils.getResourceStream((String)decryptionKeyLocationTrimmed);
                            if (is == null) break block75;
                            try (InputStream keyStream = is;){
                                String KeyContent = new String(ResourceUtils.readBytes((InputStream)keyStream));
                                contextInfo.setDecryptionKeyContent(KeyContent);
                            }
                            if (contextInfo.getDecryptionKeyContent() == null) {
                                throw ConfigMessages.msg.invalidDecryptKeyLocation();
                            }
                            break block75;
                        }
                        catch (Exception ex) {
                            throw ConfigMessages.msg.readingDecryptKeyLocationFailed((Throwable)ex);
                        }
                    }
                    contextInfo.setDecryptionKeyLocation(decryptionKeyLocationTrimmed);
                    break block75;
                } else {
                    if (this.isPrivateKeyInKeystore()) {
                        try {
                            contextInfo.setPrivateDecryptionKey(this.getDecryptionKeyFromKeystore(decryptionKeyLocationTrimmed));
                        }
                        catch (Exception ex) {
                            throw ConfigMessages.msg.readingDecryptKeyLocationFailed((Throwable)ex);
                        }
                    }
                    try {
                        contextInfo.setDecryptionKeyContent(ResourceUtils.readResource((String)decryptionKeyLocationTrimmed));
                        if (contextInfo.getDecryptionKeyContent() == null) {
                            throw ConfigMessages.msg.invalidDecryptKeyLocation();
                        }
                        break block75;
                    }
                    catch (IOException ex) {
                        throw ConfigMessages.msg.readingDecryptKeyLocationFailed((Throwable)ex);
                    }
                }
            }
            if (this.isPrivateKeyInKeystore()) {
                try {
                    contextInfo.setPrivateDecryptionKey(this.getDecryptionKeyFromKeystore(null));
                }
                catch (Exception ex) {
                    throw ConfigMessages.msg.readingDecryptKeyLocationFailed((Throwable)ex);
                }
            }
        }
        if (this.mpJwtTokenHeader.isPresent()) {
            contextInfo.setTokenHeader(this.mpJwtTokenHeader.get());
        } else if (this.tokenHeader.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.token.header", "mp.jwt.token.header");
            contextInfo.setTokenHeader(this.tokenHeader.get());
        } else {
            contextInfo.setTokenHeader(AUTHORIZATION_HEADER);
        }
        if (this.mpJwtTokenCookie.isPresent()) {
            SmallryeJwtUtils.setContextTokenCookie((JWTAuthContextInfo)contextInfo, this.mpJwtTokenCookie);
        } else if (this.tokenCookie.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.token.cookie", "mp.jwt.token.cookie");
            SmallryeJwtUtils.setContextTokenCookie((JWTAuthContextInfo)contextInfo, this.tokenCookie);
        } else {
            SmallryeJwtUtils.setContextTokenCookie((JWTAuthContextInfo)contextInfo, Optional.of(BEARER_SCHEME));
        }
        if (this.expGracePeriodSecs > 0) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.expiration.grace", "mp.jwt.verify.clock.skew");
            contextInfo.setClockSkew(this.expGracePeriodSecs);
        } else if (this.mpJwtVerifyClockSkew > 0) {
            contextInfo.setClockSkew(this.mpJwtVerifyClockSkew);
        }
        contextInfo.setAlwaysCheckAuthorization(this.alwaysCheckAuthorization);
        contextInfo.setTokenKeyId((String)this.tokenKeyId.orElse(null));
        contextInfo.setTokenDecryptionKeyId((String)this.tokenDecryptionKeyId.orElse(null));
        contextInfo.setRequireNamedPrincipal(((Boolean)this.requireNamedPrincipal.orElse(null)).booleanValue());
        SmallryeJwtUtils.setTokenSchemes((JWTAuthContextInfo)contextInfo, (String)this.tokenSchemes);
        contextInfo.setDefaultSubjectClaim((String)this.defaultSubClaim.orElse(null));
        SmallryeJwtUtils.setContextSubPath((JWTAuthContextInfo)contextInfo, this.subPath);
        contextInfo.setDefaultGroupsClaim((String)this.defaultGroupsClaim.orElse(null));
        contextInfo.setTlsCertificate((String)this.tlsCertificate.orElse(null));
        contextInfo.setTlsCertificatePath((String)this.tlsCertificatePath.orElse(null));
        contextInfo.setTlsTrustedHosts((Set)this.tlsTrustedHosts.orElse(null));
        contextInfo.setTlsTrustAll(this.tlsTrustAll);
        contextInfo.setHttpProxyHost((String)this.httpProxyHost.orElse(null));
        contextInfo.setHttpProxyPort(this.httpProxyPort);
        SmallryeJwtUtils.setContextGroupsPath((JWTAuthContextInfo)contextInfo, this.groupsPath);
        contextInfo.setMaxTimeToLiveSecs((Long)this.maxTimeToLiveSecs.orElse(null));
        contextInfo.setTokenAge((Long)this.mpJwtVerifyTokenAge.orElse(null));
        contextInfo.setJwksRefreshInterval(Integer.valueOf(this.jwksRefreshInterval));
        contextInfo.setForcedJwksRefreshInterval(this.forcedJwksRefreshInterval);
        if (this.mpJwtPublicKeyAlgorithm.isPresent()) {
            resolvedAlgorithm = this.mpJwtPublicKeyAlgorithm;
        } else if (this.signatureAlgorithm.isPresent()) {
            if (this.signatureAlgorithm.get().getAlgorithm().startsWith("HS")) {
                if (resolvedVerifyKeyLocation == this.mpJwtLocation) {
                    throw ConfigMessages.msg.hmacNotSupported();
                }
            } else {
                ConfigLogging.log.replacedConfig("smallrye.jwt.verify.algorithm", "mp.jwt.verify.publickey.algorithm");
            }
            resolvedAlgorithm = this.signatureAlgorithm;
        } else {
            resolvedAlgorithm = Optional.empty();
        }
        if (resolvedAlgorithm.isPresent()) {
            contextInfo.setSignatureAlgorithm((SignatureAlgorithm)resolvedAlgorithm.get());
        } else {
            contextInfo.setSignatureAlgorithm(SignatureAlgorithm.RS256);
        }
        if (!this.keyEncryptionAlgorithm.isEmpty()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.decrypt.algorithm", "mp.jwt.decrypt.key.algorithm");
            theDecryptionKeyAlgorithm = Collections.singleton(this.keyEncryptionAlgorithm.get());
        } else {
            theDecryptionKeyAlgorithm = this.mpJwtDecryptKeyAlgorithm;
        }
        contextInfo.setKeyEncryptionAlgorithm(theDecryptionKeyAlgorithm);
        contextInfo.setKeyFormat(this.keyFormat);
        contextInfo.setKeyProvider(this.keyProvider);
        contextInfo.setKeyCacheSize(this.keyCacheSize);
        contextInfo.setKeyCacheTimeToLive(this.keyCacheTimeToLive);
        if (this.mpJwtVerifyAudiences.isPresent()) {
            contextInfo.setExpectedAudience(this.mpJwtVerifyAudiences.get());
        } else if (this.expectedAudience.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.verify.aud", "mp.jwt.verify.audiences");
            contextInfo.setExpectedAudience(this.expectedAudience.get());
        } else {
            contextInfo.setExpectedAudience(null);
        }
        contextInfo.setGroupsSeparator(this.groupsSeparator);
        contextInfo.setRequiredClaims((Set)this.requiredClaims.orElse(null));
        contextInfo.setRelaxVerificationKeyValidation(this.relaxVerificationKeyValidation);
        contextInfo.setVerifyCertificateThumbprint(this.verifyCertificateThumbprint);
        return Optional.of(contextInfo);
    }

    private PublicKey getVerificationKeyFromKeystore(String keyStorePath) throws Exception {
        KeyStore keyStore = KeyUtils.loadKeyStore((String)keyStorePath, (String)this.keyStorePassword.get(), this.keyStoreType, this.keyStoreProvider);
        return keyStore.getCertificate(this.keyStoreVerifyKeyAlias.get()).getPublicKey();
    }

    private PrivateKey getDecryptionKeyFromKeystore(String keyStorePath) throws Exception {
        KeyStore keyStore = KeyUtils.loadKeyStore((String)keyStorePath, (String)this.keyStorePassword.get(), this.keyStoreType, this.keyStoreProvider);
        return (PrivateKey)keyStore.getKey(this.keyStoreDecryptKeyAlias.get(), this.keyStoreDecryptKeyPassword.orElse(this.keyStorePassword.get()).toCharArray());
    }

    private boolean isPublicKeyInKeystore() {
        return this.keyStorePassword.isPresent() && this.keyStoreVerifyKeyAlias.isPresent();
    }

    private boolean isPrivateKeyInKeystore() {
        return this.keyStorePassword.isPresent() && this.keyStoreDecryptKeyAlias.isPresent();
    }

    @Produces
    @ApplicationScoped
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

