/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.openapi.v30.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.io.ModelReader;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Callback;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Components;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Contact;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Discriminator;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30DocumentImpl;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Encoding;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Example;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30ExternalDocumentation;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Header;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Info;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30License;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Link;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30MediaType;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30OAuthFlow;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30OAuthFlows;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Operation;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30PathItem;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Paths;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30RequestBody;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Response;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Responses;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30SecurityRequirement;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30SecurityScheme;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Server;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30ServerVariable;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Tag;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30XML;
import io.apicurio.datamodels.models.union.BooleanUnionValueImpl;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.ReaderUtil;
import java.util.List;
import java.util.Map;

public class OpenApi30ModelReader
implements ModelReader {
    public void readDocument(ObjectNode json, OpenApi30Document node) {
        List<ObjectNode> objects;
        String value = JsonUtil.consumeStringProperty(json, "openapi");
        node.setOpenapi(value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "info");
        if (object2 != null) {
            node.setInfo(node.createInfo());
            this.readInfo(object2, (OpenApi30Info)node.getInfo());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "servers")) != null) {
            objects.forEach(object -> {
                OpenApi30Server model = node.createServer();
                this.readServer((ObjectNode)object, model);
                node.addServer(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "paths")) != null) {
            node.setPaths(node.createPaths());
            this.readPaths(object2, (OpenApi30Paths)node.getPaths());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "components")) != null) {
            node.setComponents(node.createComponents());
            this.readComponents(object2, node.getComponents());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "security")) != null) {
            objects.forEach(object -> {
                OpenApi30SecurityRequirement model = (OpenApi30SecurityRequirement)node.createSecurityRequirement();
                this.readSecurityRequirement((ObjectNode)object, model);
                node.addSecurity(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "tags")) != null) {
            objects.forEach(object -> {
                OpenApi30Tag model = (OpenApi30Tag)node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi30ExternalDocumentation)node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    @Override
    public RootNode readRoot(ObjectNode json) {
        OpenApi30DocumentImpl rootModel = new OpenApi30DocumentImpl();
        this.readDocument(json, rootModel);
        return rootModel;
    }

    public void readInfo(ObjectNode json, OpenApi30Info node) {
        String value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "termsOfService");
        node.setTermsOfService(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "contact");
        if (object != null) {
            node.setContact(node.createContact());
            this.readContact(object, (OpenApi30Contact)node.getContact());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "license")) != null) {
            node.setLicense(node.createLicense());
            this.readLicense(object, (OpenApi30License)node.getLicense());
        }
        value = JsonUtil.consumeStringProperty(json, "version");
        node.setVersion(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readContact(ObjectNode json, OpenApi30Contact node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        value = JsonUtil.consumeStringProperty(json, "email");
        node.setEmail(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readLicense(ObjectNode json, OpenApi30License node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServer(ObjectNode json, OpenApi30Server node) {
        String value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "variables");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30ServerVariable model = (OpenApi30ServerVariable)node.createServerVariable();
                this.readServerVariable(mapValue, model);
                node.addVariable((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServerVariable(ObjectNode json, OpenApi30ServerVariable node) {
        Object value = JsonUtil.consumeStringArrayProperty(json, "enum");
        node.setEnum((List<String>)value);
        value = JsonUtil.consumeStringProperty(json, "default");
        node.setDefault((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readComponents(ObjectNode json, OpenApi30Components node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schemas");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Schema model = (OpenApi30Schema)node.createSchema();
                this.readSchema(mapValue, model);
                node.addSchema((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "responses");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Response model = (OpenApi30Response)node.createResponse();
                this.readResponse(mapValue, model);
                node.addResponse((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "parameters");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Parameter model = (OpenApi30Parameter)node.createParameter();
                this.readParameter(mapValue, model);
                node.addParameter((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Example model = (OpenApi30Example)node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "requestBodies");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30RequestBody model = (OpenApi30RequestBody)node.createRequestBody();
                this.readRequestBody(mapValue, model);
                node.addRequestBody((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "headers");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Header model = (OpenApi30Header)node.createHeader();
                this.readHeader(mapValue, model);
                node.addHeader((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "securitySchemes");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30SecurityScheme model = (OpenApi30SecurityScheme)node.createSecurityScheme();
                this.readSecurityScheme(mapValue, model);
                node.addSecurityScheme((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "links");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Link model = (OpenApi30Link)node.createLink();
                this.readLink(mapValue, model);
                node.addLink((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "callbacks");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Callback model = (OpenApi30Callback)node.createCallback();
                this.readCallback(mapValue, model);
                node.addCallback((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readPaths(ObjectNode json, OpenApi30Paths node) {
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi30PathItem model = (OpenApi30PathItem)node.createPathItem();
                this.readPathItem(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readPathItem(ObjectNode json, OpenApi30PathItem node) {
        List<ObjectNode> objects;
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "get");
        if (object2 != null) {
            node.setGet(node.createOperation());
            this.readOperation(object2, (OpenApi30Operation)node.getGet());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "put")) != null) {
            node.setPut(node.createOperation());
            this.readOperation(object2, (OpenApi30Operation)node.getPut());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "post")) != null) {
            node.setPost(node.createOperation());
            this.readOperation(object2, (OpenApi30Operation)node.getPost());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "delete")) != null) {
            node.setDelete(node.createOperation());
            this.readOperation(object2, (OpenApi30Operation)node.getDelete());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "options")) != null) {
            node.setOptions(node.createOperation());
            this.readOperation(object2, (OpenApi30Operation)node.getOptions());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "head")) != null) {
            node.setHead(node.createOperation());
            this.readOperation(object2, (OpenApi30Operation)node.getHead());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "patch")) != null) {
            node.setPatch(node.createOperation());
            this.readOperation(object2, (OpenApi30Operation)node.getPatch());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "trace")) != null) {
            node.setTrace(node.createOperation());
            this.readOperation(object2, node.getTrace());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "servers")) != null) {
            objects.forEach(object -> {
                OpenApi30Server model = node.createServer();
                this.readServer((ObjectNode)object, model);
                node.addServer(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "parameters")) != null) {
            objects.forEach(object -> {
                OpenApi30Parameter model = (OpenApi30Parameter)node.createParameter();
                this.readParameter((ObjectNode)object, model);
                node.addParameter(model);
            });
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOperation(ObjectNode json, OpenApi30Operation node) {
        Object value = JsonUtil.consumeStringArrayProperty(json, "tags");
        node.setTags((List<String>)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object2 != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi30ExternalDocumentation)node.getExternalDocs());
        }
        value = JsonUtil.consumeStringProperty(json, "operationId");
        node.setOperationId((String)value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "parameters");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi30Parameter model = (OpenApi30Parameter)node.createParameter();
                this.readParameter((ObjectNode)object, model);
                node.addParameter(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "requestBody")) != null) {
            node.setRequestBody(node.createRequestBody());
            this.readRequestBody(object2, node.getRequestBody());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "responses")) != null) {
            node.setResponses(node.createResponses());
            this.readResponses(object2, (OpenApi30Responses)node.getResponses());
        }
        object2 = JsonUtil.consumeObjectProperty(json, "callbacks");
        JsonUtil.keys(object2).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object2, name);
            if (mapValue != null) {
                OpenApi30Callback model = node.createCallback();
                this.readCallback(mapValue, model);
                node.addCallback((String)name, model);
            }
        });
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        objects = JsonUtil.consumeObjectArrayProperty(json, "security");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi30SecurityRequirement model = (OpenApi30SecurityRequirement)node.createSecurityRequirement();
                this.readSecurityRequirement((ObjectNode)object, model);
                node.addSecurity(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "servers")) != null) {
            objects.forEach(object -> {
                OpenApi30Server model = node.createServer();
                this.readServer((ObjectNode)object, model);
                node.addServer(model);
            });
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readExternalDocumentation(ObjectNode json, OpenApi30ExternalDocumentation node) {
        String value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readParameter(ObjectNode json, OpenApi30Parameter node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "in");
        node.setIn((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "required");
        node.setRequired((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowEmptyValue");
        node.setAllowEmptyValue((Boolean)value);
        value = JsonUtil.consumeStringProperty(json, "style");
        node.setStyle((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "explode");
        node.setExplode((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowReserved");
        node.setAllowReserved((Boolean)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, (OpenApi30Schema)node.getSchema());
        }
        value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample((JsonNode)value);
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Example model = node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30MediaType model = node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readRequestBody(ObjectNode json, OpenApi30RequestBody node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30MediaType model = (OpenApi30MediaType)node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        value = JsonUtil.consumeBooleanProperty(json, "required");
        node.setRequired((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readMediaType(ObjectNode json, OpenApi30MediaType node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, (OpenApi30Schema)node.getSchema());
        }
        JsonNode value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample(value);
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Example model = (OpenApi30Example)node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "encoding");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Encoding model = (OpenApi30Encoding)node.createEncoding();
                this.readEncoding(mapValue, model);
                node.addEncoding((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readEncoding(ObjectNode json, OpenApi30Encoding node) {
        Object value = JsonUtil.consumeStringProperty(json, "contentType");
        node.setContentType((String)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "headers");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Header model = (OpenApi30Header)node.createHeader();
                this.readHeader(mapValue, model);
                node.addHeader((String)name, model);
            }
        });
        value = JsonUtil.consumeStringProperty(json, "style");
        node.setStyle((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "explode");
        node.setExplode((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowReserved");
        node.setAllowReserved((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readResponses(ObjectNode json, OpenApi30Responses node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "default");
        if (object != null) {
            node.setDefault(node.createResponse());
            this.readResponse(object, (OpenApi30Response)node.getDefault());
        }
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi30Response model = (OpenApi30Response)node.createResponse();
                this.readResponse(object, model);
                node.addItem((String)name, model);
            }
        });
        propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readResponse(ObjectNode json, OpenApi30Response node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "headers");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Header model = node.createHeader();
                this.readHeader(mapValue, model);
                node.addHeader((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30MediaType model = node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "links");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Link model = node.createLink();
                this.readLink(mapValue, model);
                node.addLink((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readCallback(ObjectNode json, OpenApi30Callback node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi30PathItem model = (OpenApi30PathItem)node.createPathItem();
                this.readPathItem(object, model);
                node.addItem((String)name, model);
            }
        });
        propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readExample(ObjectNode json, OpenApi30Example node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeAnyProperty(json, "value");
        node.setValue((JsonNode)value);
        value = JsonUtil.consumeStringProperty(json, "externalValue");
        node.setExternalValue(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readLink(ObjectNode json, OpenApi30Link node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "operationRef");
        node.setOperationRef((String)value);
        value = JsonUtil.consumeStringProperty(json, "operationId");
        node.setOperationId((String)value);
        value = JsonUtil.consumeAnyMapProperty(json, "parameters");
        node.setParameters((Map<String, JsonNode>)value);
        value = JsonUtil.consumeAnyProperty(json, "requestBody");
        node.setRequestBody((JsonNode)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "server");
        if (object != null) {
            node.setServer(node.createServer());
            this.readServer(object, (OpenApi30Server)node.getServer());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readHeader(ObjectNode json, OpenApi30Header node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "required");
        node.setRequired((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowEmptyValue");
        node.setAllowEmptyValue((Boolean)value);
        value = JsonUtil.consumeStringProperty(json, "style");
        node.setStyle((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "explode");
        node.setExplode((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowReserved");
        node.setAllowReserved((Boolean)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, node.getSchema());
        }
        value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample((JsonNode)value);
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30Example model = node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi30MediaType model = node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readTag(ObjectNode json, OpenApi30Tag node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object, (OpenApi30ExternalDocumentation)node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSchema(ObjectNode json, OpenApi30Schema node) {
        List<ObjectNode> objects;
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "format");
        node.setFormat((String)value);
        value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeAnyProperty(json, "default");
        node.setDefault((JsonNode)value);
        value = JsonUtil.consumeNumberProperty(json, "multipleOf");
        node.setMultipleOf((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "maximum");
        node.setMaximum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMaximum");
        node.setExclusiveMaximum((Boolean)value);
        value = JsonUtil.consumeNumberProperty(json, "minimum");
        node.setMinimum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMinimum");
        node.setExclusiveMinimum((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxLength");
        node.setMaxLength((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minLength");
        node.setMinLength((Integer)value);
        value = JsonUtil.consumeStringProperty(json, "pattern");
        node.setPattern((String)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxItems");
        node.setMaxItems((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minItems");
        node.setMinItems((Integer)value);
        value = JsonUtil.consumeBooleanProperty(json, "uniqueItems");
        node.setUniqueItems((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxProperties");
        node.setMaxProperties((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minProperties");
        node.setMinProperties((Integer)value);
        value = JsonUtil.consumeStringArrayProperty(json, "required");
        node.setRequired((List<String>)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "enum");
        node.setEnum((List<JsonNode>)value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType((String)value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "items");
        if (object2 != null) {
            node.setItems(node.createSchema());
            this.readSchema(object2, node.getItems());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "allOf")) != null) {
            objects.forEach(object -> {
                OpenApi30Schema model = node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addAllOf(model);
            });
        }
        object2 = JsonUtil.consumeObjectProperty(json, "properties");
        JsonUtil.keys(object2).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object2, name);
            if (mapValue != null) {
                OpenApi30Schema model = node.createSchema();
                this.readSchema(mapValue, model);
                node.addProperty((String)name, model);
            }
        });
        value = JsonUtil.consumeAnyProperty(json, "additionalProperties");
        if (value != null) {
            if (JsonUtil.isObject((JsonNode)value)) {
                ObjectNode object3 = JsonUtil.toObject((JsonNode)value);
                node.setAdditionalProperties(node.createSchema());
                this.readSchema(object3, (OpenApi30Schema)node.getAdditionalProperties());
            } else if (JsonUtil.isBoolean((JsonNode)value)) {
                Boolean pValue = JsonUtil.toBoolean((JsonNode)value);
                BooleanUnionValueImpl unionValue = new BooleanUnionValueImpl(pValue);
                node.setAdditionalProperties(unionValue);
            } else {
                node.addExtraProperty("additionalProperties", (JsonNode)value);
            }
        }
        value = JsonUtil.consumeBooleanProperty(json, "readOnly");
        node.setReadOnly((Boolean)value);
        object2 = JsonUtil.consumeObjectProperty(json, "xml");
        if (object2 != null) {
            node.setXml(node.createXML());
            this.readXML(object2, (OpenApi30XML)node.getXml());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi30ExternalDocumentation)node.getExternalDocs());
        }
        value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample((JsonNode)value);
        objects = JsonUtil.consumeObjectArrayProperty(json, "oneOf");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi30Schema model = node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addOneOf(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "anyOf")) != null) {
            objects.forEach(object -> {
                OpenApi30Schema model = node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addAnyOf(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "not")) != null) {
            node.setNot(node.createSchema());
            this.readSchema(object2, node.getNot());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "discriminator")) != null) {
            node.setDiscriminator(node.createDiscriminator());
            this.readDiscriminator(object2, node.getDiscriminator());
        }
        value = JsonUtil.consumeBooleanProperty(json, "nullable");
        node.setNullable((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "writeOnly");
        node.setWriteOnly((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readDiscriminator(ObjectNode json, OpenApi30Discriminator node) {
        Object value = JsonUtil.consumeStringProperty(json, "propertyName");
        node.setPropertyName((String)value);
        value = JsonUtil.consumeStringMapProperty(json, "mapping");
        node.setMapping((Map<String, String>)value);
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readXML(ObjectNode json, OpenApi30XML node) {
        Object value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "namespace");
        node.setNamespace((String)value);
        value = JsonUtil.consumeStringProperty(json, "prefix");
        node.setPrefix((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "attribute");
        node.setAttribute((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "wrapped");
        node.setWrapped((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityScheme(ObjectNode json, OpenApi30SecurityScheme node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "in");
        node.setIn(value);
        value = JsonUtil.consumeStringProperty(json, "scheme");
        node.setScheme(value);
        value = JsonUtil.consumeStringProperty(json, "bearerFormat");
        node.setBearerFormat(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "flows");
        if (object != null) {
            node.setFlows(node.createOAuthFlows());
            this.readOAuthFlows(object, node.getFlows());
        }
        value = JsonUtil.consumeStringProperty(json, "openIdConnectUrl");
        node.setOpenIdConnectUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOAuthFlows(ObjectNode json, OpenApi30OAuthFlows node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "implicit");
        if (object != null) {
            node.setImplicit(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi30OAuthFlow)node.getImplicit());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "password")) != null) {
            node.setPassword(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi30OAuthFlow)node.getPassword());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "clientCredentials")) != null) {
            node.setClientCredentials(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi30OAuthFlow)node.getClientCredentials());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "authorizationCode")) != null) {
            node.setAuthorizationCode(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi30OAuthFlow)node.getAuthorizationCode());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOAuthFlow(ObjectNode json, OpenApi30OAuthFlow node) {
        Object value = JsonUtil.consumeStringProperty(json, "authorizationUrl");
        node.setAuthorizationUrl((String)value);
        value = JsonUtil.consumeStringProperty(json, "tokenUrl");
        node.setTokenUrl((String)value);
        value = JsonUtil.consumeStringProperty(json, "refreshUrl");
        node.setRefreshUrl((String)value);
        value = JsonUtil.consumeStringMapProperty(json, "scopes");
        node.setScopes((Map<String, String>)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityRequirement(ObjectNode json, OpenApi30SecurityRequirement node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            List<String> value = JsonUtil.consumeStringArrayProperty(json, name);
            node.addItem((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }
}

