/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JsonUtil {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;
    private static final ObjectMapper mapper = new ObjectMapper();

    public static List<String> keys(ObjectNode json) {
        ArrayList<String> rval = new ArrayList<String>();
        if (json != null) {
            Iterator fieldNames = json.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                rval.add(fieldName);
            }
        }
        return rval;
    }

    public static List<String> matchingKeys(String regex, ObjectNode json) {
        return JsonUtil.keys(json).stream().filter(key -> Pattern.matches(regex, key)).collect(Collectors.toList());
    }

    public static JsonNode getProperty(ObjectNode json, String propertyName) {
        if (json.has(propertyName)) {
            return json.get(propertyName);
        }
        return null;
    }

    public static void setProperty(ObjectNode json, String propertyName, JsonNode value) {
        if (value != null) {
            json.set(propertyName, value);
        }
    }

    public static ObjectNode getObjectProperty(ObjectNode json, String propertyName) {
        JsonNode objectNode;
        if (json.has(propertyName) && (objectNode = json.get(propertyName)).isObject()) {
            return (ObjectNode)objectNode;
        }
        return null;
    }

    public static ObjectNode consumeObjectProperty(ObjectNode json, String propertyName) {
        ObjectNode rval;
        if (json.has(propertyName) && (rval = JsonUtil.getObjectProperty(json, propertyName)) != null) {
            json.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static JsonNode getAnyProperty(ObjectNode json, String propertyName) {
        JsonNode jsonNode;
        if (json.has(propertyName) && !(jsonNode = json.get(propertyName)).isNull()) {
            return jsonNode;
        }
        return null;
    }

    public static JsonNode consumeAnyProperty(ObjectNode json, String propertyName) {
        if (json.has(propertyName)) {
            JsonNode rval = JsonUtil.getAnyProperty(json, propertyName);
            json.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static List<JsonNode> getAnyArrayProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isArray()) {
            ArrayNode array = (ArrayNode)node;
            ArrayList<JsonNode> rval = new ArrayList<JsonNode>();
            for (JsonNode item : array) {
                rval.add(item);
            }
            return rval;
        }
        return null;
    }

    public static List<JsonNode> consumeAnyArrayProperty(ObjectNode json, String propertyName) {
        List<JsonNode> rval = JsonUtil.getAnyArrayProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static List<ObjectNode> getObjectArrayProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isArray()) {
            ArrayNode array = (ArrayNode)node;
            ArrayList<ObjectNode> rval = new ArrayList<ObjectNode>();
            for (JsonNode item : array) {
                if (!item.isObject()) continue;
                rval.add((ObjectNode)item);
            }
            return rval;
        }
        return null;
    }

    public static List<ObjectNode> consumeObjectArrayProperty(ObjectNode json, String propertyName) {
        List<ObjectNode> rval = JsonUtil.getObjectArrayProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static List<String> getStringArrayProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isArray()) {
            ArrayNode array = (ArrayNode)node;
            ArrayList<String> rval = new ArrayList<String>();
            for (JsonNode item : array) {
                rval.add(item.isNull() ? null : item.asText());
            }
            return rval;
        }
        return null;
    }

    public static List<String> consumeStringArrayProperty(ObjectNode json, String propertyName) {
        ObjectNode node = json;
        if (node.has(propertyName)) {
            List<String> rval = JsonUtil.getStringArrayProperty(json, propertyName);
            node.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static List<Integer> getIntegerArrayProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isArray()) {
            ArrayNode array = (ArrayNode)node;
            ArrayList<Integer> rval = new ArrayList<Integer>();
            for (JsonNode item : array) {
                if (!item.isInt()) continue;
                rval.add(item.asInt());
            }
            return rval;
        }
        return null;
    }

    public static List<Integer> consumeIntegerArrayProperty(ObjectNode json, String propertyName) {
        ObjectNode node = json;
        if (node.has(propertyName)) {
            List<Integer> rval = JsonUtil.getIntegerArrayProperty(json, propertyName);
            node.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static List<Number> getNumberArrayProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isArray()) {
            ArrayNode array = (ArrayNode)node;
            ArrayList<Number> rval = new ArrayList<Number>();
            for (JsonNode item : array) {
                if (item.isInt()) {
                    rval.add(item.asInt());
                }
                if (item.isLong()) {
                    rval.add(item.asLong());
                }
                if (!item.isFloat() && !item.isDouble() && !item.isBigDecimal() && !item.isBigInteger()) continue;
                rval.add(item.asDouble());
            }
            return rval;
        }
        return null;
    }

    public static List<Number> consumeNumberArrayProperty(ObjectNode json, String propertyName) {
        ObjectNode node = json;
        if (node.has(propertyName)) {
            List<Number> rval = JsonUtil.getNumberArrayProperty(json, propertyName);
            node.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static List<Boolean> getBooleanArrayProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isArray()) {
            ArrayNode array = (ArrayNode)node;
            ArrayList<Boolean> rval = new ArrayList<Boolean>();
            for (JsonNode item : array) {
                if (!item.isBoolean()) continue;
                rval.add(item.asBoolean());
            }
            return rval;
        }
        return null;
    }

    public static List<Boolean> consumeBooleanArrayProperty(ObjectNode json, String propertyName) {
        ObjectNode node = json;
        if (node.has(propertyName)) {
            List<Boolean> rval = JsonUtil.getBooleanArrayProperty(json, propertyName);
            node.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static String getStringProperty(ObjectNode json, String propertyName) {
        JsonNode textNode;
        if (json.has(propertyName) && (textNode = json.get(propertyName)).isTextual()) {
            return textNode.asText();
        }
        return null;
    }

    public static String consumeStringProperty(ObjectNode json, String propertyName) {
        String rval;
        if (json.has(propertyName) && (rval = JsonUtil.getStringProperty(json, propertyName)) != null) {
            json.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static Integer getIntegerProperty(ObjectNode json, String propertyName) {
        JsonNode textNode;
        if (json.has(propertyName) && (textNode = json.get(propertyName)).isInt()) {
            return textNode.asInt();
        }
        return null;
    }

    public static Integer consumeIntegerProperty(ObjectNode json, String propertyName) {
        Integer rval;
        if (json.has(propertyName) && (rval = JsonUtil.getIntegerProperty(json, propertyName)) != null) {
            json.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static Number getNumberProperty(ObjectNode json, String propertyName) {
        if (json.has(propertyName)) {
            JsonNode node = json.get(propertyName);
            if (node.isInt()) {
                return node.asInt();
            }
            if (node.isLong()) {
                return node.asLong();
            }
            if (node.isFloat() || node.isDouble()) {
                return node.asDouble();
            }
        }
        return null;
    }

    public static Number consumeNumberProperty(ObjectNode json, String propertyName) {
        Number rval;
        if (json.has(propertyName) && (rval = JsonUtil.getNumberProperty(json, propertyName)) != null) {
            json.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static Boolean getBooleanProperty(ObjectNode json, String propertyName) {
        JsonNode textNode;
        if (json.has(propertyName) && (textNode = json.get(propertyName)).isBoolean()) {
            return textNode.asBoolean();
        }
        return null;
    }

    public static Boolean consumeBooleanProperty(ObjectNode json, String propertyName) {
        Boolean rval;
        if (json.has(propertyName) && (rval = JsonUtil.getBooleanProperty(json, propertyName)) != null) {
            json.remove(propertyName);
            return rval;
        }
        return null;
    }

    public static Map<String, JsonNode> getAnyMapProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isObject()) {
            ObjectNode object = (ObjectNode)node;
            LinkedHashMap<String, JsonNode> rval = new LinkedHashMap<String, JsonNode>();
            List<String> keys = JsonUtil.keys(object);
            keys.forEach(key -> rval.put((String)key, JsonUtil.getAnyProperty(object, key)));
            return rval;
        }
        return null;
    }

    public static Map<String, JsonNode> consumeAnyMapProperty(ObjectNode json, String propertyName) {
        Map<String, JsonNode> rval = JsonUtil.getAnyMapProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static Map<String, ObjectNode> getObjectMapProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isObject()) {
            ObjectNode object = (ObjectNode)node;
            LinkedHashMap<String, ObjectNode> rval = new LinkedHashMap<String, ObjectNode>();
            List<String> keys = JsonUtil.keys(object);
            keys.forEach(key -> rval.put((String)key, JsonUtil.getObjectProperty(object, key)));
            return rval;
        }
        return null;
    }

    public static Map<String, ObjectNode> consumeObjectMapProperty(ObjectNode json, String propertyName) {
        Map<String, ObjectNode> rval = JsonUtil.getObjectMapProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static Map<String, String> getStringMapProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isObject()) {
            ObjectNode object = (ObjectNode)node;
            LinkedHashMap<String, String> rval = new LinkedHashMap<String, String>();
            List<String> keys = JsonUtil.keys(object);
            keys.forEach(key -> rval.put((String)key, JsonUtil.getStringProperty(object, key)));
            return rval;
        }
        return null;
    }

    public static Map<String, String> consumeStringMapProperty(ObjectNode json, String propertyName) {
        Map<String, String> rval = JsonUtil.getStringMapProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static Map<String, Integer> getIntegerMapProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isObject()) {
            ObjectNode object = (ObjectNode)node;
            LinkedHashMap<String, Integer> rval = new LinkedHashMap<String, Integer>();
            List<String> keys = JsonUtil.keys(object);
            keys.forEach(key -> rval.put((String)key, JsonUtil.getIntegerProperty(object, key)));
            return rval;
        }
        return null;
    }

    public static Map<String, Integer> consumeIntegerMapProperty(ObjectNode json, String propertyName) {
        Map<String, Integer> rval = JsonUtil.getIntegerMapProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static Map<String, Number> getNumberMapProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isObject()) {
            ObjectNode object = (ObjectNode)node;
            LinkedHashMap<String, Number> rval = new LinkedHashMap<String, Number>();
            List<String> keys = JsonUtil.keys(object);
            keys.forEach(key -> rval.put((String)key, JsonUtil.getNumberProperty(object, key)));
            return rval;
        }
        return null;
    }

    public static Map<String, Number> consumeNumberMapProperty(ObjectNode json, String propertyName) {
        Map<String, Number> rval = JsonUtil.getNumberMapProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static Map<String, Boolean> getBooleanMapProperty(ObjectNode json, String propertyName) {
        if (!json.has(propertyName)) {
            return null;
        }
        JsonNode node = json.get(propertyName);
        if (node.isObject()) {
            ObjectNode object = (ObjectNode)node;
            LinkedHashMap<String, Boolean> rval = new LinkedHashMap<String, Boolean>();
            List<String> keys = JsonUtil.keys(object);
            keys.forEach(key -> rval.put((String)key, JsonUtil.getBooleanProperty(object, key)));
            return rval;
        }
        return null;
    }

    public static Map<String, Boolean> consumeBooleanMapProperty(ObjectNode json, String propertyName) {
        Map<String, Boolean> rval = JsonUtil.getBooleanMapProperty(json, propertyName);
        if (rval != null) {
            json.remove(propertyName);
        }
        return rval;
    }

    public static void setObjectProperty(ObjectNode json, String propertyName, ObjectNode value) {
        if (value != null) {
            json.set(propertyName, (JsonNode)value);
        }
    }

    public static void setAnyProperty(ObjectNode json, String propertyName, JsonNode value) {
        if (value != null) {
            json.set(propertyName, value);
        }
    }

    public static void setAnyArrayProperty(ObjectNode json, String propertyName, List<JsonNode> value) {
        if (value != null) {
            ArrayNode array = json.arrayNode(value.size());
            value.forEach(v -> array.add(v));
            json.set(propertyName, (JsonNode)array);
        }
    }

    public static void setObjectArrayProperty(ObjectNode json, String propertyName, List<ObjectNode> value) {
        if (value != null) {
            ArrayNode array = json.arrayNode(value.size());
            value.forEach(v -> array.add((JsonNode)v));
            json.set(propertyName, (JsonNode)array);
        }
    }

    public static void setStringArrayProperty(ObjectNode json, String propertyName, List<String> value) {
        if (value != null) {
            ArrayNode array = json.arrayNode(value.size());
            value.forEach(v -> array.add(v));
            json.set(propertyName, (JsonNode)array);
        }
    }

    public static void setIntegerArrayProperty(ObjectNode json, String propertyName, List<Integer> value) {
        if (value != null) {
            ArrayNode array = json.arrayNode(value.size());
            value.forEach(v -> array.add(v));
            json.set(propertyName, (JsonNode)array);
        }
    }

    public static void setNumberArrayProperty(ObjectNode json, String propertyName, List<Number> value) {
        if (value != null) {
            ArrayNode array = json.arrayNode(value.size());
            value.forEach(v -> array.add(v != null ? Double.valueOf(v.doubleValue()) : null));
            json.set(propertyName, (JsonNode)array);
        }
    }

    public static void setBooleanArrayProperty(ObjectNode json, String propertyName, List<Boolean> value) {
        if (value != null) {
            ArrayNode array = json.arrayNode(value.size());
            value.forEach(v -> array.add(v));
            json.set(propertyName, (JsonNode)array);
        }
    }

    public static void setStringProperty(ObjectNode json, String propertyName, String value) {
        if (value != null) {
            json.set(propertyName, (JsonNode)factory.textNode(value));
        }
    }

    public static void setIntegerProperty(ObjectNode json, String propertyName, Integer value) {
        if (value != null) {
            json.set(propertyName, (JsonNode)factory.numberNode(value));
        }
    }

    public static void setNumberProperty(ObjectNode json, String propertyName, Number value) {
        if (value != null) {
            json.set(propertyName, (JsonNode)factory.numberNode(value.doubleValue()));
        }
    }

    public static void setBooleanProperty(ObjectNode json, String propertyName, Boolean value) {
        if (value != null) {
            json.set(propertyName, (JsonNode)factory.booleanNode(value.booleanValue()));
        }
    }

    public static void setAnyMapProperty(ObjectNode json, String propertyName, Map<String, JsonNode> value) {
        if (value != null) {
            ObjectNode object = JsonUtil.objectNode();
            value.entrySet().forEach(entry -> object.set((String)entry.getKey(), (JsonNode)entry.getValue()));
            JsonUtil.setProperty(json, propertyName, (JsonNode)object);
        }
    }

    public static void setObjectMapProperty(ObjectNode json, String propertyName, Map<String, ObjectNode> value) {
        if (value != null) {
            ObjectNode object = JsonUtil.objectNode();
            value.entrySet().forEach(entry -> object.set((String)entry.getKey(), (JsonNode)entry.getValue()));
            JsonUtil.setProperty(json, propertyName, (JsonNode)object);
        }
    }

    public static void setStringMapProperty(ObjectNode json, String propertyName, Map<String, String> value) {
        if (value != null) {
            ObjectNode object = JsonUtil.objectNode();
            value.entrySet().forEach(entry -> JsonUtil.setStringProperty(object, (String)entry.getKey(), (String)entry.getValue()));
            JsonUtil.setProperty(json, propertyName, (JsonNode)object);
        }
    }

    public static void setIntegerMapProperty(ObjectNode json, String propertyName, Map<String, Integer> value) {
        if (value != null) {
            ObjectNode object = JsonUtil.objectNode();
            value.entrySet().forEach(entry -> JsonUtil.setIntegerProperty(object, (String)entry.getKey(), (Integer)entry.getValue()));
            JsonUtil.setProperty(json, propertyName, (JsonNode)object);
        }
    }

    public static void setNumberMapProperty(ObjectNode json, String propertyName, Map<String, Number> value) {
        if (value != null) {
            ObjectNode object = JsonUtil.objectNode();
            value.entrySet().forEach(entry -> JsonUtil.setNumberProperty(object, (String)entry.getKey(), (Number)entry.getValue()));
            JsonUtil.setProperty(json, propertyName, (JsonNode)object);
        }
    }

    public static void setBooleanMapProperty(ObjectNode json, String propertyName, Map<String, Boolean> value) {
        if (value != null) {
            ObjectNode object = JsonUtil.objectNode();
            value.entrySet().forEach(entry -> JsonUtil.setBooleanProperty(object, (String)entry.getKey(), (Boolean)entry.getValue()));
            JsonUtil.setProperty(json, propertyName, (JsonNode)object);
        }
    }

    public static String stringify(JsonNode json) {
        try {
            PrettyPrinter pp = new PrettyPrinter();
            return mapper.writer((com.fasterxml.jackson.core.PrettyPrinter)pp).writeValueAsString((Object)json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode parseJSON(String jsonString) {
        try {
            return mapper.readTree(jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode clone(JsonNode json) {
        try {
            TokenBuffer tb = new TokenBuffer((ObjectCodec)mapper, false);
            mapper.writeTree((JsonGenerator)tb, json);
            return (JsonNode)mapper.readTree(tb.asParser());
        }
        catch (IOException e) {
            throw new RuntimeException("Error cloning JSON node.", e);
        }
    }

    public static Collection<?> cloneCollection(Collection<?> collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return new ArrayList(collection);
    }

    public static ObjectNode objectNode() {
        return factory.objectNode();
    }

    public static ArrayNode arrayNode() {
        return factory.arrayNode();
    }

    public static TextNode textNode(String value) {
        return factory.textNode(value);
    }

    public static void addToArray(ArrayNode array, JsonNode value) {
        array.add(value);
    }

    public static boolean isPropertyDefined(JsonNode json, String propertyName) {
        if (json.isObject()) {
            ObjectNode node = (ObjectNode)json;
            return node.has(propertyName) && !node.get(propertyName).isNull();
        }
        return false;
    }

    public static boolean isString(JsonNode value) {
        if (value == null) {
            return false;
        }
        return value.isTextual();
    }

    public static boolean isJsonNode(JsonNode value) {
        return value != null;
    }

    public static boolean isObjectNode(JsonNode value) {
        if (value == null) {
            return false;
        }
        return value.isObject();
    }

    public static String toString(JsonNode value) {
        return value.asText();
    }

    public static JsonNode toJsonNode(JsonNode value) {
        return value;
    }

    public static ObjectNode toObjectNode(JsonNode value) {
        return (ObjectNode)value;
    }

    public static boolean isBoolean(JsonNode value) {
        if (value == null) {
            return false;
        }
        return value.isBoolean();
    }

    public static Boolean toBoolean(JsonNode value) {
        return value.asBoolean();
    }

    public static boolean isNumber(JsonNode value) {
        if (value == null) {
            return false;
        }
        return value.isNumber();
    }

    public static Number toNumber(JsonNode value) {
        if (value.isInt()) {
            return value.asInt();
        }
        if (value.isLong()) {
            return value.asLong();
        }
        return value.asDouble();
    }

    public static boolean isObject(JsonNode value) {
        if (value == null) {
            return false;
        }
        return value.isObject();
    }

    public static boolean isObjectWithProperty(JsonNode value, String propertyName) {
        if (value == null) {
            return false;
        }
        if (value.isObject()) {
            ObjectNode object = (ObjectNode)value;
            return object.has(propertyName);
        }
        return false;
    }

    public static boolean isObjectWithPropertyValue(JsonNode value, String propertyName, String propertyValue) {
        JsonNode pvalue;
        ObjectNode object;
        if (value == null) {
            return false;
        }
        if (value.isObject() && (object = (ObjectNode)value).has(propertyName) && !(pvalue = object.get(propertyName)).isNull() && pvalue.isTextual()) {
            String val = pvalue.asText();
            return propertyValue.equals(val);
        }
        return false;
    }

    public static ObjectNode toObject(JsonNode value) {
        return (ObjectNode)value;
    }

    public static boolean isArray(JsonNode value) {
        if (value == null) {
            return false;
        }
        return value.isArray();
    }

    public static ArrayNode toArray(JsonNode value) {
        return (ArrayNode)value;
    }

    public static List<JsonNode> toList(JsonNode value) {
        LinkedList<JsonNode> rval = new LinkedList<JsonNode>();
        ArrayNode array = (ArrayNode)value;
        for (int idx = 0; idx < array.size(); ++idx) {
            JsonNode node = array.get(idx);
            rval.add(node);
        }
        return rval;
    }

    private static class PrettyPrinter
    extends MinimalPrettyPrinter {
        private static final long serialVersionUID = -4446121026177697380L;
        private int indentLevel = 0;

        private PrettyPrinter() {
        }

        public void writeStartObject(JsonGenerator g) throws IOException {
            super.writeStartObject(g);
            ++this.indentLevel;
            g.writeRaw("\n");
        }

        public void writeEndObject(JsonGenerator g, int nrOfEntries) throws IOException {
            --this.indentLevel;
            g.writeRaw("\n");
            this.writeIndent(g);
            super.writeEndObject(g, nrOfEntries);
        }

        public void writeStartArray(JsonGenerator g) throws IOException {
            super.writeStartArray(g);
            ++this.indentLevel;
        }

        public void writeEndArray(JsonGenerator g, int nrOfValues) throws IOException {
            g.writeRaw("\n");
            --this.indentLevel;
            this.writeIndent(g);
            super.writeEndArray(g, nrOfValues);
        }

        public void beforeObjectEntries(JsonGenerator g) throws IOException {
            this.writeIndent(g);
        }

        public void beforeArrayValues(JsonGenerator g) throws IOException {
            g.writeRaw("\n");
            this.writeIndent(g);
        }

        public void writeArrayValueSeparator(JsonGenerator g) throws IOException {
            super.writeArrayValueSeparator(g);
            g.writeRaw("\n");
            this.writeIndent(g);
        }

        public void writeObjectEntrySeparator(JsonGenerator g) throws IOException {
            super.writeObjectEntrySeparator(g);
            g.writeRaw("\n");
            this.writeIndent(g);
        }

        public void writeObjectFieldValueSeparator(JsonGenerator g) throws IOException {
            super.writeObjectFieldValueSeparator(g);
            g.writeRaw(" ");
        }

        private void writeIndent(JsonGenerator g) throws IOException {
            for (int idx = 0; idx < this.indentLevel; ++idx) {
                g.writeRaw("    ");
            }
        }
    }
}

